/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectDialog;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectViewDescriptor;
import com.intellij.refactoring.extractMethodObject.MethodToMoveUsageInfo;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodObjectProcessor.class.getName()));
    @NonNls
    public static final String REFACTORING_NAME = "Extract Method Object";
    private final PsiElementFactory myElementFactory;
    protected final MyExtractMethodProcessor myExtractProcessor;
    private boolean myCreateInnerClass = true;
    private String myInnerClassName;
    private boolean myMultipleExitPoints;
    private PsiField[] myOutputFields;
    private PsiMethod myInnerMethod;
    private boolean myMadeStatic;
    private final Set<MethodToMoveUsageInfo> myUsages = new LinkedHashSet<MethodToMoveUsageInfo>();
    private PsiClass myInnerClass;
    private boolean myChangeReturnType;
    private Runnable myCopyMethodToInner;
    private static final Key<Boolean> GENERATED_RETURN = new Key("GENERATED_RETURN");

    public ExtractMethodObjectProcessor(Project project2, Editor editor, PsiElement[] elements, String innerClassName) {
        super(project2);
        this.myInnerClassName = innerClassName;
        this.myExtractProcessor = new MyExtractMethodProcessor(project2, editor, elements, null, REFACTORING_NAME, innerClassName, "refactoring.extractMethodObject");
        this.myElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "createUsageViewDescriptor"));
        }
        ExtractMethodObjectViewDescriptor extractMethodObjectViewDescriptor = new ExtractMethodObjectViewDescriptor(this.getMethod());
        if (extractMethodObjectViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "createUsageViewDescriptor"));
        }
        return extractMethodObjectViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiReference[] refs;
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        PsiClass containingClass = this.getMethod().getContainingClass();
        LocalSearchScope scope = PsiUtilCore.getVirtualFile((PsiElement)containingClass) == null ? new LocalSearchScope((PsiElement)containingClass) : GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.getMethod(), (SearchScope)scope, (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
            PsiElement element = ref.getElement();
            if (element == null || !element.isValid()) continue;
            result2.add(new UsageInfo(element));
        }
        if (this.isCreateInnerClass()) {
            final LinkedHashSet usedMethods = new LinkedHashSet();
            this.getMethod().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    PsiMethod method2 = expression.resolveMethod();
                    if (method2 != null) {
                        usedMethods.add(method2);
                    }
                }
            });
            for (PsiMethod usedMethod : usedMethods) {
                if (!usedMethod.hasModifierProperty("private") || usedMethod.hasModifierProperty("static") && !this.myExtractProcessor.isStatic()) continue;
                PsiMethod toMove = usedMethod;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)usedMethod)) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.getMethod(), (PsiElement)reference.getElement(), (boolean)false)) continue;
                    toMove = null;
                    break;
                }
                if (toMove == null) continue;
                this.myUsages.add(new MethodToMoveUsageInfo(toMove));
            }
        }
        UsageInfo[] usageInfos = result2.toArray(new UsageInfo[result2.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    public void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "performRefactoring"));
        }
        try {
            if (this.isCreateInnerClass()) {
                PsiParameter[] parameters;
                this.myInnerClass = (PsiClass)this.getMethod().getContainingClass().add((PsiElement)this.myElementFactory.createClass(this.getInnerClassName()));
                boolean isStatic = this.copyMethodModifiers() && this.notHasGeneratedFields();
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    this.replaceMethodCallExpression(this.inferTypeArguments(methodCallExpression), methodCallExpression);
                }
                if (this.myExtractProcessor.generatesConditionalExit()) {
                    this.myInnerClass.add((PsiElement)this.myElementFactory.createField("myResult", (PsiType)PsiPrimitiveType.BOOLEAN));
                    this.myInnerClass.add((PsiElement)this.myElementFactory.createMethodFromText("boolean is(){return myResult;}", (PsiElement)this.myInnerClass));
                }
                if ((parameters = this.getMethod().getParameterList().getParameters()).length > 0) {
                    this.createInnerClassConstructor(parameters);
                } else if (isStatic) {
                    PsiMethod copy = (PsiMethod)this.getMethod().copy();
                    copy.setName("invoke");
                    this.myInnerClass.add((PsiElement)copy);
                    if (this.myMultipleExitPoints) {
                        this.addOutputVariableFieldsWithGetters();
                    }
                    return;
                }
                if (this.myMultipleExitPoints) {
                    this.addOutputVariableFieldsWithGetters();
                }
                this.myCopyMethodToInner = () -> {
                    this.copyMethodWithoutParameters();
                    this.copyMethodTypeParameters();
                };
            } else {
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    methodCallExpression.replace((PsiElement)this.processMethodDeclaration(methodCallExpression.getArgumentList()));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    void moveUsedMethodsToInner() {
        if (!this.myUsages.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                WriteAction.run(() -> {
                    for (MethodToMoveUsageInfo usage : this.myUsages) {
                        PsiMember member = (PsiMember)usage.getElement();
                        LOG.assertTrue(member != null);
                        this.myInnerClass.add(member.copy());
                        member.delete();
                    }
                });
                return;
            }
            ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
            for (MethodToMoveUsageInfo usage : this.myUsages) {
                memberInfos.add(new MemberInfo((PsiMember)((PsiMethod)usage.getElement())));
            }
            final MemberSelectionPanel panel2 = new MemberSelectionPanel("&Methods to move to the extracted class", memberInfos, null);
            DialogWrapper dlg = new DialogWrapper(this.myProject, false){
                {
                    super(arg0, arg1);
                    this.init();
                    this.setTitle("Move Methods Used in Extracted Block Only");
                }

                protected JComponent createCenterPanel() {
                    return panel2;
                }
            };
            if (dlg.showAndGet()) {
                WriteAction.run(() -> {
                    for (MemberInfoBase memberInfo : panel2.getTable().getSelectedMemberInfos()) {
                        if (!memberInfo.isChecked()) continue;
                        this.myInnerClass.add(((PsiMember)memberInfo.getMember()).copy());
                        ((PsiMember)memberInfo.getMember()).delete();
                    }
                });
            }
        }
    }

    private void addOutputVariableFieldsWithGetters() throws IncorrectOperationException {
        HashMap<String, String> var2FieldNames = new HashMap<String, String>();
        Object[] outputVariables = this.myExtractProcessor.getOutputVariables();
        for (int i2 = 0; i2 < outputVariables.length; ++i2) {
            PsiField field;
            PsiVariable var = outputVariables[i2];
            PsiField outputField = this.myOutputFields[i2];
            String name = this.getPureName(var);
            LOG.assertTrue(name != null);
            if (outputField != null) {
                var2FieldNames.put(var.getName(), outputField.getName());
                this.myInnerClass.add((PsiElement)outputField);
                field = outputField;
            } else {
                field = PropertyUtil.findPropertyField((PsiClass)this.myInnerClass, (String)name, (boolean)false);
            }
            LOG.assertTrue(field != null, (Object)("i:" + i2 + "; output variables: " + Arrays.toString(outputVariables) + "; parameters: " + Arrays.toString(this.getMethod().getParameterList().getParameters()) + "; output field: " + outputField));
            this.myInnerClass.add((PsiElement)GenerateMembersUtil.generateGetterPrototype(field));
        }
        PsiCodeBlock body = this.getMethod().getBody();
        LOG.assertTrue(body != null);
        LinkedHashSet vars = new LinkedHashSet();
        final LinkedHashMap replacementMap = new LinkedHashMap();
        final ArrayList returnStatements = new ArrayList();
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReturnStatement(PsiReturnStatement statement2) {
                returnStatements.add(statement2);
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        if (this.myExtractProcessor.generatesConditionalExit()) {
            for (int i3 = 0; i3 < returnStatements.size() - 1; ++i3) {
                PsiReturnStatement condition = (PsiReturnStatement)returnStatements.get(i3);
                PsiElement container = condition.getParent();
                PsiStatement resultStmt = this.myElementFactory.createStatementFromText("myResult = true;", container);
                if (!RefactoringUtil.isLoopOrIf(container)) {
                    container.addBefore((PsiElement)resultStmt, (PsiElement)condition);
                    continue;
                }
                RefactoringUtil.putStatementInLoopBody(resultStmt, container, (PsiElement)condition);
            }
            LOG.assertTrue(!returnStatements.isEmpty());
            PsiReturnStatement returnStatement = (PsiReturnStatement)returnStatements.get(returnStatements.size() - 1);
            PsiElement container = returnStatement.getParent();
            PsiStatement resultStmt = this.myElementFactory.createStatementFromText("myResult = false;", container);
            if (!RefactoringUtil.isLoopOrIf(container)) {
                container.addBefore((PsiElement)resultStmt, (PsiElement)returnStatement);
            } else {
                RefactoringUtil.putStatementInLoopBody(resultStmt, container, (PsiElement)returnStatement);
            }
        }
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((PsiVariable[])outputVariables, var2FieldNames, vars){
            final /* synthetic */ PsiVariable[] val$outputVariables;
            final /* synthetic */ Map val$var2FieldNames;
            final /* synthetic */ LinkedHashSet val$vars;
            {
                this.val$outputVariables = psiVariableArray;
                this.val$var2FieldNames = map2;
                this.val$vars = linkedHashSet;
            }

            public void visitReturnStatement(PsiReturnStatement statement2) {
                super.visitReturnStatement(statement2);
                try {
                    PsiStatement returnThisStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText("return this;", (PsiElement)statement2);
                    returnThisStatement.putCopyableUserData(GENERATED_RETURN, (Object)true);
                    replacementMap.put(statement2, returnThisStatement);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }

            public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
                PsiElement[] declaredElements;
                super.visitDeclarationStatement(statement2);
                for (PsiElement declaredElement : declaredElements = statement2.getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiVariable)) continue;
                    for (PsiVariable variable : this.val$outputVariables) {
                        PsiVariable var = (PsiVariable)declaredElement;
                        if (!Comparing.strEqual((String)var.getName(), (String)variable.getName())) continue;
                        PsiExpression initializer = var.getInitializer();
                        if (initializer == null) {
                            replacementMap.put(var, null);
                            continue;
                        }
                        PsiStatement assignmentStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText((String)this.val$var2FieldNames.get(variable.getName()) + " = " + initializer.getText() + ";", (PsiElement)statement2);
                        replacementMap.put(var, assignmentStatement);
                    }
                }
            }

            public void visitParameter(PsiParameter parameter) {
                super.visitParameter(parameter);
                PsiElement declarationScope = parameter.getDeclarationScope();
                for (PsiVariable variable : this.val$outputVariables) {
                    if (!Comparing.strEqual((String)variable.getName(), (String)parameter.getName())) continue;
                    replacementMap.put(parameter, ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + ".this." + (String)this.val$var2FieldNames.get(variable.getName()) + " = " + parameter.getName() + ";", declarationScope));
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiLocalVariable) {
                    String var = ((PsiLocalVariable)resolved).getName();
                    for (PsiVariable variable : this.val$outputVariables) {
                        if (!Comparing.strEqual((String)variable.getName(), (String)var)) continue;
                        this.val$vars.add((PsiLocalVariable)resolved);
                        break;
                    }
                }
            }
        });
        for (PsiLocalVariable var : vars) {
            String fieldName = (String)var2FieldNames.get(var.getName());
            for (PsiReference reference : ReferencesSearch.search((PsiElement)var)) {
                reference.handleElementRename(fieldName);
            }
        }
        LinkedHashMap<PsiStatement, PsiForeachStatement> blocksToReplace = new LinkedHashMap<PsiStatement, PsiForeachStatement>();
        for (PsiElement statement2 : replacementMap.keySet()) {
            PsiElement replacement = (PsiElement)replacementMap.get(statement2);
            if (replacement != null) {
                PsiExpression returnValue;
                if (statement2 instanceof PsiParameter) {
                    PsiCodeBlock codeBlock = null;
                    PsiElement declarationScope = ((PsiParameter)statement2).getDeclarationScope();
                    if (declarationScope instanceof PsiForeachStatement) {
                        PsiStatement loopBody = ((PsiForeachStatement)declarationScope).getBody();
                        if (loopBody instanceof PsiBlockStatement) {
                            codeBlock = ((PsiBlockStatement)loopBody).getCodeBlock();
                        } else {
                            blocksToReplace.put((PsiStatement)replacement, (PsiForeachStatement)declarationScope);
                        }
                    } else if (declarationScope instanceof PsiCatchSection) {
                        codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
                    }
                    if (codeBlock == null) continue;
                    codeBlock.addBefore(replacement, codeBlock.getFirstBodyElement());
                    continue;
                }
                if (statement2 instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)statement2;
                    variable.normalizeDeclaration();
                    PsiDeclarationStatement declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiDeclarationStatement.class);
                    LOG.assertTrue(declaration != null);
                    declaration.replace(replacement);
                    continue;
                }
                if (statement2 instanceof PsiReturnStatement && !((returnValue = ((PsiReturnStatement)statement2).getReturnValue()) instanceof PsiReferenceExpression) && returnValue != null && !(returnValue instanceof PsiLiteralExpression)) {
                    statement2.getParent().addBefore((PsiElement)this.myElementFactory.createStatementFromText(returnValue.getText() + ";", (PsiElement)returnValue), statement2);
                }
                statement2.replace(replacement);
                continue;
            }
            statement2.delete();
        }
        for (PsiElement statement2 : blocksToReplace.keySet()) {
            RefactoringUtil.putStatementInLoopBody((PsiStatement)statement2, (PsiElement)blocksToReplace.get(statement2), null);
        }
        this.myChangeReturnType = true;
    }

    void runChangeSignature() {
        if (this.myCopyMethodToInner != null) {
            this.myCopyMethodToInner.run();
        }
        if (this.myChangeReturnType) {
            PsiTypeElement typeElement = ((PsiLocalVariable)((PsiDeclarationStatement)JavaPsiFacade.getElementFactory((Project)this.myProject).createStatementFromText(this.myInnerClassName + " l =null;", (PsiElement)this.myInnerClass)).getDeclaredElements()[0]).getTypeElement();
            PsiTypeElement innerMethodReturnTypeElement = this.myInnerMethod.getReturnTypeElement();
            LOG.assertTrue(innerMethodReturnTypeElement != null);
            innerMethodReturnTypeElement.replace((PsiElement)typeElement);
        }
    }

    private String getPureName(PsiVariable var) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        return styleManager.variableNameToPropertyName(var.getName(), styleManager.getVariableKind(var));
    }

    public PsiExpression processMethodDeclaration(PsiExpressionList expressionList) throws IncorrectOperationException {
        if (this.isCreateInnerClass()) {
            String typeArguments = this.getMethod().hasTypeParameters() ? "<" + StringUtil.join(Arrays.asList(this.getMethod().getTypeParameters()), typeParameter -> {
                String typeParameterName = typeParameter.getName();
                LOG.assertTrue(typeParameterName != null);
                return typeParameterName;
            }, (String)", ") + ">" : "";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText("invoke" + expressionList.getText(), null);
            return this.replaceMethodCallExpression(typeArguments, methodCallExpression);
        }
        String paramsDeclaration = this.getMethod().getParameterList().getText();
        PsiType returnType = this.getMethod().getReturnType();
        LOG.assertTrue(returnType != null);
        PsiCodeBlock methodBody2 = this.getMethod().getBody();
        LOG.assertTrue(methodBody2 != null);
        this.adjustTargetClassReferences((PsiElement)methodBody2);
        return this.myElementFactory.createExpressionFromText("new Object(){ \nprivate " + returnType.getPresentableText() + " " + this.myInnerClassName + paramsDeclaration + methodBody2.getText() + "}." + this.myInnerClassName + expressionList.getText(), null);
    }

    private PsiMethodCallExpression replaceMethodCallExpression(String inferredTypeArguments, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        String newReplacement;
        String staticqualifier = this.getMethod().hasModifierProperty("static") && this.notHasGeneratedFields() ? this.getInnerClassName() : null;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        if (staticqualifier != null) {
            newReplacement = argumentList.getExpressions().length > 0 ? "new " + staticqualifier + inferredTypeArguments + argumentList.getText() + "." : staticqualifier + ".";
        } else {
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            String qualifier = qualifierExpression != null ? qualifierExpression.getText() + "." : "";
            newReplacement = qualifier + "new " + this.getInnerClassName() + inferredTypeArguments + argumentList.getText() + ".";
        }
        return (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)this.myElementFactory.createExpressionFromText(newReplacement + "invoke()", null));
    }

    @NotNull
    private String inferTypeArguments(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceParameterList list = methodCallExpression.getMethodExpression().getParameterList();
        if (list != null && list.getTypeArguments().length > 0) {
            String string = list.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "inferTypeArguments"));
            }
            return string;
        }
        PsiTypeParameter[] methodTypeParameters = this.getMethod().getTypeParameters();
        if (methodTypeParameters.length > 0) {
            ArrayList<String> typeSignature = new ArrayList<String>();
            PsiSubstitutor substitutor = methodCallExpression.resolveMethodGenerics().getSubstitutor();
            for (PsiTypeParameter typeParameter : methodTypeParameters) {
                PsiType type = substitutor.substitute(typeParameter);
                if (type == null || PsiType.NULL.equals((Object)type)) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "inferTypeArguments"));
                    }
                    return "";
                }
                typeSignature.add(type.getPresentableText());
            }
            String string = "<" + StringUtil.join(typeSignature, (String)", ") + ">";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "inferTypeArguments"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor", "inferTypeArguments"));
        }
        return "";
    }

    @Override
    protected String getCommandName() {
        return REFACTORING_NAME;
    }

    private boolean copyMethodModifiers() throws IncorrectOperationException {
        PsiModifierList methodModifierList = this.getMethod().getModifierList();
        PsiModifierList innerClassModifierList = this.myInnerClass.getModifierList();
        LOG.assertTrue(innerClassModifierList != null);
        innerClassModifierList.setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)methodModifierList), true);
        boolean isStatic = methodModifierList.hasModifierProperty("static");
        innerClassModifierList.setModifierProperty("static", isStatic);
        return isStatic;
    }

    private void copyMethodTypeParameters() throws IncorrectOperationException {
        PsiTypeParameterList typeParameterList = this.myInnerClass.getTypeParameterList();
        LOG.assertTrue(typeParameterList != null);
        for (PsiTypeParameter parameter : this.getMethod().getTypeParameters()) {
            typeParameterList.add((PsiElement)parameter);
        }
    }

    private void copyMethodWithoutParameters() throws IncorrectOperationException {
        PsiMethod newMethod = this.myElementFactory.createMethod("invoke", this.getMethod().getReturnType());
        newMethod.getThrowsList().replace((PsiElement)this.getMethod().getThrowsList());
        PsiCodeBlock replacedMethodBody = newMethod.getBody();
        LOG.assertTrue(replacedMethodBody != null);
        PsiCodeBlock methodBody2 = this.getMethod().getBody();
        LOG.assertTrue(methodBody2 != null);
        if (this.isCreateInnerClass()) {
            this.adjustTargetClassReferences((PsiElement)methodBody2);
        }
        replacedMethodBody.replace((PsiElement)methodBody2);
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (this.myInnerClass.hasModifierProperty("static") && this.notHasGeneratedFields() ? 1 : 0) != 0);
        this.myInnerMethod = (PsiMethod)this.myInnerClass.add((PsiElement)newMethod);
    }

    private void adjustTargetClassReferences(PsiElement body) throws IncorrectOperationException {
        final PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        final PsiClass targetClass = this.getMethod().getContainingClass();
        body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReturnStatement(PsiReturnStatement statement2) {
                if (statement2.getCopyableUserData(GENERATED_RETURN) == null) {
                    super.visitReturnStatement(statement2);
                }
            }

            public void visitThisExpression(PsiThisExpression expression) {
                if (expression.getQualifier() == null) {
                    expression.replace((PsiElement)RefactoringChangeUtil.createThisExpression(manager, targetClass));
                }
            }

            public void visitSuperExpression(PsiSuperExpression expression) {
                if (expression.getQualifier() == null) {
                    expression.replace((PsiElement)RefactoringChangeUtil.createSuperExpression(manager, targetClass));
                }
            }

            public void visitClass(PsiClass aClass) {
            }
        });
    }

    private boolean notHasGeneratedFields() {
        return !this.myMultipleExitPoints && this.getMethod().getParameterList().getParametersCount() == 0;
    }

    private void createInnerClassConstructor(PsiParameter[] parameters) throws IncorrectOperationException {
        PsiMethod constructor = this.myElementFactory.createConstructor();
        PsiParameterList parameterList = constructor.getParameterList();
        for (PsiParameter parameter : parameters) {
            PsiModifierList parameterModifierList = parameter.getModifierList();
            LOG.assertTrue(parameterModifierList != null);
            String parameterName = parameter.getName();
            LOG.assertTrue(parameterName != null);
            PsiParameter parm = this.myElementFactory.createParameter(parameterName, parameter.getType());
            if (CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS) {
                PsiModifierList modifierList = parm.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.setModifierProperty("final", true);
            }
            parameterList.add((PsiElement)parm);
            PsiField field = this.createField(parm, constructor, parameterModifierList.hasModifierProperty("final"));
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
                reference.handleElementRename(field.getName());
            }
        }
        this.myInnerClass.add((PsiElement)constructor);
    }

    private PsiField createField(PsiParameter parameter, PsiMethod constructor, boolean isFinal) {
        String parameterName = parameter.getName();
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        try {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.getMethod().getProject());
            String fieldName = styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)styleManager.variableNameToPropertyName((String)parameterName, (VariableKind)VariableKind.PARAMETER), null, (PsiType)type).names[0];
            PsiField field = this.myElementFactory.createField(fieldName, type);
            PsiModifierList modifierList = field.getModifierList();
            LOG.assertTrue(modifierList != null);
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
            if (manager.isNullable((PsiModifierListOwner)parameter, false)) {
                modifierList.addAfter((PsiElement)this.myElementFactory.createAnnotationFromText("@" + manager.getDefaultNullable(), (PsiElement)field), null);
            }
            modifierList.setModifierProperty("final", isFinal);
            PsiCodeBlock methodBody2 = constructor.getBody();
            LOG.assertTrue(methodBody2 != null);
            String stmtText = Comparing.strEqual((String)parameterName, (String)fieldName) ? "this." + fieldName + " = " + parameterName + ";" : fieldName + " = " + parameterName + ";";
            PsiStatement assignmentStmt = this.myElementFactory.createStatementFromText(stmtText, (PsiElement)methodBody2);
            assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)constructor.getProject()).reformat((PsiElement)assignmentStmt);
            methodBody2.add((PsiElement)assignmentStmt);
            field = (PsiField)this.myInnerClass.add((PsiElement)field);
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected void changeInstanceAccess(Project project2) throws IncorrectOperationException {
        if (this.myMadeStatic) {
            PsiReference[] refs;
            for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myInnerMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project2), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = ref.getElement();
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                if (callExpression == null) continue;
                this.replaceMethodCallExpression(this.inferTypeArguments(callExpression), callExpression);
            }
        }
    }

    public PsiMethod getMethod() {
        return this.myExtractProcessor.getExtractedMethod();
    }

    public String getInnerClassName() {
        return this.myInnerClassName;
    }

    public void setCreateInnerClass(boolean createInnerClass) {
        this.myCreateInnerClass = createInnerClass;
    }

    public boolean isCreateInnerClass() {
        return this.myCreateInnerClass;
    }

    public MyExtractMethodProcessor getExtractProcessor() {
        return this.myExtractProcessor;
    }

    protected AbstractExtractDialog createExtractMethodObjectDialog(final MyExtractMethodProcessor processor2) {
        return new ExtractMethodObjectDialog(this.myProject, processor2.getTargetClass(), processor2.getInputVariables(), processor2.getReturnType(), processor2.getTypeParameterList(), (PsiType[])processor2.getThrownExceptions(), processor2.isStatic(), processor2.isCanBeStatic(), processor2.getElements(), this.myMultipleExitPoints){

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ArrayUtil.find((Object[])processor2.getOutputVariables(), (Object)variable) != -1;
            }
        };
    }

    public PsiClass getInnerClass() {
        return this.myInnerClass;
    }

    protected boolean isFoldingApplicable() {
        return true;
    }

    static /* synthetic */ PsiField[] access$602(ExtractMethodObjectProcessor x0, PsiField[] x1) {
        x0.myOutputFields = x1;
        return x1;
    }

    public class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        public MyExtractMethodProcessor(Project project2, Editor editor, PsiElement[] elements, PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
            super(project2, editor, elements, forcedReturnType, refactoringName, initialMethodName, helpId);
        }

        @Override
        protected boolean insertNotNullCheckIfPossible() {
            return false;
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        @Override
        protected void apply(AbstractExtractDialog dialog2) {
            super.apply(dialog2);
            ExtractMethodObjectProcessor.this.myCreateInnerClass = !(dialog2 instanceof ExtractMethodObjectDialog) || ((ExtractMethodObjectDialog)dialog2).createInnerClass();
            ExtractMethodObjectProcessor.this.myInnerClassName = ExtractMethodObjectProcessor.this.myCreateInnerClass ? StringUtil.capitalize((String)dialog2.getChosenMethodName()) : dialog2.getChosenMethodName();
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return ExtractMethodObjectProcessor.this.createExtractMethodObjectDialog(this);
        }

        @Override
        protected boolean checkOutputVariablesCount() {
            ExtractMethodObjectProcessor.this.myMultipleExitPoints = super.checkOutputVariablesCount();
            ExtractMethodObjectProcessor.access$602(ExtractMethodObjectProcessor.this, new PsiField[this.myOutputVariables.length]);
            for (int i2 = 0; i2 < this.myOutputVariables.length; ++i2) {
                PsiVariable variable = this.myOutputVariables[i2];
                if (this.myInputVariables.contains(variable)) continue;
                JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                String fieldName = styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)((ExtractMethodObjectProcessor)ExtractMethodObjectProcessor.this).getPureName((PsiVariable)variable), null, (PsiType)variable.getType()).names[0];
                try {
                    ((ExtractMethodObjectProcessor)ExtractMethodObjectProcessor.this).myOutputFields[i2] = ExtractMethodObjectProcessor.this.myElementFactory.createField(fieldName, variable.getType());
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return !ExtractMethodObjectProcessor.this.myCreateInnerClass && ExtractMethodObjectProcessor.this.myMultipleExitPoints;
        }

        @Override
        public PsiElement processMatch(Match match) throws IncorrectOperationException {
            PsiExpression expression;
            PsiMethodCallExpression methodCallExpression;
            PsiElement element;
            block5: {
                block6: {
                    PsiExpression psiExpression;
                    block7: {
                        block4: {
                            boolean makeStatic = ExtractMethodObjectProcessor.this.myInnerMethod != null && RefactoringUtil.isInStaticContext(match.getMatchStart(), this.getExtractedMethod().getContainingClass()) && !ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().hasModifierProperty("static");
                            element = super.processMatch(match);
                            if (makeStatic) {
                                ExtractMethodObjectProcessor.this.myMadeStatic = true;
                                PsiModifierList modifierList = ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().getModifierList();
                                LOG.assertTrue(modifierList != null);
                                modifierList.setModifierProperty("static", true);
                                PsiUtil.setModifierProperty((PsiModifierListOwner)ExtractMethodObjectProcessor.this.myInnerMethod, (String)"static", (boolean)true);
                            }
                            methodCallExpression = null;
                            if (!(element instanceof PsiMethodCallExpression)) break block4;
                            methodCallExpression = (PsiMethodCallExpression)element;
                            break block5;
                        }
                        if (!(element instanceof PsiExpressionStatement)) break block6;
                        expression = ((PsiExpressionStatement)element).getExpression();
                        if (!(expression instanceof PsiMethodCallExpression)) break block7;
                        methodCallExpression = (PsiMethodCallExpression)expression;
                        break block5;
                    }
                    if (!(expression instanceof PsiAssignmentExpression) || !((psiExpression = ((PsiAssignmentExpression)expression).getRExpression()) instanceof PsiMethodCallExpression)) break block5;
                    methodCallExpression = (PsiMethodCallExpression)psiExpression;
                    break block5;
                }
                if (element instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                        PsiExpression initializer;
                        if (!(declaredElement instanceof PsiLocalVariable) || !((initializer = ((PsiLocalVariable)declaredElement).getInitializer()) instanceof PsiMethodCallExpression)) continue;
                        methodCallExpression = (PsiMethodCallExpression)initializer;
                        break;
                    }
                }
            }
            if (methodCallExpression == null) {
                return element;
            }
            expression = ExtractMethodObjectProcessor.this.processMethodDeclaration(methodCallExpression.getArgumentList());
            return methodCallExpression.replace((PsiElement)expression);
        }

        @Override
        public PsiVariable[] getOutputVariables() {
            return this.myOutputVariables;
        }

        @Override
        protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
            if (ExtractMethodObjectProcessor.this.myMultipleExitPoints) {
                String object = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(StringUtil.decapitalize((String)ExtractMethodObjectProcessor.this.myInnerClassName), (PsiElement)outputVariable, true);
                PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.getMethodCall(), PsiStatement.class);
                LOG.assertTrue(methodCallStatement != null);
                PsiStatement declarationStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + " " + object + " = " + this.getMethodCall().getText() + ";", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                if (methodCallStatement instanceof PsiIfStatement) {
                    methodCallStatement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)methodCallStatement);
                    PsiExpression conditionExpression = ((PsiIfStatement)methodCallStatement).getCondition();
                    this.setMethodCall((PsiMethodCallExpression)conditionExpression.replace((PsiElement)ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(object + ".is()", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod)));
                } else if (this.myElements[0] instanceof PsiExpression) {
                    methodCallStatement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)methodCallStatement);
                } else {
                    PsiDeclarationStatement replace = (PsiDeclarationStatement)methodCallStatement.replace((PsiElement)declarationStatement);
                    this.setMethodCall((PsiMethodCallExpression)((PsiLocalVariable)replace.getDeclaredElements()[0]).getInitializer());
                }
                List<PsiVariable> usedVariables = this.myControlFlowWrapper.getUsedVariables();
                Collection<ControlFlowUtil.VariableInfo> reassigned = this.myControlFlowWrapper.getInitializedTwice();
                for (PsiVariable variable : usedVariables) {
                    String getterName;
                    String name = variable.getName();
                    LOG.assertTrue(name != null);
                    PsiStatement st = null;
                    String pureName = ExtractMethodObjectProcessor.this.getPureName(variable);
                    int varIdxInOutput = ArrayUtil.find((Object[])this.myOutputVariables, (Object)variable);
                    String string = getterName = varIdxInOutput > -1 && ExtractMethodObjectProcessor.this.myOutputFields[varIdxInOutput] != null ? GenerateMembersUtil.suggestGetterName(ExtractMethodObjectProcessor.this.myOutputFields[varIdxInOutput]) : GenerateMembersUtil.suggestGetterName(pureName, variable.getType(), this.myProject);
                    if (this.isDeclaredInside(variable)) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(variable.getType().getCanonicalText() + " " + name + " = " + object + "." + getterName + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                        if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                            PsiElement[] psiElements = ((PsiDeclarationStatement)st).getDeclaredElements();
                            assert (psiElements.length > 0);
                            PsiVariable var = (PsiVariable)psiElements[0];
                            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
                        }
                    } else if (varIdxInOutput != -1) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(name + " = " + object + "." + getterName + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                    }
                    if (st == null) continue;
                    this.addToMethodCallLocation(st);
                }
                if (this.myElements[0] instanceof PsiAssignmentExpression) {
                    this.getMethodCall().getParent().replace((PsiElement)((PsiAssignmentExpression)this.getMethodCall().getParent()).getLExpression());
                } else if (this.myElements[0] instanceof PsiPostfixExpression || this.myElements[0] instanceof PsiPrefixExpression) {
                    this.getMethodCall().getParent().replace((PsiElement)((PsiBinaryExpression)this.getMethodCall().getParent()).getLOperand());
                }
                this.rebindExitStatement(object);
            } else {
                super.declareNecessaryVariablesAfterCall(outputVariable);
            }
        }

        @Override
        protected boolean isFoldingApplicable() {
            return ExtractMethodObjectProcessor.this.isFoldingApplicable();
        }

        private void rebindExitStatement(final String objectName) {
            PsiStatement exitStatementCopy = ExtractMethodObjectProcessor.this.myExtractProcessor.myFirstExitStatementCopy;
            if (exitStatementCopy != null) {
                ExtractMethodObjectProcessor.this.myExtractProcessor.getDuplicates().clear();
                final HashMap<String, PsiVariable> outVarsNames = new HashMap<String, PsiVariable>();
                for (PsiVariable variable : this.myOutputVariables) {
                    outVarsNames.put(variable.getName(), variable);
                }
                final HashMap replaceMap = new HashMap();
                exitStatementCopy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        PsiVariable variable;
                        super.visitReferenceExpression(expression);
                        if (expression.resolve() == null && (variable = (PsiVariable)outVarsNames.get(expression.getReferenceName())) != null) {
                            String call2Getter = objectName + "." + GenerateMembersUtil.suggestGetterName(ExtractMethodObjectProcessor.this.getPureName(variable), variable.getType(), MyExtractMethodProcessor.this.myProject) + "()";
                            PsiExpression callToGetter = ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(call2Getter, (PsiElement)variable);
                            replaceMap.put(expression, callToGetter);
                        }
                    }
                });
                for (PsiElement element : replaceMap.keySet()) {
                    if (!element.isValid()) continue;
                    element.replace((PsiElement)replaceMap.get(element));
                }
            }
        }

        public boolean generatesConditionalExit() {
            return this.myGenerateConditionalExit;
        }
    }
}

