/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.InplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.IntroduceFieldCentralPanel;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class IntroduceFieldPopupPanel
extends IntroduceFieldCentralPanel {
    @Nullable
    private JComboBox myInitializerCombo;
    private JComboBox myVisibilityCombo;
    private DefaultComboBoxModel myInitialisersPlaceModel;

    public IntroduceFieldPopupPanel(PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, PsiExpression[] occurrences, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager) {
        super(parentClass, initializerExpression, localVariable, isCurrentMethodConstructor, isInvokedOnDeclaration, willBeDeclaredStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, typeSelectorManager);
    }

    @Override
    protected void initializeInitializerPlace(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
        if (initializerExpression != null) {
            this.setEnabledInitializationPlaces((PsiElement)initializerExpression);
            if (!this.myAllowInitInMethod) {
                this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
            }
        } else {
            this.myInitialisersPlaceModel.removeAllElements();
        }
        PsiMethod setUpMethod = TestFrameworks.getInstance().findSetUpMethod(this.myParentClass);
        boolean setupEnabled = this.hasSetUpChoice();
        if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD && setupEnabled && (this.myInitializerExpression != null && PsiTreeUtil.isAncestor((PsiElement)setUpMethod, (PsiElement)this.myInitializerExpression, (boolean)false) || TestFrameworks.getInstance().isTestClass(this.myParentClass))) {
            this.myInitialisersPlaceModel.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD);
        } else if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR && this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) > -1 && this.myParentClass.getConstructors().length > 0) {
            this.myInitialisersPlaceModel.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR);
        } else if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION && this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) > -1) {
            this.myInitialisersPlaceModel.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
        } else {
            this.selectInCurrentMethod();
        }
    }

    @Override
    protected void initializeControls(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
    }

    @Override
    public boolean isDeclareFinal() {
        return ourLastCbFinalState && this.allowFinal();
    }

    private void selectInCurrentMethod() {
        if (this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD) > -1) {
            this.myInitialisersPlaceModel.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        } else if (this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) > -1) {
            this.myInitialisersPlaceModel.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
        } else {
            this.myInitialisersPlaceModel.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        }
    }

    @Override
    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        if (this.myInitializerCombo != null) {
            return (BaseExpressionToFieldHandler.InitializationPlace)((Object)this.myInitializerCombo.getSelectedItem());
        }
        return (BaseExpressionToFieldHandler.InitializationPlace)((Object)this.myInitialisersPlaceModel.getElementAt(0));
    }

    @Override
    public String getFieldVisibility() {
        String visibility = JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY;
        if (visibility == null) {
            visibility = "private";
        }
        return visibility;
    }

    @Override
    protected JComponent createInitializerPlacePanel(final ItemListener itemListener, final ItemListener finalUpdater) {
        JPanel groupPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        this.myInitialisersPlaceModel = new DefaultComboBoxModel();
        this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
        this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR);
        if (TestFrameworks.getInstance().isTestClass(this.myParentClass)) {
            this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD);
        }
        this.initializeInitializerPlace(this.myInitializerExpression, InplaceIntroduceFieldPopup.ourLastInitializerPlace);
        if (this.myInitialisersPlaceModel.getSize() > 1) {
            JLabel initLabel = new JLabel(RefactoringBundle.message((String)"initialize.in.border.title") + ":");
            initLabel.setDisplayedMnemonic('i');
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.anchor = 17;
            groupPanel.add((Component)initLabel, gridBagConstraints);
            JComboBox initializersCombo = new JComboBox(this.myInitialisersPlaceModel);
            KeyboardComboSwitcher.setupActions(initializersCombo, this.myParentClass.getProject());
            initLabel.setLabelFor(initializersCombo);
            initializersCombo.setRenderer(new ListCellRendererWrapper<BaseExpressionToFieldHandler.InitializationPlace>(){

                public void customize(JList list, BaseExpressionToFieldHandler.InitializationPlace value, int index, boolean selected, boolean hasFocus) {
                    this.setText(IntroduceFieldPopupPanel.getPresentableText(value));
                }
            });
            initializersCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    itemListener.itemStateChanged(null);
                    finalUpdater.itemStateChanged(null);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.left = 0;
            groupPanel.add(initializersCombo, gridBagConstraints);
            this.myInitializerCombo = initializersCombo;
        }
        return groupPanel;
    }

    @Nullable
    private static String getPresentableText(BaseExpressionToFieldHandler.InitializationPlace value) {
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD) {
            return "current method";
        }
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
            return "constructor";
        }
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) {
            return "field declaration";
        }
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD) {
            return "setUp";
        }
        return null;
    }

    @Override
    protected boolean updateInitializationPlaceModel(boolean initializedInSetup, boolean initializedInConstructor) {
        this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
        if (!initializedInConstructor) {
            this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR);
        }
        if (initializedInSetup) {
            return true;
        }
        this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD);
        return false;
    }

    @Override
    protected boolean hasSetUpChoice() {
        return this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD) > -1;
    }

    @Override
    public void setInitializeInFieldDeclaration() {
        LOG.assertTrue(this.myInitializerCombo != null);
        this.myInitializerCombo.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
    }

    @Override
    public void setVisibility(String visibility) {
        this.myVisibilityCombo.setSelectedItem(visibility);
    }

    @Override
    protected void updateCbFinal() {
    }

    @Override
    protected boolean allowFinal() {
        boolean allowFinal;
        BaseExpressionToFieldHandler.InitializationPlace selectedItem = this.getInitializerPlace();
        boolean bl = allowFinal = selectedItem == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION || selectedItem == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR && !this.myWillBeDeclaredStatic;
        if (selectedItem == BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD && this.myIsCurrentMethodConstructor) {
            PsiMethod[] constructors = this.myParentClass.getConstructors();
            allowFinal = constructors.length <= 1;
        }
        return super.allowFinal() && allowFinal;
    }

    @Override
    protected void updateInitializerSelection() {
        if (this.myAllowInitInMethodIfAll || !this.isReplaceAllOccurrences()) {
            if (this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD) == -1) {
                this.myInitialisersPlaceModel.insertElementAt(BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD, 0);
            }
        } else {
            this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        }
    }

    @Override
    protected boolean shouldUpdateTypeSelector() {
        return false;
    }

    @Override
    protected JPanel appendCheckboxes(ItemListener itemListener) {
        JPanel panel2 = new JPanel(new GridBagLayout());
        this.appendOccurrences(itemListener, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0), panel2);
        return panel2;
    }

    @Override
    protected JPanel composeWholePanel(JComponent initializerPlacePanel, JPanel checkboxPanel) {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)initializerPlacePanel, constraints);
        ++constraints.gridy;
        panel2.add((Component)checkboxPanel, constraints);
        return panel2;
    }
}

