/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.introduceParameter.ChangedMethodCallInfo;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.introduceParameter.IntroduceParameterViewDescriptor;
import com.intellij.refactoring.introduceParameter.JavaExpressionWrapper;
import com.intellij.refactoring.introduceParameter.JavaIntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.LocalVariableOccurrenceManager;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterProcessor
extends BaseRefactoringProcessor
implements IntroduceParameterData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor");
    private final PsiMethod myMethodToReplaceIn;
    private final PsiMethod myMethodToSearchFor;
    private PsiExpression myParameterInitializer;
    private final PsiExpression myExpressionToSearch;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myRemoveLocalVariable;
    private final String myParameterName;
    private final boolean myReplaceAllOccurrences;
    private int myReplaceFieldsWithGetters;
    private final boolean myDeclareFinal;
    private final boolean myGenerateDelegate;
    private PsiType myForcedType;
    private final TIntArrayList myParametersToRemove;
    private final PsiManager myManager;
    private JavaExpressionWrapper myInitializerWrapper;
    private boolean myHasConflicts;

    public IntroduceParameterProcessor(@NotNull Project project2, PsiMethod methodToReplaceIn, @NotNull PsiMethod methodToSearchFor, PsiExpression parameterInitializer, PsiExpression expressionToSearch, PsiLocalVariable localVariable, boolean removeLocalVariable, String parameterName, boolean replaceAllOccurrences, int replaceFieldsWithGetters, boolean declareFinal, boolean generateDelegate, PsiType forcedType, @NotNull TIntArrayList parametersToRemove) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "<init>"));
        }
        if (methodToSearchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodToSearchFor", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "<init>"));
        }
        if (parametersToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersToRemove", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "<init>"));
        }
        super(project2);
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myParameterInitializer = parameterInitializer;
        this.myExpressionToSearch = expressionToSearch;
        this.myLocalVariable = localVariable;
        this.myRemoveLocalVariable = removeLocalVariable;
        this.myParameterName = parameterName;
        this.myReplaceAllOccurrences = replaceAllOccurrences;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
        this.myDeclareFinal = declareFinal;
        this.myGenerateDelegate = generateDelegate;
        this.myForcedType = forcedType;
        this.myManager = PsiManager.getInstance((Project)project2);
        this.myParametersToRemove = parametersToRemove;
        this.myInitializerWrapper = expressionToSearch == null ? null : new JavaExpressionWrapper(expressionToSearch);
    }

    public void setParameterInitializer(PsiExpression parameterInitializer) {
        this.myParameterInitializer = parameterInitializer;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "createUsageViewDescriptor"));
        }
        IntroduceParameterViewDescriptor introduceParameterViewDescriptor = new IntroduceParameterViewDescriptor(this.myMethodToSearchFor);
        if (introduceParameterViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "createUsageViewDescriptor"));
        }
        return introduceParameterViewDescriptor;
    }

    @Override
    @NotNull
    public PsiType getForcedType() {
        PsiType psiType = this.myForcedType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "getForcedType"));
        }
        return psiType;
    }

    public void setForcedType(PsiType forcedType) {
        this.myForcedType = forcedType;
    }

    @Override
    public int getReplaceFieldsWithGetters() {
        return this.myReplaceFieldsWithGetters;
    }

    public void setReplaceFieldsWithGetters(int replaceFieldsWithGetters) {
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiMethod[] overridingMethods;
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)this.myMethodToSearchFor).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            result2.add(new UsageInfo((PsiElement)overridingMethod));
        }
        if (!this.myGenerateDelegate) {
            PsiElement[] refs;
            PsiElement[] psiElementArray = refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)this.myMethodToSearchFor, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
            int n = psiElementArray.length;
            for (int overridingMethod = 0; overridingMethod < n; ++overridingMethod) {
                PsiElement ref1 = psiElementArray[overridingMethod];
                PsiElement ref = ref1.getElement();
                if (ref instanceof PsiMethod && ((PsiMethod)ref).isConstructor()) {
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)ref, ((PsiMethod)ref).getContainingClass(), this.myMethodToSearchFor);
                    result2.add(implicitUsageInfo);
                    continue;
                }
                if (ref instanceof PsiClass) {
                    result2.add(new NoConstructorClassUsageInfo((PsiClass)ref));
                    continue;
                }
                if (!IntroduceParameterUtil.insideMethodToBeReplaced(ref, this.myMethodToReplaceIn)) {
                    result2.add(new ExternalUsageInfo(ref));
                    continue;
                }
                result2.add(new ChangedMethodCallInfo(ref));
            }
        }
        if (this.myReplaceAllOccurrences) {
            for (PsiElement expr : this.getOccurrences()) {
                result2.add(new InternalUsageInfo(expr));
            }
        } else if (this.myExpressionToSearch != null && this.myExpressionToSearch.isValid()) {
            result2.add(new InternalUsageInfo((PsiElement)this.myExpressionToSearch));
        }
        UsageInfo[] usageInfos = result2.toArray(new UsageInfo[result2.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected PsiElement[] getOccurrences() {
        BaseOccurrenceManager occurrenceManager = this.myLocalVariable == null ? new ExpressionOccurrenceManager(this.myExpressionToSearch, (PsiElement)this.myMethodToReplaceIn, null) : new LocalVariableOccurrenceManager(this.myLocalVariable, null);
        return occurrenceManager.getOccurrences();
    }

    public boolean hasConflicts() {
        return this.myHasConflicts;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "preprocessUsages"));
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        AnySameNameVariables anySameNameVariables = new AnySameNameVariables();
        this.myMethodToReplaceIn.accept((PsiElementVisitor)anySameNameVariables);
        Pair<PsiElement, String> conflictPair = anySameNameVariables.getConflict();
        if (conflictPair != null) {
            conflicts.putValue(conflictPair.first, conflictPair.second);
        }
        if (!this.myGenerateDelegate) {
            this.detectAccessibilityConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        }
        if (this.myParameterInitializer != null && !this.myMethodToReplaceIn.hasModifierProperty("private")) {
            AnySupers anySupers = new AnySupers();
            this.myParameterInitializer.accept((PsiElementVisitor)anySupers);
            if (anySupers.isResult()) {
                UsageInfo[] usageInfoArray = usagesIn;
                int n = usageInfoArray.length;
                for (int j = 0; j < n; ++j) {
                    UsageInfo usageInfo = usageInfoArray[j];
                    if (usageInfo.getElement() instanceof PsiMethod || usageInfo instanceof InternalUsageInfo || PsiTreeUtil.isAncestor((PsiElement)this.myMethodToReplaceIn.getContainingClass(), (PsiElement)usageInfo.getElement(), (boolean)false)) continue;
                    String message = RefactoringBundle.message((String)"parameter.initializer.contains.0.but.not.all.calls.to.method.are.in.its.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)"super")});
                    conflicts.putValue((Object)this.myParameterInitializer, (Object)message);
                    break;
                }
            }
        }
        for (IntroduceParameterMethodUsagesProcessor processor2 : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            processor2.findConflicts(this, (UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)conflicts);
        }
        this.myHasConflicts = !conflicts.isEmpty();
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usagesIn);
    }

    private void detectAccessibilityConflicts(UsageInfo[] usageArray, MultiMap<PsiElement, String> conflicts) {
        if (this.myParameterInitializer != null) {
            ReferencedElementsCollector collector = new ReferencedElementsCollector();
            this.myParameterInitializer.accept((PsiElementVisitor)collector);
            Set result2 = collector.myResult;
            if (!result2.isEmpty()) {
                for (UsageInfo usageInfo : usageArray) {
                    if (!(usageInfo instanceof ExternalUsageInfo) || !IntroduceParameterUtil.isMethodUsage(usageInfo)) continue;
                    PsiElement place = usageInfo.getElement();
                    for (PsiElement element : result2) {
                        if (element instanceof PsiField && this.myReplaceFieldsWithGetters != 0) {
                            PsiClass psiClass = ((PsiField)element).getContainingClass();
                            LOG.assertTrue(psiClass != null);
                            PsiMethod method2 = psiClass.findMethodBySignature(GenerateMembersUtil.generateGetterPrototype((PsiField)element), true);
                            if (method2 != null) {
                                element = method2;
                            }
                        }
                        if (!(element instanceof PsiMember) || JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)element, place, null)) continue;
                        String message = RefactoringBundle.message((String)"0.is.not.accessible.from.1.value.for.introduced.parameter.in.that.method.call.will.be.incorrect", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(place), true)});
                        conflicts.putValue((Object)element, (Object)message);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.introduceParameter";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(new PsiElement[]{this.myLocalVariable, this.myExpressionToSearch});
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "getAfterData"));
        }
        PsiParameter parameter = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(this.myMethodToReplaceIn);
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement((PsiElement)parameter);
        return afterData;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "performRefactoring"));
        }
        try {
            PsiAnnotation annotation;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(this.myForcedType, this.myParameterInitializer, this.myLocalVariable);
            this.setForcedType(initializerType);
            if (this.myParameterInitializer == null) {
                LOG.assertTrue(this.myLocalVariable != null);
                this.myParameterInitializer = factory.createExpressionFromText(this.myLocalVariable.getName(), (PsiElement)this.myLocalVariable);
            } else if (this.myParameterInitializer instanceof PsiArrayInitializerExpression) {
                PsiExpression newExprArrayInitializer = RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)this.myParameterInitializer, initializerType);
                this.myParameterInitializer = (PsiExpression)this.myParameterInitializer.replace((PsiElement)newExprArrayInitializer);
            }
            this.myInitializerWrapper = new JavaExpressionWrapper(this.myParameterInitializer);
            IntroduceParameterUtil.processUsages(usages, this);
            if (this.myGenerateDelegate) {
                PsiCodeBlock block;
                PsiMethod method2;
                this.generateDelegate(this.myMethodToReplaceIn);
                if (this.myMethodToReplaceIn != this.myMethodToSearchFor && (method2 = this.generateDelegate(this.myMethodToSearchFor)).getContainingClass().isInterface() && (block = method2.getBody()) != null) {
                    block.delete();
                }
            }
            LOG.assertTrue(initializerType.isValid());
            FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(this.myParameterName, this.myMethodToReplaceIn.getBody());
            IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts(new UsageInfo((PsiElement)this.myMethodToReplaceIn), usages, this);
            if (this.myMethodToSearchFor != this.myMethodToReplaceIn) {
                IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts(new UsageInfo((PsiElement)this.myMethodToSearchFor), usages, this);
            } else if (this.myGenerateDelegate && this.myMethodToReplaceIn.findSuperMethods().length == 0 && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myMethodToReplaceIn, (boolean)true, (String[])new String[]{Override.class.getName()})) != null) {
                annotation.delete();
            }
            ChangeContextUtil.clearContextInfo((PsiElement)this.myParameterInitializer);
            for (UsageInfo usage : usages) {
                PsiElement element;
                if (usage instanceof ChangedMethodCallInfo) {
                    element = usage.getElement();
                    this.processChangedMethodCall(element);
                    continue;
                }
                if (!(usage instanceof InternalUsageInfo)) continue;
                element = usage.getElement();
                if (element instanceof PsiExpression) {
                    element = RefactoringUtil.outermostParenthesizedExpression((PsiExpression)element);
                }
                if (element == null) continue;
                if (element.getParent() instanceof PsiExpressionStatement) {
                    element.getParent().delete();
                    continue;
                }
                PsiExpression newExpr = factory.createExpressionFromText(this.myParameterName, element);
                IntroduceVariableBase.replace((PsiExpression)element, newExpr, this.myProject);
            }
            if (this.myLocalVariable != null && this.myRemoveLocalVariable) {
                this.myLocalVariable.normalizeDeclaration();
                this.myLocalVariable.getParent().delete();
            }
            fieldConflictsResolver.fix();
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
        if (this.isReplaceDuplicates()) {
            ApplicationManager.getApplication().invokeLater(() -> this.processMethodsDuplicates(), ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    protected boolean isReplaceDuplicates() {
        return true;
    }

    private void processMethodsDuplicates() {
        Runnable runnable2 = () -> {
            if (!this.myMethodToReplaceIn.isValid()) {
                return;
            }
            MethodDuplicatesHandler.invokeOnScope(this.myProject, Collections.singleton(this.myMethodToReplaceIn), new AnalysisScope(this.myMethodToReplaceIn.getContainingFile()), true);
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(runnable2), "Search method duplicates...", true, this.myProject);
    }

    private PsiMethod generateDelegate(PsiMethod methodToReplaceIn) throws IncorrectOperationException {
        PsiMethod delegate = (PsiMethod)methodToReplaceIn.copy();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        ChangeSignatureProcessor.makeEmptyBody(elementFactory, delegate);
        PsiCallExpression callExpression = ChangeSignatureProcessor.addDelegatingCallTemplate(delegate, delegate.getName());
        PsiExpressionList argumentList = callExpression.getArgumentList();
        assert (argumentList != null);
        PsiParameter[] psiParameters = methodToReplaceIn.getParameterList().getParameters();
        PsiParameter anchorParameter = IntroduceParameterProcessor.getAnchorParameter(methodToReplaceIn);
        if (psiParameters.length == 0) {
            argumentList.add((PsiElement)this.myParameterInitializer);
        } else {
            if (anchorParameter == null) {
                argumentList.add((PsiElement)this.myParameterInitializer);
            }
            for (int i2 = 0; i2 < psiParameters.length; ++i2) {
                PsiParameter psiParameter = psiParameters[i2];
                if (!this.myParametersToRemove.contains(i2)) {
                    PsiExpression expression = elementFactory.createExpressionFromText(psiParameter.getName(), (PsiElement)delegate);
                    argumentList.add((PsiElement)expression);
                }
                if (psiParameter != anchorParameter) continue;
                argumentList.add((PsiElement)this.myParameterInitializer);
            }
        }
        return (PsiMethod)methodToReplaceIn.getContainingClass().addBefore((PsiElement)delegate, (PsiElement)methodToReplaceIn);
    }

    static PsiType getInitializerType(PsiType forcedType, PsiExpression parameterInitializer, PsiLocalVariable localVariable) {
        PsiType initializerType;
        if (forcedType == null) {
            if (parameterInitializer == null) {
                if (localVariable != null) {
                    initializerType = localVariable.getType();
                } else {
                    LOG.assertTrue(false);
                    initializerType = null;
                }
            } else {
                initializerType = localVariable == null ? RefactoringUtil.getTypeByExpressionWithExpectedType(parameterInitializer) : localVariable.getType();
            }
        } else {
            initializerType = forcedType;
        }
        return initializerType;
    }

    private void processChangedMethodCall(PsiElement element) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element.getParent();
            if (this.myMethodToReplaceIn == this.myMethodToSearchFor && PsiTreeUtil.isAncestor((PsiElement)methodCall, (PsiElement)this.myParameterInitializer, (boolean)false)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)methodCall.getProject()).getElementFactory();
            PsiExpression expression = factory.createExpressionFromText(this.myParameterName, null);
            PsiExpressionList argList = methodCall.getArgumentList();
            PsiExpression[] exprs = argList.getExpressions();
            boolean first = false;
            PsiExpression anchor = null;
            if (this.myMethodToSearchFor.isVarArgs()) {
                int oldParamCount = this.myMethodToSearchFor.getParameterList().getParametersCount() - 1;
                if (exprs.length >= oldParamCount) {
                    if (oldParamCount > 1) {
                        anchor = exprs[oldParamCount - 2];
                    } else {
                        first = true;
                        anchor = null;
                    }
                } else {
                    anchor = exprs[exprs.length - 1];
                }
            } else if (exprs.length > 0) {
                anchor = exprs[exprs.length - 1];
            }
            if (anchor != null) {
                argList.addAfter((PsiElement)expression, anchor);
            } else if (first && exprs.length > 0) {
                argList.addBefore((PsiElement)expression, (PsiElement)exprs[0]);
            } else {
                argList.add((PsiElement)expression);
            }
            this.removeParametersFromCall(argList);
        } else {
            LOG.error((Object)element.getParent());
        }
    }

    private void removeParametersFromCall(PsiExpressionList argList) {
        final PsiExpression[] exprs = argList.getExpressions();
        this.myParametersToRemove.forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                if (paramNum < exprs.length) {
                    try {
                        exprs[paramNum].delete();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                return true;
            }
        });
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"introduce.parameter.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myMethodToReplaceIn)});
    }

    @Nullable
    private static PsiParameter getAnchorParameter(PsiMethod methodToReplaceIn) {
        PsiParameter anchorParameter;
        PsiParameterList parameterList = methodToReplaceIn.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        if (!methodToReplaceIn.isVarArgs()) {
            anchorParameter = length > 0 ? parameters[length - 1] : null;
        } else {
            LOG.assertTrue(length > 0);
            LOG.assertTrue(parameters[length - 1].isVarArgs());
            anchorParameter = length > 1 ? parameters[length - 2] : null;
        }
        return anchorParameter;
    }

    @Override
    public PsiMethod getMethodToReplaceIn() {
        return this.myMethodToReplaceIn;
    }

    @Override
    @NotNull
    public PsiMethod getMethodToSearchFor() {
        PsiMethod psiMethod = this.myMethodToSearchFor;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "getMethodToSearchFor"));
        }
        return psiMethod;
    }

    @Override
    public JavaExpressionWrapper getParameterInitializer() {
        return this.myInitializerWrapper;
    }

    @Override
    @NotNull
    public String getParameterName() {
        String string = this.myParameterName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "getParameterName"));
        }
        return string;
    }

    @Override
    public boolean isDeclareFinal() {
        return this.myDeclareFinal;
    }

    @Override
    public boolean isGenerateDelegate() {
        return this.myGenerateDelegate;
    }

    @Override
    @NotNull
    public TIntArrayList getParametersToRemove() {
        TIntArrayList tIntArrayList = this.myParametersToRemove;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "getParametersToRemove"));
        }
        return tIntArrayList;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor", "getProject"));
        }
        return project2;
    }

    public class AnySameNameVariables
    extends JavaRecursiveElementWalkingVisitor {
        private Pair<PsiElement, String> conflict;

        public Pair<PsiElement, String> getConflict() {
            return this.conflict;
        }

        public void visitVariable(PsiVariable variable) {
            if (variable == IntroduceParameterProcessor.this.myLocalVariable) {
                return;
            }
            if (variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() == IntroduceParameterProcessor.this.myMethodToReplaceIn && IntroduceParameterProcessor.this.getParametersToRemove().contains(IntroduceParameterProcessor.this.myMethodToReplaceIn.getParameterList().getParameterIndex((PsiParameter)variable))) {
                return;
            }
            if (IntroduceParameterProcessor.this.myParameterName.equals(variable.getName())) {
                String descr = RefactoringBundle.message((String)"there.is.already.a.0.it.will.conflict.with.an.introduced.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, true)});
                this.conflict = Pair.create((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)descr));
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitElement(PsiElement element) {
            if (this.conflict != null) {
                return;
            }
            super.visitElement(element);
        }
    }

    public static class AnySupers
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myResult;

        public void visitSuperExpression(PsiSuperExpression expression) {
            this.myResult = true;
        }

        public boolean isResult() {
            return this.myResult;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitElement((PsiElement)expression);
        }
    }

    private static class ReferencedElementsCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiElement> myResult = new HashSet();

        private ReferencedElementsCollector() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement element = reference.resolve();
            if (element != null) {
                this.myResult.add(element);
            }
        }
    }
}

