/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.FinalListener;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVariableInplaceIntroducer
extends AbstractJavaInplaceIntroducer {
    private SmartPsiElementPointer<PsiDeclarationStatement> myPointer;
    private JCheckBox myCanBeFinalCb;
    private final IntroduceVariableSettings mySettings;
    private final SmartPsiElementPointer<PsiElement> myChosenAnchor;
    private final boolean myCantChangeFinalModifier;
    private final boolean myHasTypeSuggestion;
    private ResolveSnapshotProvider.ResolveSnapshot myConflictResolver;
    private final TypeExpression myExpression;
    private final boolean myReplaceSelf;
    private boolean myDeleteSelf = true;
    private final boolean mySkipTypeExpressionOnStart;

    public JavaVariableInplaceIntroducer(Project project2, IntroduceVariableSettings settings, PsiElement chosenAnchor, Editor editor, PsiExpression expr, boolean cantChangeFinalModifier, PsiExpression[] occurrences, TypeSelectorManagerImpl selectorManager, String title) {
        super(project2, editor, RefactoringUtil.outermostParenthesizedExpression(expr), null, occurrences, selectorManager, title);
        this.mySettings = settings;
        this.myChosenAnchor = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(chosenAnchor);
        this.myCantChangeFinalModifier = cantChangeFinalModifier;
        this.myHasTypeSuggestion = selectorManager.getTypesForAll().length > 1;
        this.myTitle = title;
        this.myExpression = new TypeExpression(this.myProject, this.isReplaceAllOccurrences() ? this.myTypeSelectorManager.getTypesForAll() : this.myTypeSelectorManager.getTypesForOne());
        List<RangeMarker> rangeMarkers = this.getOccurrenceMarkers();
        editor.putUserData(ReassignVariableUtil.OCCURRENCES_KEY, (Object)rangeMarkers.toArray(new RangeMarker[rangeMarkers.size()]));
        this.myReplaceSelf = ((PsiExpression)this.myExpr).getParent() instanceof PsiExpressionStatement;
        this.mySkipTypeExpressionOnStart = !(this.myExpr instanceof PsiFunctionalExpression) || !this.myReplaceSelf;
    }

    @Override
    protected void beforeTemplateStart() {
        if (!this.mySkipTypeExpressionOnStart) {
            PsiTypeElement typeElement;
            PsiVariable variable = this.getVariable();
            PsiTypeElement psiTypeElement = typeElement = variable != null ? variable.getTypeElement() : null;
            if (typeElement != null) {
                this.myEditor.getCaretModel().moveToOffset(typeElement.getTextOffset());
            }
        }
        super.beforeTemplateStart();
    }

    @Override
    protected void onRenameTemplateStarted() {
        ResolveSnapshotProvider resolveSnapshotProvider = (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(this.myScope.getLanguage());
        this.myConflictResolver = resolveSnapshotProvider != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
    }

    @Override
    @Nullable
    protected PsiVariable getVariable() {
        PsiDeclarationStatement declarationStatement;
        PsiDeclarationStatement psiDeclarationStatement = declarationStatement = this.myPointer != null ? (PsiDeclarationStatement)this.myPointer.getElement() : null;
        if (declarationStatement != null) {
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            return declaredElements.length == 0 ? null : (PsiVariable)declaredElements[0];
        }
        return null;
    }

    @Override
    protected String getActionName() {
        return "IntroduceVariable";
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.extractVariable";
    }

    @Override
    protected void restoreState(@NotNull PsiVariable psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/refactoring/introduceVariable/JavaVariableInplaceIntroducer", "restoreState"));
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState(psiField);
    }

    @Override
    protected boolean ensureValid() {
        PsiVariable variable = this.getVariable();
        return variable != null && this.isIdentifier(this.getInputName(), variable.getLanguage());
    }

    @Override
    protected void performCleanup() {
        super.performCleanup();
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> super.restoreState(variable), null, null);
        }
    }

    @Override
    protected void deleteTemplateField(PsiVariable variable) {
        if (!this.myDeleteSelf) {
            return;
        }
        if (this.myReplaceSelf) {
            variable.replace((PsiElement)variable.getInitializer());
        } else {
            super.deleteTemplateField(variable);
        }
    }

    @Override
    protected PsiExpression getBeforeExpr() {
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            return variable.getInitializer();
        }
        return (PsiExpression)super.getBeforeExpr();
    }

    @Override
    protected void performIntroduce() {
        PsiVariable psiVariable = this.getVariable();
        if (psiVariable == null) {
            return;
        }
        TypeSelectorManagerImpl.typeSelected(psiVariable.getType(), this.myTypeSelectorManager.getDefaultType());
        if (this.myCanBeFinalCb != null) {
            JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = psiVariable.hasModifierProperty("final");
        }
        Document document = this.myEditor.getDocument();
        LOG.assertTrue(psiVariable.isValid());
        JavaVariableInplaceIntroducer.adjustLine(psiVariable, document);
        int startOffset = this.getExprMarker() != null && this.getExprMarker().isValid() ? this.getExprMarker().getStartOffset() : psiVariable.getTextOffset();
        PsiFile file2 = psiVariable.getContainingFile();
        PsiReference referenceAt = file2.findReferenceAt(startOffset);
        if (referenceAt != null && referenceAt.resolve() instanceof PsiVariable) {
            startOffset = referenceAt.getElement().getTextRange().getEndOffset();
        } else {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
            if (declarationStatement != null) {
                startOffset = declarationStatement.getTextRange().getEndOffset();
            }
        }
        this.myEditor.getCaretModel().moveToOffset(startOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (this.myConflictResolver != null && this.myInsertedName != null && this.isIdentifier(this.myInsertedName, psiVariable.getLanguage())) {
                this.myConflictResolver.apply(psiVariable.getName());
            }
            if (psiVariable.getInitializer() != null) {
                JavaVariableInplaceIntroducer.appendTypeCasts(this.getOccurrenceMarkers(), file2, this.myProject, psiVariable);
            }
        });
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return this.mySettings.isReplaceAllOccurrences();
    }

    @Override
    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return handler2 instanceof IntroduceVariableHandler && super.startsOnTheSameElement(handler2, element);
    }

    @Override
    @Nullable
    protected JComponent getComponent() {
        if (this.myCantChangeFinalModifier) {
            return null;
        }
        this.myCanBeFinalCb = new NonFocusableCheckBox("Declare final");
        this.myCanBeFinalCb.setSelected(this.createFinals());
        this.myCanBeFinalCb.setMnemonic('f');
        final FinalListener finalListener = new FinalListener(this.myEditor);
        this.myCanBeFinalCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new WriteCommandAction(JavaVariableInplaceIntroducer.this.myProject, JavaVariableInplaceIntroducer.this.getCommandName(), JavaVariableInplaceIntroducer.this.getCommandName(), new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/introduceVariable/JavaVariableInplaceIntroducer$1$1", "run"));
                        }
                        PsiDocumentManager.getInstance((Project)JavaVariableInplaceIntroducer.this.myProject).commitDocument(JavaVariableInplaceIntroducer.this.myEditor.getDocument());
                        PsiVariable variable = JavaVariableInplaceIntroducer.this.getVariable();
                        if (variable != null) {
                            finalListener.perform(JavaVariableInplaceIntroducer.this.myCanBeFinalCb.isSelected(), variable);
                        }
                    }
                }.execute();
            }
        });
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(null);
        if (this.myCanBeFinalCb != null) {
            panel2.add((Component)this.myCanBeFinalCb, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5), 0, 0));
        }
        panel2.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    @Override
    protected void addAdditionalVariables(TemplateBuilderImpl builder) {
        PsiTypeElement typeElement;
        PsiVariable variable = this.getVariable();
        if (variable != null && (typeElement = variable.getTypeElement()) != null) {
            builder.replaceElement((PsiElement)typeElement, "Variable_Type", AbstractJavaInplaceIntroducer.createExpression(this.myExpression, typeElement.getText()), true, this.mySkipTypeExpressionOnStart);
        }
    }

    @Override
    protected void collectAdditionalElementsToRename(List<Pair<PsiElement, TextRange>> stringUsages) {
        if (this.isReplaceAllOccurrences()) {
            for (PsiExpression expression : (PsiExpression[])this.getOccurrences()) {
                LOG.assertTrue(expression.isValid(), (Object)expression.getText());
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expression, (Object)new TextRange(0, expression.getTextLength())));
            }
        } else if (this.getExpr() != null && !this.myReplaceSelf && ((PsiExpression)this.getExpr()).getParent() != this.getVariable()) {
            PsiExpression expr = (PsiExpression)this.getExpr();
            LOG.assertTrue(expr.isValid(), (Object)expr.getText());
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expr, (Object)new TextRange(0, expr.getTextLength())));
        }
    }

    @Override
    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
        PsiExpression expr;
        if (!this.isReplaceAllOccurrences() && ((expr = (PsiExpression)this.getExpr()) == null && !this.myReplaceSelf || expr != null && expr.getParent() == this.getVariable())) {
            return;
        }
        super.addReferenceAtCaret(refs);
    }

    private static void appendTypeCasts(List<RangeMarker> occurrenceMarkers, PsiFile file2, Project project2, @Nullable PsiVariable psiVariable) {
        if (occurrenceMarkers != null) {
            for (RangeMarker occurrenceMarker : occurrenceMarkers) {
                PsiElement refVariableElement = file2.findElementAt(occurrenceMarker.getStartOffset());
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiReferenceExpression.class);
                if (referenceExpression == null) continue;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiVariable) {
                    JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project2, (PsiVariable)parent);
                    continue;
                }
                if (!(parent instanceof PsiReferenceExpression) || psiVariable == null) continue;
                PsiExpression initializer = psiVariable.getInitializer();
                LOG.assertTrue(initializer != null);
                PsiType type = initializer.getType();
                if (((PsiReferenceExpression)parent).resolve() != null || type == null) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                PsiExpression castedExpr = elementFactory.createExpressionFromText("((" + type.getCanonicalText() + ")" + referenceExpression.getText() + ")", parent);
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(referenceExpression.replace((PsiElement)castedExpr));
            }
        }
        if (psiVariable != null && psiVariable.isValid()) {
            JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project2, psiVariable);
        }
    }

    private static void createCastInVariableDeclaration(Project project2, PsiVariable psiVariable) {
        PsiExpression initializer = psiVariable.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiType type = psiVariable.getType();
        PsiType initializerType = initializer.getType();
        if (initializerType != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)initializerType) && !PsiTypesUtil.hasUnresolvedComponents((PsiType)type)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression castExpr = elementFactory.createExpressionFromText("(" + type.getCanonicalText() + ")" + initializer.getText(), (PsiElement)psiVariable);
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(initializer.replace((PsiElement)castExpr));
        }
    }

    @Nullable
    private static String getAdvertisementText(PsiDeclarationStatement declaration, PsiType type, boolean hasTypeSuggestion) {
        Shortcut[] shortcuts;
        VariablesProcessor processor2 = ReassignVariableUtil.findVariablesOfType(declaration, type);
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        if (processor2.size() > 0 && (shortcuts = keymap.getShortcuts("IntroduceVariable")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to reassign existing variable";
        }
        if (hasTypeSuggestion && (shortcuts = keymap.getShortcuts("PreviousTemplateVariable")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to change type";
        }
        return null;
    }

    protected boolean createFinals() {
        return IntroduceVariableBase.createFinals(this.myProject);
    }

    public static void adjustLine(PsiVariable psiVariable, Document document) {
        int modifierListOffset = psiVariable.getTextRange().getStartOffset();
        int varLineNumber = document.getLineNumber(modifierListOffset);
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager.getInstance((Project)psiVariable.getProject()).doPostponedOperationsAndUnblockDocument(document);
            CodeStyleManager.getInstance((Project)psiVariable.getProject()).adjustLineIndent(document, document.getLineStartOffset(varLineNumber));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names, PsiType psiType) {
        PsiIdentifier identifier;
        PsiVariable variable = IntroduceVariableBase.introduce(this.myProject, (PsiExpression)this.myExpr, this.myEditor, this.myChosenAnchor.getElement(), (PsiExpression[])this.getOccurrences(), this.mySettings);
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
        this.myPointer = declarationStatement != null ? SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)declarationStatement) : null;
        this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, this.myPointer);
        this.setAdvertisementText(JavaVariableInplaceIntroducer.getAdvertisementText(declarationStatement, variable.getType(), this.myHasTypeSuggestion));
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
        PsiVariable restoredVar = this.getVariable();
        if (restoredVar != null) {
            variable = restoredVar;
        }
        if (this.isReplaceAllOccurrences()) {
            ArrayList<RangeMarker> occurrences = new ArrayList<RangeMarker>();
            ReferencesSearch.search((PsiElement)variable).forEach(reference -> occurrences.add(this.createMarker(reference.getElement())));
            this.setOccurrenceMarkers(occurrences);
        }
        if ((identifier = variable.getNameIdentifier()) != null) {
            this.myEditor.getCaretModel().moveToOffset(identifier.getTextOffset());
        }
        try {
            this.myDeleteSelf = false;
            this.restoreState(variable);
        }
        finally {
            this.myDeleteSelf = true;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
        this.initOccurrencesMarkers();
        return variable;
    }

    @Override
    protected int getCaretOffset() {
        PsiIdentifier identifier;
        PsiVariable variable = this.getVariable();
        if (variable != null && (identifier = variable.getNameIdentifier()) != null) {
            return identifier.getTextOffset();
        }
        return super.getCaretOffset();
    }

    @Override
    public void finish(boolean success) {
        super.finish(success);
        this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, null);
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceVariableBase.getSuggestedName((PsiType)defaultType, (PsiExpression)((PsiExpression)this.myExpr)).names;
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.LOCAL_VARIABLE;
    }
}

