/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.refactoring.introduceparameterobject.JavaIntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class ConstructorJavadocUsageInfo
extends FixableUsageInfo {
    private final PsiMethod myMethod;
    private final JavaIntroduceParameterObjectClassDescriptor myDescriptor;

    public ConstructorJavadocUsageInfo(PsiMethod method2, JavaIntroduceParameterObjectClassDescriptor descriptor) {
        super((PsiElement)method2);
        this.myMethod = method2;
        this.myDescriptor = descriptor;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiDocComment docComment = this.myMethod.getDocComment();
        if (docComment != null) {
            PsiDocTag[] paramTags;
            ArrayList<PsiDocTag> mergedTags = new ArrayList<PsiDocTag>();
            for (PsiDocTag paramTag : paramTags = docComment.findTagsByName("param")) {
                int parameterIndex;
                PsiElement resolve2;
                PsiReference reference;
                PsiElement[] dataElements = paramTag.getDataElements();
                if (dataElements.length <= 0 || dataElements[0] instanceof PsiDocParamRef && (reference = dataElements[0].getReference()) != null && (resolve2 = reference.resolve()) instanceof PsiParameter && this.myDescriptor.getParameterInfo(parameterIndex = this.myMethod.getParameterList().getParameterIndex((PsiParameter)resolve2)) == null) continue;
                mergedTags.add((PsiDocTag)paramTag.copy());
            }
            PsiMethod compatibleParamObjectConstructor = null;
            PsiMethod existingConstructor = (PsiMethod)this.myDescriptor.getExistingClassCompatibleConstructor();
            if (existingConstructor != null && existingConstructor.getDocComment() == null) {
                compatibleParamObjectConstructor = existingConstructor;
            } else if (!this.myDescriptor.isUseExistingClass()) {
                compatibleParamObjectConstructor = this.myDescriptor.getExistingClass().getConstructors()[0];
            }
            if (compatibleParamObjectConstructor != null) {
                PsiDocComment psiDocComment = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject()).createDocCommentFromText("/**\n*/");
                psiDocComment = (PsiDocComment)compatibleParamObjectConstructor.addBefore((PsiElement)psiDocComment, compatibleParamObjectConstructor.getFirstChild());
                for (PsiDocTag tag : mergedTags) {
                    psiDocComment.add((PsiElement)tag);
                }
            }
        }
    }
}

