/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.TitledHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ExtractIncludeDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtractIncludeFileBase<T extends PsiElement>
implements RefactoringActionHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.lang.ExtractIncludeFileBase");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.include.file.title");
    protected PsiFile myIncludingFile;
    public static final String HELP_ID = "refactoring.extractInclude";

    protected abstract void doReplaceRange(String var1, T var2, T var3);

    @NotNull
    protected String doExtract(PsiDirectory targetDirectory, String targetfileName, T first, T last, Language includingLanguage) throws IncorrectOperationException {
        PsiFile file2 = targetDirectory.createFile(targetfileName);
        Project project2 = targetDirectory.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = documentManager.getDocument(file2);
        document.replaceString(0, document.getTextLength(), (CharSequence)first.getText().trim());
        documentManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project2).getProject()).reformat((PsiElement)file2);
        String relativePath = PsiFileSystemItemUtil.getRelativePath((PsiFileSystemItem)first.getContainingFile(), (PsiFileSystemItem)file2);
        if (relativePath == null) {
            throw new IncorrectOperationException("Cannot extract!");
        }
        String string = relativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "doExtract"));
        }
        return string;
    }

    protected abstract boolean verifyChildRange(T var1, T var2);

    private void replaceDuplicates(String includePath, List<IncludeDuplicate<T>> duplicates, Editor editor, Project project2) {
        String message;
        int exitCode;
        if (duplicates.size() > 0 && (exitCode = Messages.showYesNoDialog((Project)project2, (String)(message = RefactoringBundle.message((String)"idea.has.found.fragments.that.can.be.replaced.with.include.directive", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()})), (String)this.getRefactoringName(), (Icon)Messages.getInformationIcon())) == 0) {
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                boolean replaceAll = false;
                for (IncludeDuplicate pair : duplicates) {
                    if (!replaceAll) {
                        ExtractIncludeFileBase.highlightInEditor(project2, pair, editor);
                        ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"replace.fragment"), project2);
                        promptDialog.show();
                        int promptResult = promptDialog.getExitCode();
                        if (promptResult == 2) continue;
                        if (promptResult == 1) break;
                        if (promptResult == 0) {
                            this.doReplaceRange(includePath, pair.getStart(), pair.getEnd());
                            continue;
                        }
                        if (promptResult == 3) {
                            this.doReplaceRange(includePath, pair.getStart(), pair.getEnd());
                            replaceAll = true;
                            continue;
                        }
                        LOG.error("Unknown return status");
                        continue;
                    }
                    this.doReplaceRange(includePath, pair.getStart(), pair.getEnd());
                }
            }, RefactoringBundle.message((String)"remove.duplicates.command"), null);
        }
    }

    private static void highlightInEditor(Project project2, IncludeDuplicate pair, Editor editor) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        int startOffset = pair.getStart().getTextRange().getStartOffset();
        int endOffset = pair.getEnd().getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor, startOffset, endOffset, attributes, true, null);
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(startOffset);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "invoke"));
        }
    }

    @NotNull
    protected Language getLanguageForExtract(PsiElement firstExtracted) {
        Language language = firstExtracted.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "getLanguageForExtract"));
        }
        return language;
    }

    @Nullable
    private static FileType getFileType(Language language) {
        FileType[] fileTypes;
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || !language.equals(((LanguageFileType)fileType).getLanguage())) continue;
            return fileType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "invoke"));
        }
        try {
            this.myIncludingFile = file2;
            this.doInvoke(project2, editor, file2);
        }
        finally {
            this.myIncludingFile = null;
        }
    }

    protected void doInvoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        int end;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "doInvoke"));
        }
        if (!editor.getSelectionModel().hasSelection()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"no.selection"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        int start = editor.getSelectionModel().getSelectionStart();
        Pair<T, T> children2 = this.findPairToExtract(start, end = editor.getSelectionModel().getSelectionEnd());
        if (children2 == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selection.does.not.form.a.fragment.for.extraction"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!this.verifyChildRange((PsiElement)children2.getFirst(), (PsiElement)children2.getSecond())) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.extract.selected.elements.into.include.file"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        FileType fileType = ExtractIncludeFileBase.getFileType(this.getLanguageForExtract((PsiElement)children2.getFirst()));
        if (!(fileType instanceof LanguageFileType)) {
            String message = RefactoringBundle.message((String)"the.language.for.selected.elements.has.no.associated.file.type");
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)file2) || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ExtractIncludeDialog dialog2 = this.createDialog(file2.getContainingDirectory(), this.getExtractExtension(fileType, (PsiElement)children2.first));
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            PsiDirectory targetDirectory = dialog2.getTargetDirectory();
            LOG.assertTrue(targetDirectory != null);
            String targetfileName = dialog2.getTargetFileName();
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "lambda$doInvoke$4"));
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "lambda$null$3"));
                    }
                    try {
                        ArrayList duplicates = new ArrayList();
                        PsiElement first = (PsiElement)children2.getFirst();
                        PsiElement second = (PsiElement)children2.getSecond();
                        PsiEquivalenceUtil.findChildRangeDuplicates((PsiElement)first, (PsiElement)second, (PsiElement)file2, (start1, end1) -> duplicates.add(new IncludeDuplicate((PsiElement)start1, (PsiElement)end1, null)));
                        String includePath = this.processPrimaryFragment(first, second, targetDirectory, targetfileName, file2);
                        editor.getCaretModel().moveToOffset(first.getTextRange().getStartOffset());
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/ExtractIncludeFileBase", "lambda$null$2"));
                            }
                            this.replaceDuplicates(includePath, duplicates, editor, project2);
                        });
                    }
                    catch (IncorrectOperationException e) {
                        CommonRefactoringUtil.showErrorMessage((String)this.getRefactoringName(), (String)e.getMessage(), null, (Project)project2);
                    }
                    editor.getSelectionModel().removeSelection();
                });
            }, this.getRefactoringName(), null);
        }
    }

    protected ExtractIncludeDialog createDialog(PsiDirectory containingDirectory, String extractExtension) {
        return new ExtractIncludeDialog(containingDirectory, extractExtension);
    }

    @Nullable
    protected abstract Pair<T, T> findPairToExtract(int var1, int var2);

    @NonNls
    protected String getExtractExtension(FileType extractFileType, T first) {
        return extractFileType.getDefaultExtension();
    }

    @Deprecated
    public boolean isValidRange(T firstToExtract, T lastToExtract) {
        return this.verifyChildRange(firstToExtract, lastToExtract);
    }

    public String processPrimaryFragment(T firstToExtract, T lastToExtract, PsiDirectory targetDirectory, String targetfileName, PsiFile srcFile) throws IncorrectOperationException {
        String includePath = this.doExtract(targetDirectory, targetfileName, firstToExtract, lastToExtract, srcFile.getLanguage());
        this.doReplaceRange(includePath, firstToExtract, lastToExtract);
        return includePath;
    }

    public String getActionTitle() {
        return "Extract Include File...";
    }

    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    private static class IncludeDuplicate<E extends PsiElement> {
        private final SmartPsiElementPointer<E> myStart;
        private final SmartPsiElementPointer<E> myEnd;

        private IncludeDuplicate(E start, E end) {
            this.myStart = SmartPointerManager.getInstance((Project)start.getProject()).createSmartPsiElementPointer(start);
            this.myEnd = SmartPointerManager.getInstance((Project)start.getProject()).createSmartPsiElementPointer(end);
        }

        E getStart() {
            return (E)this.myStart.getElement();
        }

        E getEnd() {
            return (E)this.myEnd.getElement();
        }

        /* synthetic */ IncludeDuplicate(PsiElement x0, PsiElement x1, 1 x2) {
            this(x0, x1);
        }
    }
}

