/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionManagerImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.deployment.LocalDeploymentImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionDataNotAvailableException;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionImpl<D extends DeploymentConfiguration>
implements ServerConnection<D> {
    private static final Logger LOG = Logger.getInstance(ServerConnectionImpl.class);
    private final RemoteServer<?> myServer;
    private final ServerConnector<D> myConnector;
    private final ServerConnectionEventDispatcher myEventDispatcher;
    private final ServerConnectionManagerImpl myConnectionManager;
    private volatile ConnectionStatus myStatus = ConnectionStatus.DISCONNECTED;
    private volatile String myStatusText;
    private volatile ServerRuntimeInstance<D> myRuntimeInstance;
    private final Map<String, DeploymentImpl> myRemoteDeployments = new HashMap<String, DeploymentImpl>();
    private final Map<String, LocalDeploymentImpl> myLocalDeployments = new HashMap<String, LocalDeploymentImpl>();
    private final Map<String, DeploymentLogManagerImpl> myLogManagers = ContainerUtil.newConcurrentMap();

    public ServerConnectionImpl(RemoteServer<?> server, ServerConnector connector, @Nullable ServerConnectionManagerImpl connectionManager, ServerConnectionEventDispatcher eventDispatcher) {
        this.myServer = server;
        this.myConnector = connector;
        this.myConnectionManager = connectionManager;
        this.myEventDispatcher = eventDispatcher;
    }

    @NotNull
    public RemoteServer<?> getServer() {
        RemoteServer<?> remoteServer = this.myServer;
        if (remoteServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getServer"));
        }
        return remoteServer;
    }

    @NotNull
    public ConnectionStatus getStatus() {
        ConnectionStatus connectionStatus = this.myStatus;
        if (connectionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getStatus"));
        }
        return connectionStatus;
    }

    @NotNull
    public String getStatusText() {
        String string = this.myStatusText != null ? this.myStatusText : this.myStatus.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getStatusText"));
        }
        return string;
    }

    public void connect(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onFinished", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "connect"));
        }
        this.doDisconnect();
        this.connectIfNeeded(new ServerConnector.ConnectionCallback<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$1", "connected"));
                }
                onFinished.run();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$1", "errorOccurred"));
                }
                onFinished.run();
            }
        });
    }

    public void disconnect() {
        if (this.myConnectionManager != null) {
            this.myConnectionManager.removeConnection(this.myServer);
        }
        this.doDisconnect();
    }

    private void doDisconnect() {
        if (this.myStatus == ConnectionStatus.CONNECTED) {
            if (this.myRuntimeInstance != null) {
                this.myRuntimeInstance.disconnect();
                this.myRuntimeInstance = null;
            }
            this.setStatus(ConnectionStatus.DISCONNECTED);
            for (DeploymentLogManagerImpl logManager : this.myLogManagers.values()) {
                logManager.disposeLogs();
            }
        }
    }

    public void deploy(final @NotNull DeploymentTask<D> task, final @NotNull java.util.function.Consumer<String> onDeploymentStarted) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "deploy"));
        }
        if (onDeploymentStarted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDeploymentStarted", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "deploy"));
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$2", "connected"));
                }
                LocalDeploymentImpl deployment = new LocalDeploymentImpl(instance, ServerConnectionImpl.this, DeploymentStatus.DEPLOYING, null, null, task);
                String deploymentName = deployment.getName();
                Map map = ServerConnectionImpl.this.myLocalDeployments;
                synchronized (map) {
                    ServerConnectionImpl.this.myLocalDeployments.put(deploymentName, deployment);
                }
                DeploymentLogManagerImpl logManager = new DeploymentLogManagerImpl(task.getProject(), new ChangeListener()).withMainHandlerVisible(true);
                LoggingHandlerImpl handler2 = logManager.getMainLoggingHandler();
                ServerConnectionImpl.this.myLogManagers.put(deploymentName, logManager);
                handler2.printlnSystemMessage("Deploying '" + deploymentName + "'...");
                onDeploymentStarted.accept(deploymentName);
                instance.deploy(task, (DeploymentLogManager)logManager, (ServerRuntimeInstance.DeploymentOperationCallback)new DeploymentOperationCallbackImpl(deploymentName, (DeploymentTaskImpl)task, handler2, deployment));
            }
        });
    }

    @Nullable
    public DeploymentLogManager getLogManager(@NotNull Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getLogManager"));
        }
        return this.myLogManagers.get(deployment.getName());
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project2, @NotNull Deployment deployment) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getOrCreateLogManager"));
        }
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getOrCreateLogManager"));
        }
        DeploymentLogManagerImpl result2 = (DeploymentLogManagerImpl)this.getLogManager(deployment);
        if (result2 == null) {
            result2 = new DeploymentLogManagerImpl(project2, new ChangeListener());
            this.myLogManagers.put(deployment.getName(), result2);
        }
        DeploymentLogManagerImpl deploymentLogManagerImpl = result2;
        if (deploymentLogManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getOrCreateLogManager"));
        }
        return deploymentLogManagerImpl;
    }

    public void computeDeployments(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onFinished", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "computeDeployments"));
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$3", "connected"));
                }
                ServerConnectionImpl.this.computeDeployments(instance, onFinished);
            }
        });
    }

    private void computeDeployments(ServerRuntimeInstance<D> instance, final Runnable onFinished) {
        instance.computeDeployments(new ServerRuntimeInstance.ComputeDeploymentsCallback(){
            private final List<DeploymentImpl> myDeployments = new ArrayList<DeploymentImpl>();

            public void addDeployment(@NotNull String deploymentName) {
                if (deploymentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "addDeployment"));
                }
                this.addDeployment(deploymentName, null);
            }

            public void addDeployment(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime) {
                if (deploymentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "addDeployment"));
                }
                this.addDeployment(deploymentName, deploymentRuntime, null, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Deployment addDeployment(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime, @Nullable DeploymentStatus deploymentStatus, @Nullable String deploymentStatusText) {
                DeploymentImpl result2;
                if (deploymentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "addDeployment"));
                }
                if (deploymentStatus == null) {
                    deploymentStatus = DeploymentStatus.DEPLOYED;
                }
                Map map = ServerConnectionImpl.this.myRemoteDeployments;
                synchronized (map) {
                    result2 = (DeploymentImpl)ServerConnectionImpl.this.myRemoteDeployments.get(deploymentName);
                    if (result2 == null) {
                        result2 = new DeploymentImpl(ServerConnectionImpl.this, deploymentName, deploymentStatus, deploymentStatusText, deploymentRuntime, null);
                    } else if (!result2.getStatus().isTransition()) {
                        result2.changeState(result2.getStatus(), deploymentStatus, deploymentStatusText, deploymentRuntime);
                    }
                    this.myDeployments.add(result2);
                }
                return result2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void succeeded() {
                Map map = ServerConnectionImpl.this.myRemoteDeployments;
                synchronized (map) {
                    ServerConnectionImpl.this.myRemoteDeployments.clear();
                    for (DeploymentImpl deployment : this.myDeployments) {
                        ServerConnectionImpl.this.myRemoteDeployments.put(deployment.getName(), deployment);
                    }
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "errorOccurred"));
                }
                Map map = ServerConnectionImpl.this.myRemoteDeployments;
                synchronized (map) {
                    ServerConnectionImpl.this.myRemoteDeployments.clear();
                }
                ServerConnectionImpl.this.myStatusText = "Cannot obtain deployments: " + errorMessage;
                ServerConnectionImpl.this.myEventDispatcher.queueConnectionStatusChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(@NotNull Deployment deployment, final @NotNull DeploymentRuntime runtime) {
        Map<String, DeploymentImpl> deploymentsMap;
        DeploymentImpl deploymentImpl;
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "undeploy"));
        }
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "undeploy"));
        }
        final String deploymentName = deployment.getName();
        Map<String, LocalDeploymentImpl> map = this.myLocalDeployments;
        synchronized (map) {
            Map<String, DeploymentImpl> map2 = this.myRemoteDeployments;
            synchronized (map2) {
                DeploymentImpl localDeployment = this.myLocalDeployments.get(deploymentName);
                if (localDeployment != null) {
                    deploymentImpl = localDeployment;
                    deploymentsMap = this.myLocalDeployments;
                } else {
                    DeploymentImpl remoteDeployment = this.myRemoteDeployments.get(deploymentName);
                    if (remoteDeployment != null) {
                        deploymentImpl = remoteDeployment;
                        deploymentsMap = this.myRemoteDeployments;
                    } else {
                        deploymentImpl = null;
                        deploymentsMap = null;
                    }
                }
                if (deploymentImpl != null) {
                    deploymentImpl.changeState(DeploymentStatus.DEPLOYED, DeploymentStatus.UNDEPLOYING, null, null);
                }
            }
        }
        this.myEventDispatcher.queueDeploymentsChanged(this);
        DeploymentLogManagerImpl logManager = this.myLogManagers.get(deploymentName);
        LoggingHandlerImpl loggingHandler = logManager == null ? null : logManager.getMainLoggingHandler();
        final Consumer logConsumer = message -> {
            if (loggingHandler == null) {
                LOG.info(message);
            } else {
                loggingHandler.printlnSystemMessage((String)message);
            }
        };
        logConsumer.consume((Object)("Undeploying '" + deploymentName + "'..."));
        runtime.undeploy(new DeploymentRuntime.UndeploymentTaskCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void succeeded() {
                DeploymentLogManagerImpl logManager;
                logConsumer.consume((Object)("'" + deploymentName + "' has been undeployed successfully."));
                if (deploymentImpl != null) {
                    Map map = deploymentsMap;
                    synchronized (map) {
                        if (deploymentImpl.changeState(DeploymentStatus.UNDEPLOYING, DeploymentStatus.NOT_DEPLOYED, null, null)) {
                            deploymentsMap.remove(deploymentName);
                        }
                    }
                }
                if ((logManager = (DeploymentLogManagerImpl)ServerConnectionImpl.this.myLogManagers.remove(deploymentName)) != null) {
                    logManager.disposeLogs();
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.computeDeployments(ServerConnectionImpl.this.myRuntimeInstance, EmptyRunnable.INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$5", "errorOccurred"));
                }
                logConsumer.consume((Object)("Failed to undeploy '" + deploymentName + "': " + errorMessage));
                if (deploymentImpl != null) {
                    Map map = deploymentsMap;
                    synchronized (map) {
                        deploymentImpl.changeState(DeploymentStatus.UNDEPLOYING, DeploymentStatus.DEPLOYED, errorMessage, runtime);
                    }
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Deployment> getDeployments() {
        LinkedHashSet<Deployment> result2 = new LinkedHashSet<Deployment>();
        TreeMap<DeploymentImpl, DeploymentImpl> orderedDeployments = new TreeMap<DeploymentImpl, DeploymentImpl>(this.getServer().getType().getDeploymentComparator());
        Map<String, LocalDeploymentImpl> map = this.myLocalDeployments;
        synchronized (map) {
            Map<String, DeploymentImpl> map2 = this.myRemoteDeployments;
            synchronized (map2) {
                for (LocalDeploymentImpl localDeployment : this.myLocalDeployments.values()) {
                    localDeployment.setRemoteDeployment(null);
                    orderedDeployments.put(localDeployment, localDeployment);
                }
                result2.addAll(orderedDeployments.keySet());
                for (DeploymentImpl remoteDeployment : this.myRemoteDeployments.values()) {
                    DeploymentImpl deployment = (DeploymentImpl)orderedDeployments.get(remoteDeployment);
                    if (deployment != null) {
                        if (!(deployment instanceof LocalDeploymentImpl)) continue;
                        ((LocalDeploymentImpl)deployment).setRemoteDeployment(remoteDeployment);
                        continue;
                    }
                    orderedDeployments.put(remoteDeployment, remoteDeployment);
                }
                result2.addAll(orderedDeployments.keySet());
            }
        }
        LinkedHashSet<Deployment> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getDeployments"));
        }
        return linkedHashSet;
    }

    public void connectIfNeeded(final ServerConnector.ConnectionCallback<D> callback) {
        ServerRuntimeInstance<D> instance = this.myRuntimeInstance;
        if (instance != null) {
            callback.connected(instance);
            return;
        }
        this.setStatus(ConnectionStatus.CONNECTING);
        this.myConnector.connect(new ServerConnector.ConnectionCallback<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$6", "connected"));
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.CONNECTED);
                ServerConnectionImpl.this.myRuntimeInstance = instance;
                callback.connected(instance);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$6", "errorOccurred"));
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.DISCONNECTED, errorMessage);
                ServerConnectionImpl.this.myRuntimeInstance = null;
                callback.errorOccurred(errorMessage);
            }
        });
    }

    private void setStatus(ConnectionStatus status) {
        this.setStatus(status, null);
    }

    private void setStatus(ConnectionStatus status, String statusText) {
        this.myStatus = status;
        this.myStatusText = statusText;
        this.myEventDispatcher.queueConnectionStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDeploymentState(Runnable stateChanger) {
        Map<String, LocalDeploymentImpl> map = this.myLocalDeployments;
        synchronized (map) {
            Map<String, DeploymentImpl> map2 = this.myRemoteDeployments;
            synchronized (map2) {
                stateChanger.run();
            }
        }
        this.myEventDispatcher.queueDeploymentsChanged(this);
    }

    private class ChangeListener
    implements Runnable {
        private ChangeListener() {
        }

        @Override
        public void run() {
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }
    }

    private class DeploymentOperationCallbackImpl
    implements ServerRuntimeInstance.DeploymentOperationCallback {
        private final String myDeploymentName;
        private final DeploymentTaskImpl<D> myDeploymentTask;
        private final LoggingHandlerImpl myLoggingHandler;
        private final DeploymentImpl myDeployment;

        public DeploymentOperationCallbackImpl(String deploymentName, DeploymentTaskImpl<D> deploymentTask, LoggingHandlerImpl handler2, DeploymentImpl deployment) {
            this.myDeploymentName = deploymentName;
            this.myDeploymentTask = deploymentTask;
            this.myLoggingHandler = handler2;
            this.myDeployment = deployment;
        }

        public Deployment succeeded(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentRuntime", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "succeeded"));
            }
            this.myLoggingHandler.printlnSystemMessage("'" + this.myDeploymentName + "' has been deployed successfully.");
            this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.DEPLOYED, null, deploymentRuntime);
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            DebugConnector<?, ?> debugConnector = this.myDeploymentTask.getDebugConnector();
            if (debugConnector != null) {
                this.launchDebugger(debugConnector, deploymentRuntime);
            }
            return this.myDeployment;
        }

        private <D extends DebugConnectionData, R extends DeploymentRuntime> void launchDebugger(@NotNull DebugConnector<D, R> debugConnector, @NotNull DeploymentRuntime runtime) {
            if (debugConnector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugConnector", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "launchDebugger"));
            }
            if (runtime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "launchDebugger"));
            }
            try {
                DebugConnectionData debugInfo = debugConnector.getConnectionData(runtime);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (debugConnector == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugConnector", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "lambda$launchDebugger$0"));
                    }
                    try {
                        debugConnector.getLauncher().startDebugSession(debugInfo, this.myDeploymentTask.getExecutionEnvironment(), ServerConnectionImpl.this.myServer);
                    }
                    catch (ExecutionException e) {
                        this.myLoggingHandler.print("Cannot start debugger: " + e.getMessage() + "\n");
                        LOG.info((Throwable)e);
                    }
                });
            }
            catch (DebugConnectionDataNotAvailableException e) {
                this.myLoggingHandler.print("Cannot retrieve debug connection: " + e.getMessage() + "\n");
                LOG.info((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "errorOccurred"));
            }
            this.myLoggingHandler.printlnSystemMessage("Failed to deploy '" + this.myDeploymentName + "': " + errorMessage);
            Map map = ServerConnectionImpl.this.myLocalDeployments;
            synchronized (map) {
                this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.NOT_DEPLOYED, errorMessage, null);
            }
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }
    }

    private static abstract class ConnectionCallbackBase<D extends DeploymentConfiguration>
    implements ServerConnector.ConnectionCallback<D> {
        private ConnectionCallbackBase() {
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$ConnectionCallbackBase", "errorOccurred"));
            }
        }
    }
}

