/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.reporting.InlayReport;
import com.intellij.reporting.ReportExcessiveInlineHintKt;
import com.intellij.reporting.ReporterKt;
import com.intellij.reporting.StatsSender;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002J\b\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/reporting/ReportExcessiveInlineHint;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "description", "", "file", "Ljava/io/File;", "recorderId", "text", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCurrentLineRange", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "reportInlays", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "showHint", "project", "Lcom/intellij/openapi/project/Project;", "trySend", "trySendFileInBackground", "update", "writeToFile", "line", "Companion", "lang-impl"})
public final class ReportExcessiveInlineHint
extends AnAction {
    private final String text = "Report Excessive Inline Hint";
    private final String description = "Text line at caret will be anonymously reported to our servers";
    private final String recorderId = "inline-hints-reports";
    private final File file;
    private static final Logger LOG;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Editor editor;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!ReportExcessiveInlineHintKt.access$isHintsEnabled()) {
            return;
        }
        if ((Project)CommonDataKeys.PROJECT.getData(e.getDataContext()) == null) {
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor = editor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor");
        TextRange range = this.getCurrentLineRange(editor3);
        Collection collection = ReportExcessiveInlineHintKt.access$getInlays(editor, range);
        if (!collection.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Project project2 = (Project)object;
        Object object2 = CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        Editor editor = (Editor)object2;
        Document document = editor.getDocument();
        Editor editor2 = editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        TextRange range = this.getCurrentLineRange(editor2);
        List inlays = ReportExcessiveInlineHintKt.access$getInlays(editor, range);
        Collection collection = inlays;
        if (!collection.isEmpty()) {
            String line;
            String string = line = document.getText(range);
            ReportExcessiveInlineHint reportExcessiveInlineHint = this;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            reportExcessiveInlineHint.reportInlays(string3, inlays);
            Project project3 = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            this.showHint(project3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportInlays(String text, List<? extends Inlay> inlays) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = $receiver$iv = (Iterable)inlays;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            String string;
            Object element$iv$iv = element$iv$iv$iv;
            Inlay it = (Inlay)element$iv$iv;
            if (hintManager.getHintText(it) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        List hints = (List)destination$iv$iv;
        this.trySend(text, hints);
    }

    private final void trySend(String text, List<String> inlays) {
        InlayReport report = new InlayReport(text, inlays);
        this.writeToFile(ReporterKt.createReportLine(this.recorderId, report));
        this.trySendFileInBackground();
    }

    private final void trySendFileInBackground() {
        ReportExcessiveInlineHint.Companion.getLOG().debug("File: " + this.file.getPath() + " Length: " + this.file.length());
        if (!this.file.exists() || this.file.length() == 0L) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ ReportExcessiveInlineHint this$0;

            public final void run() {
                String text = FilesKt.readText$default((File)ReportExcessiveInlineHint.access$getFile$p(this.this$0), null, (int)1, null);
                com.intellij.reporting.ReportExcessiveInlineHint$Companion.access$getLOG$p(ReportExcessiveInlineHint.Companion).debug("File text " + text);
                if (StatsSender.INSTANCE.send(text, false)) {
                    ReportExcessiveInlineHint.access$getFile$p(this.this$0).delete();
                    com.intellij.reporting.ReportExcessiveInlineHint$Companion.access$getLOG$p(ReportExcessiveInlineHint.Companion).debug("File deleted");
                }
            }
            {
                this.this$0 = reportExcessiveInlineHint;
            }
        });
    }

    private final void showHint(Project project2) {
        Notification notification = new Notification("Inline Hints", "Inline Hints Reporting", "Problematic inline hint was reported", NotificationType.INFORMATION);
        notification.notify(project2);
    }

    private final void writeToFile(String line) {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        FilesKt.appendText$default((File)this.file, (String)line, null, (int)2, null);
    }

    private final TextRange getCurrentLineRange(Editor editor) {
        int offset = editor.getCaretModel().getCurrentCaret().getOffset();
        Document document = editor.getDocument();
        int line = document.getLineNumber(offset);
        return new TextRange(document.getLineStartOffset(line), document.getLineEndOffset(line));
    }

    public ReportExcessiveInlineHint() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(this.text);
        presentation.setDescription(this.description);
        this.recorderId = "inline-hints-reports";
        this.file = new File(PathManager.getTempPath(), this.recorderId);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ReportExcessiveInlineHint.class);
    }

    @NotNull
    public static final /* synthetic */ File access$getFile$p(ReportExcessiveInlineHint $this) {
        return $this.file;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/reporting/ReportExcessiveInlineHint$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "lang-impl"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

