/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.apple.eawt.FullScreenUtilities;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.messages.SheetController;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.Animator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public class SheetMessage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.messages.SheetMessage");
    private final JDialog myWindow;
    private final Window myParent;
    private final SheetController myController;
    private static final int TIME_TO_SHOW_SHEET = 250;
    private Image staticImage;
    private int imageHeight;
    private final boolean restoreFullScreenButton;
    private final ComponentAdapter myPositionListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            SheetMessage.this.setPositionRelativeToParent();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            SheetMessage.this.setPositionRelativeToParent();
        }
    };

    public SheetMessage(Window owner, String title, String message, Icon icon, String[] buttons, DialogWrapper.DoNotAskOption doNotAskOption, String defaultButton, String focusedButton) {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component recentFocusOwner = activeWindow == null ? null : activeWindow.getMostRecentFocusOwner();
        WeakReference<Component> beforeShowFocusOwner = new WeakReference<Component>(recentFocusOwner);
        SheetMessage.maximizeIfNeeded(owner);
        this.myWindow = new JDialog(owner, "This should not be shown", Dialog.ModalityType.APPLICATION_MODAL);
        this.myWindow.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.myWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(@NotNull WindowEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetMessage$2", "windowActivated"));
                }
                super.windowActivated(e);
            }
        });
        this.myParent = owner;
        this.myWindow.setUndecorated(true);
        this.myWindow.setBackground(Gray.TRANSPARENT);
        this.myController = new SheetController(this, title, message, icon, buttons, defaultButton, doNotAskOption, focusedButton);
        this.imageHeight = 0;
        this.myParent.addComponentListener(this.myPositionListener);
        this.myWindow.setFocusable(true);
        this.myWindow.setFocusableWindowState(true);
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            this.myWindow.setSize(this.myController.SHEET_NC_WIDTH, 0);
            this.setWindowOpacity(0.0f);
            this.myWindow.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(@NotNull ComponentEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetMessage$3", "componentShown"));
                    }
                    super.componentShown(e);
                    SheetMessage.this.setWindowOpacity(1.0f);
                    SheetMessage.this.myWindow.setSize(((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT);
                }
            });
        } else {
            this.myWindow.setModal(true);
            this.myWindow.setSize(this.myController.SHEET_NC_WIDTH, this.myController.SHEET_NC_HEIGHT);
            this.setPositionRelativeToParent();
        }
        this.startAnimation(true);
        this.restoreFullScreenButton = this.couldBeInFullScreen();
        if (this.restoreFullScreenButton) {
            FullScreenUtilities.setWindowCanFullScreen((Window)this.myParent, (boolean)false);
        }
        LaterInvocator.enterModal(this.myWindow);
        this.myWindow.setVisible(true);
        LaterInvocator.leaveModal(this.myWindow);
        Component focusCandidate = (Component)beforeShowFocusOwner.get();
        if (focusCandidate == null) {
            focusCandidate = IdeFocusManager.getGlobalInstance().getLastFocusedFor(IdeFocusManager.getGlobalInstance().getLastFocusedFrame());
        }
        if (focusCandidate != null) {
            focusCandidate.requestFocus();
        }
    }

    private static void maximizeIfNeeded(Window owner) {
        Frame f;
        if (owner == null) {
            return;
        }
        if (owner instanceof Frame && (f = (Frame)owner).getState() == 1) {
            f.setState(0);
        }
    }

    private void setWindowOpacity(float opacity) {
        try {
            Method setOpacityMethod = this.myWindow.getClass().getMethod("setOpacity", Float.TYPE);
            setOpacityMethod.invoke((Object)this.myWindow, Float.valueOf(opacity));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean couldBeInFullScreen() {
        if (this.myParent instanceof JFrame) {
            JRootPane rootPane = ((JFrame)this.myParent).getRootPane();
            return rootPane.getClientProperty("Idea.Is.In.FullScreen.Mode.Now") == null;
        }
        return false;
    }

    public boolean toBeShown() {
        return !this.myController.getDoNotAskResult();
    }

    public String getResult() {
        return this.myController.getResult();
    }

    void startAnimation(final boolean enlarge) {
        this.staticImage = this.myController.getStaticImage();
        JPanel staticPanel = new JPanel(){

            @Override
            public void paint(@NotNull Graphics g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/messages/SheetMessage$4", "paint"));
                }
                super.paint(g);
                if (SheetMessage.this.staticImage != null) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setBackground((Color)new JBColor(new Color(255, 255, 255, 0), new Color(110, 110, 110, 0)));
                    g2d.clearRect(0, 0, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT);
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.95f));
                    int multiplyFactor = SheetMessage.this.staticImage.getWidth(null) / ((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH;
                    g.drawImage(SheetMessage.this.staticImage, 0, 0, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH, SheetMessage.this.imageHeight, 0, SheetMessage.this.staticImage.getHeight(null) - SheetMessage.this.imageHeight * multiplyFactor, SheetMessage.this.staticImage.getWidth(null), SheetMessage.this.staticImage.getHeight(null), null);
                }
            }
        };
        staticPanel.setOpaque(false);
        staticPanel.setSize(this.myController.SHEET_NC_WIDTH, this.myController.SHEET_NC_HEIGHT);
        this.myWindow.setContentPane(staticPanel);
        Animator myAnimator = new Animator("Roll Down Sheet Animator", this.myController.SHEET_NC_HEIGHT, 250, false){

            public void paintNow(int frame, int totalFrames, int cycle) {
                SheetMessage.this.setPositionRelativeToParent();
                float percentage = (float)frame / (float)totalFrames;
                SheetMessage.this.imageHeight = enlarge ? (int)((float)((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT * percentage) : (int)((float)((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT - percentage * (float)((SheetMessage)SheetMessage.this).myController.SHEET_HEIGHT);
                SheetMessage.this.myWindow.repaint();
            }

            protected void paintCycleEnd() {
                SheetMessage.this.setPositionRelativeToParent();
                if (enlarge) {
                    SheetMessage.this.imageHeight = ((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT;
                    SheetMessage.this.staticImage = null;
                    SheetMessage.this.myWindow.setContentPane(SheetMessage.this.myController.getPanel(SheetMessage.this.myWindow));
                    IJSwingUtilities.moveMousePointerOn(SheetMessage.this.myWindow.getRootPane().getDefaultButton());
                    SheetMessage.this.myController.requestFocus();
                } else {
                    if (SheetMessage.this.restoreFullScreenButton) {
                        FullScreenUtilities.setWindowCanFullScreen((Window)SheetMessage.this.myParent, (boolean)true);
                    }
                    SheetMessage.this.myParent.removeComponentListener(SheetMessage.this.myPositionListener);
                    SheetMessage.this.myController.dispose();
                    SheetMessage.this.myWindow.dispose();
                    DialogWrapper.cleanupRootPane((JRootPane)SheetMessage.this.myWindow.getRootPane());
                }
            }
        };
        myAnimator.resume();
    }

    private void setPositionRelativeToParent() {
        int width = this.myParent.getWidth();
        this.myWindow.setBounds(width / 2 - this.myController.SHEET_NC_WIDTH / 2 + this.myParent.getLocation().x, this.myParent.getInsets().top + this.myParent.getLocation().y, this.myController.SHEET_NC_WIDTH, this.myController.SHEET_NC_HEIGHT);
    }
}

