/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalFileUrl
implements Url {
    private final String path;

    public LocalFileUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/LocalFileUrl", "<init>"));
        }
        this.path = path;
    }

    public Url resolve(@NotNull String subPath) {
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPath", "com/intellij/util/LocalFileUrl", "resolve"));
        }
        return new LocalFileUrl(this.path.isEmpty() ? subPath : this.path + "/" + subPath);
    }

    @NotNull
    public String getPath() {
        String string = this.path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LocalFileUrl", "getPath"));
        }
        return string;
    }

    public boolean isInLocalFileSystem() {
        return true;
    }

    public String toDecodedForm() {
        return this.path;
    }

    @NotNull
    public String toExternalForm() {
        String string = this.path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LocalFileUrl", "toExternalForm"));
        }
        return string;
    }

    @Nullable
    public String getScheme() {
        return null;
    }

    @Nullable
    public String getAuthority() {
        return null;
    }

    @Nullable
    public String getParameters() {
        return null;
    }

    @NotNull
    public Url trimParameters() {
        LocalFileUrl localFileUrl = this;
        if (localFileUrl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LocalFileUrl", "trimParameters"));
        }
        return localFileUrl;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof LocalFileUrl && this.path.equals(((LocalFileUrl)o).path);
    }

    public boolean equalsIgnoreCase(@Nullable Url o) {
        return this == o || o instanceof LocalFileUrl && this.path.equalsIgnoreCase(((LocalFileUrl)o).path);
    }

    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return this.equals(url);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public int hashCodeCaseInsensitive() {
        return StringUtil.stringHashCodeInsensitive((CharSequence)this.path);
    }
}

