/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private final Map<Key, ChangeTrackingValueContainer<Value>> myMap;
    @NotNull
    private final IndexStorage<Key, Value> myBackendStorage;
    private final List<BufferingStateListener> myListeners;
    private final ID<?, ?> myIndexId;
    private boolean myBufferingEnabled;

    public MemoryIndexStorage(@NotNull IndexStorage<Key, Value> backend) {
        if (backend == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backend", "com/intellij/util/indexing/MemoryIndexStorage", "<init>"));
        }
        this(backend, null);
    }

    public MemoryIndexStorage(@NotNull IndexStorage<Key, Value> backend, ID<?, ?> indexId) {
        if (backend == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backend", "com/intellij/util/indexing/MemoryIndexStorage", "<init>"));
        }
        this.myMap = new HashMap<Key, ChangeTrackingValueContainer<Value>>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myBackendStorage = backend;
        this.myIndexId = indexId;
    }

    @NotNull
    public IndexStorage<Key, Value> getBackendStorage() {
        IndexStorage<Key, Value> indexStorage = this.myBackendStorage;
        if (indexStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "getBackendStorage"));
        }
        return indexStorage;
    }

    public void addBufferingStateListener(@NotNull BufferingStateListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/indexing/MemoryIndexStorage", "addBufferingStateListener"));
        }
        this.myListeners.add(listener2);
    }

    public void removeBufferingStateListener(@NotNull BufferingStateListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/indexing/MemoryIndexStorage", "removeBufferingStateListener"));
        }
        this.myListeners.remove(listener2);
    }

    public void setBufferingEnabled(boolean enabled) {
        boolean wasEnabled = this.myBufferingEnabled;
        assert (wasEnabled != enabled);
        this.myBufferingEnabled = enabled;
        for (BufferingStateListener listener2 : this.myListeners) {
            listener2.bufferingStateChanged(enabled);
        }
    }

    public boolean isBufferingEnabled() {
        return this.myBufferingEnabled;
    }

    public void clearMemoryMap() {
        this.myMap.clear();
    }

    public void fireMemoryStorageCleared() {
        for (BufferingStateListener listener2 : this.myListeners) {
            listener2.memoryStorageCleared();
        }
    }

    public void clearCaches() {
        try {
            if (this.myMap.size() == 0) {
                return;
            }
            if (DebugAssertions.DEBUG) {
                String message = "Dropping caches for " + (this.myIndexId != null ? this.myIndexId : this) + ", number of items:" + this.myMap.size();
                FileBasedIndexImpl.LOG.info(message);
            }
            for (ChangeTrackingValueContainer<Value> v : this.myMap.values()) {
                v.dropMergedData();
            }
        }
        finally {
            this.myBackendStorage.clearCaches();
        }
    }

    public void close() throws StorageException {
        this.myBackendStorage.close();
    }

    public void clear() throws StorageException {
        this.clearMemoryMap();
        this.myBackendStorage.clear();
    }

    public void flush() throws IOException {
        this.myBackendStorage.flush();
    }

    @Override
    public boolean processKeys(@NotNull Processor<Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/MemoryIndexStorage", "processKeys"));
        }
        HashSet<Key> stopList = new HashSet<Key>();
        Processor<Key> decoratingProcessor = key2 -> {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/MemoryIndexStorage", "lambda$processKeys$0"));
            }
            if (stopList.contains(key2)) {
                return true;
            }
            UpdatableValueContainer container = (UpdatableValueContainer)this.myMap.get(key2);
            if (container != null && container.size() == 0) {
                return true;
            }
            return processor2.process(key2);
        };
        for (Key key3 : this.myMap.keySet()) {
            if (!decoratingProcessor.process(key3)) {
                return false;
            }
            stopList.add(key3);
        }
        return ((VfsAwareIndexStorage)this.myBackendStorage).processKeys(stopList.isEmpty() && this.myMap.isEmpty() ? processor2 : decoratingProcessor, scope, idFilter);
    }

    public void addValue(Key key2, int inputId, Value value) throws StorageException {
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key2).addValue(inputId, value);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key2);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.addValue(key2, inputId, value);
    }

    public void removeAllValues(@NotNull Key key2, int inputId) throws StorageException {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/MemoryIndexStorage", "removeAllValues"));
        }
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key2).removeAssociatedValue(inputId);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key2);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.removeAllValues(key2, inputId);
    }

    private UpdatableValueContainer<Value> getMemValueContainer(final Key key2) {
        ChangeTrackingValueContainer valueContainer = this.myMap.get(key2);
        if (valueContainer == null) {
            valueContainer = new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                public Object getLock() {
                    return this;
                }

                public ValueContainer<Value> compute() {
                    try {
                        return MemoryIndexStorage.this.myBackendStorage.read(key2);
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.myMap.put(key2, valueContainer);
        }
        return valueContainer;
    }

    @NotNull
    public ValueContainer<Value> read(Key key2) throws StorageException {
        ValueContainer valueContainer = (ValueContainer)this.myMap.get(key2);
        if (valueContainer != null) {
            ValueContainer valueContainer2 = valueContainer;
            if (valueContainer2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "read"));
            }
            return valueContainer2;
        }
        ValueContainer valueContainer3 = this.myBackendStorage.read(key2);
        if (valueContainer3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "read"));
        }
        return valueContainer3;
    }

    public static interface BufferingStateListener {
        public void bufferingStateChanged(boolean var1);

        public void memoryStorageCleared();
    }
}

