/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SharedMapBasedForwardIndex;
import com.intellij.util.indexing.SnapshotInputMappings;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.MapBasedForwardIndex;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value, Input>
extends MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    private final AtomicBoolean myInMemoryMode;
    private final TIntObjectHashMap<Collection<Key>> myInMemoryKeys;
    private final SnapshotInputMappings<Key, Value, Input> mySnapshotInputMappings;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "<init>"));
        }
        super(extension, storage2, VfsAwareMapReduceIndex.getForwardIndex(extension));
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeys = new TIntObjectHashMap();
        SharedIndicesData.registerIndex(this.myIndexId, extension);
        this.mySnapshotInputMappings = this.myForwardIndex == null ? new SnapshotInputMappings<Key, Value, Input>(extension) : null;
        this.installMemoryModeListener();
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2, @NotNull ForwardIndex<Key, Value> forwardIndex) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "<init>"));
        }
        if (forwardIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forwardIndex", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "<init>"));
        }
        super(extension, storage2, forwardIndex);
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeys = new TIntObjectHashMap();
        SharedIndicesData.registerIndex(this.myIndexId, extension);
        this.mySnapshotInputMappings = this.myForwardIndex == null ? new SnapshotInputMappings<Key, Value, Input>(extension) : null;
        this.installMemoryModeListener();
    }

    @NotNull
    protected UpdateData<Key, Value> calculateUpdateData(int inputId, @Nullable Input content) {
        int hashId;
        Map<Key, Value> data;
        boolean isContentPhysical = this.isContentPhysical(content);
        if (this.mySnapshotInputMappings != null && content != null && isContentPhysical) {
            SnapshotInputMappings.Snapshot<Key, Value> snapshot = this.mySnapshotInputMappings.readPersistentDataOrMap(content);
            data = snapshot.getData();
            hashId = snapshot.getHashId();
        } else {
            data = this.mapInput(content);
            hashId = 0;
        }
        UpdateData updateData = this.createUpdateData(data, () -> {
            if (this.mySnapshotInputMappings != null && isContentPhysical) {
                return new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId));
            }
            if (this.myInMemoryMode.get()) {
                TIntObjectHashMap<Collection<Key>> tIntObjectHashMap = this.myInMemoryKeys;
                synchronized (tIntObjectHashMap) {
                    Collection keys = (Collection)this.myInMemoryKeys.get(inputId);
                    if (keys != null) {
                        return new CollectionInputDataDiffBuilder(inputId, keys);
                    }
                }
                if (this.mySnapshotInputMappings != null) {
                    return new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId));
                }
            }
            if (this.myForwardIndex != null) {
                return this.getKeysDiffBuilder(inputId);
            }
            return new EmptyInputDataDiffBuilder(inputId);
        }, () -> {
            if (this.myInMemoryMode.get()) {
                TIntObjectHashMap<Collection<Key>> tIntObjectHashMap = this.myInMemoryKeys;
                synchronized (tIntObjectHashMap) {
                    this.myInMemoryKeys.put(inputId, data.keySet());
                }
            } else if (this.mySnapshotInputMappings != null) {
                this.mySnapshotInputMappings.putInputHash(inputId, hashId);
            } else {
                this.myForwardIndex.putInputData(inputId, data);
            }
        });
        if (updateData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "calculateUpdateData"));
        }
        return updateData;
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "setIndexedStateForFile"));
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, this.myIndexId);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "isIndexedStateForFile"));
        }
        return IndexingStamp.isFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<Key> processor2, @NotNull GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "processAllKeys"));
        }
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            boolean bl = ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Exception ex) {
        if (ex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "requestRebuild"));
        }
        Runnable action = () -> {
            if (ex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "lambda$requestRebuild$2"));
            }
            FileBasedIndex.getInstance().requestRebuild(this.myIndexId, (Throwable)ex);
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            application.invokeLater(action, ModalityState.any());
        } else {
            action.run();
        }
    }

    public void clear() throws StorageException {
        super.clear();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void flush() throws StorageException {
        super.flush();
        if (this.mySnapshotInputMappings != null) {
            this.mySnapshotInputMappings.flush();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private static <Key, Value> ForwardIndex<Key, Value> getForwardIndex(@NotNull IndexExtension<Key, Value, ?> indexExtension) throws IOException {
        if (indexExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexExtension", "com/intellij/util/indexing/VfsAwareMapReduceIndex", "getForwardIndex"));
        }
        boolean hasSnapshotMapping = indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && IdIndex.ourSnapshotMappingsEnabled;
        return hasSnapshotMapping ? null : new SharedMapBasedForwardIndex<Key, Value>(new MyForwardIndex<Key, Value>(indexExtension));
    }

    private boolean isContentPhysical(Input content) {
        return content == null || content instanceof UserDataHolder && (Boolean)FileBasedIndexImpl.ourPhysicalContentKey.get((UserDataHolder)content, (Object)Boolean.FALSE) != false;
    }

    private void installMemoryModeListener() {
        IndexStorage storage2 = this.getStorage();
        if (storage2 instanceof MemoryIndexStorage) {
            ((MemoryIndexStorage)storage2).addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = VfsAwareMapReduceIndex.this.myInMemoryKeys;
                    synchronized (tIntObjectHashMap) {
                        VfsAwareMapReduceIndex.this.myInMemoryKeys.clear();
                    }
                }
            });
        }
    }

    protected static <K> DataExternalizer<Collection<K>> createInputsIndexExternalizer(IndexExtension<K, ?, ?> extension) {
        return extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer() : new InputIndexDataExternalizer(extension.getKeyDescriptor(), extension.getName());
    }

    static {
        if (!DebugAssertions.DEBUG) {
            Application app = ApplicationManager.getApplication();
            DebugAssertions.DEBUG = app.isInternal();
        }
    }

    private static class MyForwardIndex<Key, Value>
    extends MapBasedForwardIndex<Key, Value> {
        protected MyForwardIndex(IndexExtension<Key, Value, ?> indexExtension) throws IOException {
            super(indexExtension);
        }

        @NotNull
        public PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException {
            PersistentHashMap persistentHashMap = MyForwardIndex.createIdToDataKeysIndex(this.myIndexExtension);
            if (persistentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/VfsAwareMapReduceIndex$MyForwardIndex", "createMap"));
            }
            return persistentHashMap;
        }

        @NotNull
        private static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(@NotNull IndexExtension<K, ?, ?> extension) throws IOException {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/VfsAwareMapReduceIndex$MyForwardIndex", "createIdToDataKeysIndex"));
            }
            File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile(extension.getName());
            PersistentHashMap persistentHashMap = new PersistentHashMap(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, VfsAwareMapReduceIndex.createInputsIndexExternalizer(extension));
            if (persistentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/VfsAwareMapReduceIndex$MyForwardIndex", "createIdToDataKeysIndex"));
            }
            return persistentHashMap;
        }
    }
}

