/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdePopupManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class OwnerOptional {
    private Window myPermanentOwner;

    @NotNull
    private static Window findOwnerByComponent(Component component) {
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (component == null) {
            component = Window.getWindows()[0];
        }
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/OwnerOptional", "findOwnerByComponent"));
        }
        return window;
    }

    private OwnerOptional(Window permanentOwner) {
        this.myPermanentOwner = permanentOwner;
    }

    public static OwnerOptional fromComponent(Component parentComponent) {
        Window owner = OwnerOptional.findOwnerByComponent(parentComponent);
        IdePopupManager manager = IdeEventQueue.getInstance().getPopupManager();
        if (manager.isPopupWindow(owner)) {
            manager.closeAllPopups();
            for (owner = owner.getOwner(); owner != null && !(owner instanceof Dialog) && !(owner instanceof Frame); owner = owner.getOwner()) {
            }
        }
        if (owner instanceof Dialog) {
            Dialog ownerDialog = (Dialog)owner;
            if (ownerDialog.isModal()) {
                owner = ownerDialog;
            } else {
                while (owner instanceof Dialog && !((Dialog)owner).isModal()) {
                    owner = owner.getOwner();
                }
            }
        }
        while (owner != null && !owner.isShowing()) {
            owner = owner.getOwner();
        }
        return new OwnerOptional(owner);
    }

    public OwnerOptional ifDialog(Consumer<Dialog> consumer) {
        if (this.myPermanentOwner instanceof Dialog) {
            consumer.consume((Object)((Dialog)this.myPermanentOwner));
        }
        return this;
    }

    public OwnerOptional ifNull(Consumer<Frame> consumer) {
        if (this.myPermanentOwner == null) {
            consumer.consume(null);
        }
        return this;
    }

    public OwnerOptional ifWindow(Consumer<Window> consumer) {
        if (this.myPermanentOwner != null) {
            consumer.consume((Object)this.myPermanentOwner);
        }
        return this;
    }

    public OwnerOptional ifFrame(Consumer<Frame> consumer) {
        if (this.myPermanentOwner instanceof Frame) {
            if (this.myPermanentOwner instanceof IdeFrame.Child) {
                IdeFrame.Child ideFrameChild = (IdeFrame.Child)this.myPermanentOwner;
                this.myPermanentOwner = WindowManager.getInstance().getFrame(ideFrameChild.getProject());
            }
            consumer.consume((Object)((Frame)this.myPermanentOwner));
        }
        return this;
    }

    public Window get() {
        return this.myPermanentOwner;
    }
}

