/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SimpleGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final NotNullFunction<Integer, CommitId> myFunction;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final Set<Integer> myBranchNodeIds;

    private SimpleGraphInfo(@NotNull LinearGraph linearGraph, @NotNull GraphLayout graphLayout, @NotNull NotNullFunction<Integer, CommitId> function, @NotNull TimestampGetter timestampGetter, @NotNull Set<Integer> branchNodeIds) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "<init>"));
        }
        if (graphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphLayout", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "<init>"));
        }
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "<init>"));
        }
        if (branchNodeIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNodeIds", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "<init>"));
        }
        this.myLinearGraph = linearGraph;
        this.myGraphLayout = graphLayout;
        this.myFunction = function;
        this.myTimestampGetter = timestampGetter;
        this.myBranchNodeIds = branchNodeIds;
    }

    public static <CommitId> SimpleGraphInfo<CommitId> build(@NotNull LinearGraph linearGraph, @NotNull GraphLayout oldLayout, @NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int permanentGraphSize, @NotNull Set<Integer> branchNodeIds) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "build"));
        }
        if (oldLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldLayout", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "build"));
        }
        if (permanentCommitsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentCommitsInfo", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "build"));
        }
        if (branchNodeIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNodeIds", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "build"));
        }
        int firstVisibleRow = 1000;
        int delta = 1000;
        int start = Math.max(0, firstVisibleRow - delta);
        int end = Math.min(linearGraph.nodesCount(), start + 2 * delta);
        ArrayList graphCommits = ContainerUtil.newArrayListWithCapacity((int)(end - start));
        ArrayList commitsIdMap = ContainerUtil.newArrayListWithCapacity((int)(end - start));
        for (int row = start; row < end; ++row) {
            int nodeId = linearGraph.getNodeId(row);
            CommitId commit = permanentCommitsInfo.getCommitId(nodeId);
            List parents = ContainerUtil.newSmartList();
            parents.addAll(ContainerUtil.mapNotNull(LinearGraphUtils.asLiteLinearGraph(linearGraph).getNodes(row, LiteLinearGraph.NodeFilter.DOWN), row1 -> {
                if (permanentCommitsInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentCommitsInfo", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "lambda$build$0"));
                }
                if (linearGraph == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "lambda$build$0"));
                }
                if (row1 < start || row1 >= end) {
                    return null;
                }
                return permanentCommitsInfo.getCommitId(linearGraph.getNodeId((int)row1));
            }));
            graphCommits.add(new GraphCommitImpl<CommitId>(commit, parents, permanentCommitsInfo.getTimestamp(nodeId)));
            commitsIdMap.add(commit);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        NotNullFunction<Integer, CommitId> function = SimpleGraphInfo.createCommitIdMapFunction(commitsIdMap);
        PermanentLinearGraphImpl newLinearGraph = PermanentLinearGraphBuilder.newInstance(graphCommits).build();
        int[] layoutIndexes = new int[end - start];
        ArrayList headNodeIndexes = ContainerUtil.newArrayList();
        TObjectIntHashMap<CommitId> commitIdToInteger = SimpleGraphInfo.reverseCommitIdMap(permanentCommitsInfo, permanentGraphSize);
        for (int row = start; row < end; ++row) {
            int layoutIndex;
            Object commitId = commitsIdMap.get(row - start);
            layoutIndexes[row - start] = layoutIndex = oldLayout.getLayoutIndex(commitIdToInteger.get(commitId));
            if (!LinearGraphUtils.asLiteLinearGraph(newLinearGraph).getNodes(row - start, LiteLinearGraph.NodeFilter.UP).isEmpty()) continue;
            headNodeIndexes.add(row - start);
        }
        ContainerUtil.sort((List)headNodeIndexes, Comparator.comparingInt(o -> layoutIndexes[o]));
        int[] starts = new int[headNodeIndexes.size()];
        for (int i2 = 0; i2 < starts.length; ++i2) {
            starts[i2] = layoutIndexes[(Integer)headNodeIndexes.get(i2)];
        }
        GraphLayoutImpl newLayout = new GraphLayoutImpl(layoutIndexes, headNodeIndexes, starts);
        return new SimpleGraphInfo<CommitId>(newLinearGraph, newLayout, function, timestampGetter, LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, branchNodeIds));
    }

    @NotNull
    private static <CommitId> NotNullFunction<Integer, CommitId> createCommitIdMapFunction(List<CommitId> commitsIdMap) {
        Object function;
        if (!commitsIdMap.isEmpty() && commitsIdMap.get(0) instanceof Integer) {
            int[] ints = new int[commitsIdMap.size()];
            for (int row = 0; row < commitsIdMap.size(); ++row) {
                ints[row] = (Integer)commitsIdMap.get(row);
            }
            function = new IntegerCommitIdMapFunction(CompressedIntList.newInstance(ints));
        } else {
            function = new CommitIdMapFunction<CommitId>(commitsIdMap);
        }
        CommitIdMapFunction<CommitId> commitIdMapFunction = function;
        if (commitIdMapFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "createCommitIdMapFunction"));
        }
        return commitIdMapFunction;
    }

    @NotNull
    private static <CommitId> TObjectIntHashMap<CommitId> reverseCommitIdMap(PermanentCommitsInfo<CommitId> permanentCommitsInfo, int size) {
        TObjectIntHashMap result2 = new TObjectIntHashMap();
        for (int i2 = 0; i2 < size; ++i2) {
            result2.put(permanentCommitsInfo.getCommitId(i2), i2);
        }
        TObjectIntHashMap tObjectIntHashMap = result2;
        if (tObjectIntHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "reverseCommitIdMap"));
        }
        return tObjectIntHashMap;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfo permanentCommitsInfo = new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int nodeId) {
                Object object = SimpleGraphInfo.this.myFunction.fun((Object)nodeId);
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1", "getCommitId"));
                }
                return object;
            }

            @Override
            public long getTimestamp(int nodeId) {
                return SimpleGraphInfo.this.myTimestampGetter.getTimestamp(nodeId);
            }

            @Override
            public int getNodeId(@NotNull CommitId commitId) {
                if (commitId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1", "getNodeId"));
                }
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!SimpleGraphInfo.this.myFunction.fun((Object)id).equals(commitId)) continue;
                    return id;
                }
                return -1;
            }

            @Override
            @NotNull
            public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> heads) {
                if (heads == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1", "convertToNodeIds"));
                }
                HashSet result2 = ContainerUtil.newHashSet();
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!heads.contains(SimpleGraphInfo.this.myFunction.fun((Object)id))) continue;
                    result2.add(id);
                }
                HashSet hashSet = result2;
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1", "convertToNodeIds"));
                }
                return hashSet;
            }
        };
        if (permanentCommitsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "getPermanentCommitsInfo"));
        }
        return permanentCommitsInfo;
    }

    @Override
    @NotNull
    public LinearGraph getLinearGraph() {
        LinearGraph linearGraph = this.myLinearGraph;
        if (linearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "getLinearGraph"));
        }
        return linearGraph;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        GraphLayout graphLayout = this.myGraphLayout;
        if (graphLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "getPermanentGraphLayout"));
        }
        return graphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set2 = this.myBranchNodeIds;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo", "getBranchNodeIds"));
        }
        return set2;
    }

    private static class IntegerCommitIdMapFunction
    implements NotNullFunction<Integer, Integer> {
        private final IntList myCommitsIdMap;

        public IntegerCommitIdMapFunction(IntList commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public Integer fun(Integer dom) {
            Integer n = this.myCommitsIdMap.get(dom);
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$IntegerCommitIdMapFunction", "fun"));
            }
            return n;
        }
    }

    private static class CommitIdMapFunction<CommitId>
    implements NotNullFunction<Integer, CommitId> {
        private final List<CommitId> myCommitsIdMap;

        public CommitIdMapFunction(List<CommitId> commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public CommitId fun(Integer dom) {
            CommitId CommitId2 = this.myCommitsIdMap.get(dom);
            if (CommitId2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$CommitIdMapFunction", "fun"));
            }
            return CommitId2;
        }
    }
}

