/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        Map<VirtualFile, Set<VcsRef>> map = VcsLogUtil.groupByRoot(refs, VcsRef::getRoot);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        return map;
    }

    @NotNull
    private static <T> Map<VirtualFile, Set<T>> groupByRoot(@NotNull Collection<T> items, @NotNull Function<T, VirtualFile> rootGetter) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        if (rootGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGetter", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        TreeMap<VirtualFile, Set<T>> map = new TreeMap<VirtualFile, Set<T>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (T item : items) {
            VirtualFile root = (VirtualFile)rootGetter.fun(item);
            Set set2 = (Set)map.get(root);
            if (set2 == null) {
                set2 = ContainerUtil.newHashSet();
                map.put(root, set2);
            }
            set2.add(item);
        }
        TreeMap<VirtualFile, Set<T>> treeMap = map;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        return treeMap;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull VisibleGraph<Integer> visibleGraph) {
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)visibleGraph.getRowInfo(index).getCommit();
            }

            @Override
            public int size() {
                return visibleGraph.getVisibleCommitCount();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        return abstractList;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root1", "com/intellij/vcs/log/impl/VcsLogUtil", "compareRoots"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root2", "com/intellij/vcs/log/impl/VcsLogUtil", "compareRoots"));
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<FilePath> files, @NotNull Set<VirtualFile> roots) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)root, (boolean)false)) continue;
                selectedRoots.add(root);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
        }
        if (rootFilter == null && structureFilter == null) {
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(roots);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
            }
            return hashSet;
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots)) : roots;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        if (filterCollection.getStructureFilter() == null) {
            Set<FilePath> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
            }
            return set2;
        }
        Collection files = filterCollection.getStructureFilter().getFiles();
        HashSet<FilePath> hashSet = new HashSet<FilePath>(ContainerUtil.filter((Collection)files, filePath -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUtil", "lambda$getFilteredFilesForRoot$0"));
            }
            VirtualFile virtualFile = filePath.getVirtualFile();
            return root.equals(virtualFile) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
        }));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> List<T> collectFirstPack(@NotNull List<T> list, int max) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPack"));
        }
        List<T> list2 = list.subList(0, Math.min(list.size(), max));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPack"));
        }
        return list2;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleRoots"));
        }
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots(roots, filters.getRootFilter(), filters.getStructureFilter());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleRoots"));
        }
        return set2;
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogBranchFilter filter, @NotNull VcsLogRefs refs) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/impl/VcsLogUtil", "getSingleFilteredBranch"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/VcsLogUtil", "getSingleFilteredBranch"));
        }
        String branchName = null;
        HashSet checkedRoots = ContainerUtil.newHashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static void triggerUsage(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/impl/VcsLogUtil", "triggerUsage"));
        }
        String text = e.getPresentation().getText();
        if (text != null) {
            VcsLogUtil.triggerUsage(text);
        }
    }

    public static void triggerUsage(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/impl/VcsLogUtil", "triggerUsage"));
        }
        UsageTrigger.trigger("vcs.log." + ConvertUsagesUtil.ensureProperKey(text).replace(" ", ""));
    }

    public static boolean maybeRegexp(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/impl/VcsLogUtil", "maybeRegexp"));
        }
        return StringUtil.containsAnyChar((String)text, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogUtil", "convertToRevisionNumber"));
        }
        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(hash.asString(), hash.toShortString());
        if (textRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "convertToRevisionNumber"));
        }
        return textRevisionNumber;
    }

    @NotNull
    public static VcsFullCommitDetails getDetails(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(VcsLogUtil.getDetails(data.getLogProvider(root), root, Collections.singletonList(hash.asString()))));
        if (vcsFullCommitDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (logProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProvider", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        logProvider.readFullDetails(root, hashes, result2::add);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getDetails"));
        }
        return arrayList;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detail", "com/intellij/vcs/log/impl/VcsLogUtil", "createCommittedChangeList"));
        }
        CommittedChangeListForRevision committedChangeListForRevision = new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), detail.getChanges(), (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
        if (committedChangeListForRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "createCommittedChangeList"));
        }
        return committedChangeListForRevision;
    }
}

