/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class ShowCommitTooltipAction
extends DumbAwareAction {
    public ShowCommitTooltipAction() {
        super("Show Commit Tooltip", "Show tooltip for currently selected commit in the Log", null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/ShowCommitTooltipAction", "update"));
        }
        Project project2 = e.getProject();
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project2 == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(ui instanceof AbstractVcsLogUi && ((AbstractVcsLogUi)ui).getTable().getSelectedRowCount() == 1);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        int row;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/ShowCommitTooltipAction", "actionPerformed"));
        }
        VcsLogGraphTable table = ((AbstractVcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI)).getTable();
        if (ScrollingUtil.isVisible((JTable)((Object)table), (int)(row = table.getSelectedRow()))) {
            table.showTooltip(row);
        }
    }
}

