/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.ui.actions.history.FileHistorySingleCommitAction;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateRevisionFromHistoryAction
extends FileHistorySingleCommitAction {
    @Override
    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/actions/history/AnnotateRevisionFromHistoryAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/AnnotateRevisionFromHistoryAction", "isEnabled"));
        }
        VcsKey key2 = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (key2 == null) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.findVcsByKey((Project)((Project)ObjectUtils.notNull((Object)e.getProject())), (VcsKey)key2);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider provider = vcs.getAnnotationProvider();
        if (provider == null) {
            return false;
        }
        if (detail != null) {
            VcsFileRevision fileRevision = ui.createRevision(detail);
            return AnnotateRevisionActionBase.isEnabled(vcs, ui.createVcsVirtualFile(fileRevision), fileRevision);
        }
        return true;
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull FileHistoryUi ui, @NotNull VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/history/AnnotateRevisionFromHistoryAction", "performAction"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/actions/history/AnnotateRevisionFromHistoryAction", "performAction"));
        }
        if (detail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detail", "com/intellij/vcs/log/ui/actions/history/AnnotateRevisionFromHistoryAction", "performAction"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/AnnotateRevisionFromHistoryAction", "performAction"));
        }
        VcsKey vcsKey = (VcsKey)e.getRequiredData(VcsDataKeys.VCS);
        VcsFileRevision revision = ui.createRevision(detail);
        VirtualFile vcsVirtualFile = ui.createVcsVirtualFile(detail);
        if (!VcsHistoryUtil.isEmpty(revision) && vcsVirtualFile != null) {
            AnnotateRevisionActionBase.annotate(vcsVirtualFile, revision, (AbstractVcs)ObjectUtils.notNull((Object)VcsUtil.findVcsByKey((Project)project2, (VcsKey)vcsKey)), null, 0);
        }
    }
}

