/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDateFilterImpl;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFileFilter;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogRootFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUserFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final String HASH_PATTERN = "[a-fA-F0-9]{7,}";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FilterModel<VcsLogFileFilter> myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        this.myUi = ui;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel((Computable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.myUserFilterModel = new UserFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, uiProperties);
        this.myDateFilterModel = new DateFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, uiProperties);
        this.myStructureFilterModel = new FileFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myLogData.getLogProviders().keySet(), uiProperties);
        this.myTextFilterModel = new TextFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.updateUiOnFilterChange();
        this.myUi.applyFiltersAndUpdateUi(this.getFilters());
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(() -> {
                this.myUi.applyFiltersAndUpdateUi(this.getFilters());
                this.myBranchFilterModel.onStructureFilterChanged(new HashSet<VirtualFile>(this.myLogData.getRoots()), this.myStructureFilterModel.getFilter());
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @NotNull
    public SearchTextField createTextFilter() {
        TextFilterField textFilterField = new TextFilterField(this.myTextFilterModel);
        if (textFilterField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "createTextFilter"));
        }
        return textFilterField;
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new BranchFilterPopupComponent(this.myUi, this.myUiProperties, this.myBranchFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new DateFilterPopupComponent(this.myDateFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new StructureFilterPopupComponent(this.myStructureFilterModel, this.myUi.getColorManager()).initUi())));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "createActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<VcsLogTextFilter, VcsLogHashFilter> filtersFromText = VcsLogClassicFilterUi.getFiltersFromTextArea((VcsLogTextFilter)this.myTextFilterModel.getFilter(), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
        VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with((VcsLogBranchFilter)this.myBranchFilterModel.getFilter()).with(this.myUserFilterModel.getFilter()).with((VcsLogHashFilter)filtersFromText.second).with(this.myDateFilterModel.getFilter()).with((VcsLogTextFilter)filtersFromText.first).with(this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getStructureFilter()).with(this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getRootFilter()).build();
        if (vcsLogFilterCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFilters"));
        }
        return vcsLogFilterCollection;
    }

    @NotNull
    private static Pair<VcsLogTextFilter, VcsLogHashFilter> getFiltersFromTextArea(@Nullable VcsLogTextFilter filter, boolean isRegexAllowed, boolean matchesCase) {
        VcsLogHashFilterImpl hashFilter;
        VcsLogTextFilterImpl textFilter;
        String word;
        if (filter == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
            }
            return pair;
        }
        String text = filter.getText().trim();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
            }
            return pair;
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        Iterator iterator = StringUtil.split((String)text, (String)" ").iterator();
        while (iterator.hasNext() && !StringUtil.isEmptyOrSpaces((String)(word = (String)iterator.next())) && word.matches(HASH_PATTERN)) {
            hashes.add(word);
        }
        if (!hashes.isEmpty()) {
            textFilter = null;
            hashFilter = new VcsLogHashFilterImpl(hashes);
        } else {
            textFilter = new VcsLogTextFilterImpl(text, isRegexAllowed, matchesCase);
            hashFilter = null;
        }
        Pair pair = Pair.create((Object)textFilter, (Object)hashFilter);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
        }
        return pair;
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "setFilter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setFilter((VcsLogBranchFilter)filter);
        } else if (filter instanceof VcsLogStructureFilter) {
            this.myStructureFilterModel.setFilter(new VcsLogFileFilter((VcsLogStructureFilter)filter, null));
        }
        JComponent toolbar = this.myUi.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    private static class TextFilterField
    extends SearchTextFieldWithStoredHistory {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        public TextFilterField(@NotNull TextFilterModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField", "<init>"));
            }
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter());
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    try {
                        myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            });
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter");
            if (!shortcutText.isEmpty()) {
                this.getTextEditor().setToolTipText("Use " + shortcutText + " to switch between text filter and commits list");
            }
        }

        protected void applyFilter() {
            this.myTextFilterModel.setFilter(new VcsLogTextFilterImpl(this.getText(), this.myTextFilterModel.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myTextFilterModel.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE)));
            this.addCurrentTextToHistory();
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter((VcsLogTextFilter)null);
        }

        protected void onFocusLost() {
            if (this.myTextFilterModel.hasUnsavedChanges()) {
                this.applyFilter();
            }
        }
    }

    private class UserFilterModel
    extends FilterModel<VcsLogUserFilter> {
        public UserFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, MainVcsLogUiProperties uiProperties) {
            super("user", (Computable<VcsLogDataPack>)dataPackGetter, uiProperties);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel", "createFilter"));
            }
            VcsLogUserFilterImpl vcsLogUserFilterImpl = new VcsLogUserFilterImpl(values, VcsLogClassicFilterUi.this.myLogData.getCurrentUser(), VcsLogClassicFilterUi.this.myLogData.getAllUsers());
            if (vcsLogUserFilterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel", "createFilter"));
            }
            return vcsLogUserFilterImpl;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel", "getFilterValues"));
            }
            ArrayList arrayList = ContainerUtil.newArrayList(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel", "getFilterValues"));
            }
            return arrayList;
        }
    }

    private static class DateFilterModel
    extends FilterModel<VcsLogDateFilter> {
        public DateFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, MainVcsLogUiProperties uiProperties) {
            super("date", (Computable<VcsLogDataPack>)dataPackGetter, uiProperties);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel", "createFilter"));
            }
            if (values.size() != 2) {
                LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
                return null;
            }
            String after2 = values.get(0);
            String before = values.get(1);
            try {
                return new VcsLogDateFilterImpl(after2.isEmpty() ? null : new Date(Long.parseLong(after2)), before.isEmpty() ? null : new Date(Long.parseLong(before)));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel", "getFilterValues"));
            }
            Date after2 = filter.getAfter();
            Date before = filter.getBefore();
            List<String> list = Arrays.asList(after2 == null ? "" : Long.toString(after2.getTime()), before == null ? "" : Long.toString(before.getTime()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel", "getFilterValues"));
            }
            return list;
        }
    }

    private static class FileFilterModel
    extends FilterModel<VcsLogFileFilter> {
        @NotNull
        private static final String ROOTS = "roots";
        @NotNull
        private static final String STRUCTURE = "structure";
        @NotNull
        private final Set<VirtualFile> myRoots;

        public FileFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, @NotNull Set<VirtualFile> roots, MainVcsLogUiProperties uiProperties) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ROOTS, "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "<init>"));
            }
            super("file", (Computable<VcsLogDataPack>)dataPackGetter, uiProperties);
            this.myRoots = roots;
        }

        @Override
        protected void saveFilter(@Nullable VcsLogFileFilter filter) {
            if (filter == null) {
                this.myUiProperties.saveFilterValues(ROOTS, null);
                this.myUiProperties.saveFilterValues(STRUCTURE, null);
            } else if (filter.getStructureFilter() != null) {
                this.myUiProperties.saveFilterValues(STRUCTURE, FileFilterModel.getFilterValues(filter.getStructureFilter()));
            } else if (filter.getRootFilter() != null) {
                this.myUiProperties.saveFilterValues(ROOTS, FileFilterModel.getFilterValues(filter.getRootFilter()));
            }
        }

        @NotNull
        private static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "getFilterValues"));
            }
            List list = ContainerUtil.map((Collection)filter.getFiles(), FilePath::getPath);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "getFilterValues"));
            }
            return list;
        }

        @NotNull
        private static List<String> getFilterValues(@NotNull VcsLogRootFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "getFilterValues"));
            }
            List list = ContainerUtil.map((Collection)filter.getRoots(), VirtualFile::getPath);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "getFilterValues"));
            }
            return list;
        }

        @Override
        @Nullable
        protected VcsLogFileFilter getLastFilter() {
            List<String> values = this.myUiProperties.getFilterValues(STRUCTURE);
            if (values != null) {
                return new VcsLogFileFilter(FileFilterModel.createStructureFilter(values), null);
            }
            values = this.myUiProperties.getFilterValues(ROOTS);
            if (values != null) {
                return new VcsLogFileFilter(null, this.createRootsFilter(values));
            }
            return null;
        }

        @Nullable
        private VcsLogRootFilter createRootsFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "createRootsFilter"));
            }
            ArrayList selectedRoots = ContainerUtil.newArrayList();
            for (String path : values) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by file that does not exist " + path);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return new VcsLogRootFilterImpl(selectedRoots);
        }

        @NotNull
        private static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "createStructureFilter"));
            }
            VcsLogStructureFilterImpl vcsLogStructureFilterImpl = new VcsLogStructureFilterImpl(ContainerUtil.map(values, VcsUtil::getFilePath));
            if (vcsLogStructureFilterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "createStructureFilter"));
            }
            return vcsLogStructureFilterImpl;
        }

        @Override
        @NotNull
        protected VcsLogFileFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "createFilter"));
            }
            throw new UnsupportedOperationException("Can not create file filter from list of strings");
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogFileFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel", "getFilterValues"));
            }
            throw new UnsupportedOperationException("Can not save file filter to a list of strings");
        }
    }

    private static class TextFilterModel
    extends FilterModel<VcsLogTextFilter> {
        @Nullable
        private String myText;

        public TextFilterModel(NotNullComputable<VcsLogDataPack> dataPackProvider, @NotNull MainVcsLogUiProperties properties) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "<init>"));
            }
            super("text", (Computable<VcsLogDataPack>)dataPackProvider, properties);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                String string = this.myText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getText"));
                }
                return string;
            }
            if (this.getFilter() != null) {
                String string = ((VcsLogTextFilter)this.getFilter()).getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getText"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getText"));
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "setUnsavedText"));
            }
            this.myText = text;
        }

        boolean hasUnsavedChanges() {
            if (this.myText == null) {
                return false;
            }
            return this.getFilter() == null || !this.myText.equals(((VcsLogTextFilter)this.getFilter()).getText());
        }

        @Override
        void setFilter(@Nullable VcsLogTextFilter filter) {
            super.setFilter(filter);
            this.myText = null;
        }

        @Override
        @NotNull
        protected VcsLogTextFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "createFilter"));
            }
            VcsLogTextFilterImpl vcsLogTextFilterImpl = new VcsLogTextFilterImpl((String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(values)), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
            if (vcsLogTextFilterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "createFilter"));
            }
            return vcsLogTextFilterImpl;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogTextFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getFilterValues"));
            }
            List<String> list = Collections.singletonList(filter.getText());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel", "getFilterValues"));
            }
            return list;
        }
    }

    public static class BranchFilterModel
    extends FilterModel<VcsLogBranchFilter> {
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;

        BranchFilterModel(@NotNull Computable<VcsLogDataPack> provider, @NotNull MainVcsLogUiProperties properties) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "<init>"));
            }
            super("branch", provider, properties);
        }

        public void onStructureFilterChanged(@NotNull Set<VirtualFile> roots, @Nullable VcsLogFileFilter filter) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "onStructureFilterChanged"));
            }
            this.myVisibleRoots = filter == null ? null : VcsLogUtil.getAllVisibleRoots(roots, filter.getRootFilter(), filter.getStructureFilter());
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @Override
        @NotNull
        protected VcsLogBranchFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "createFilter"));
            }
            VcsLogBranchFilterImpl vcsLogBranchFilterImpl = VcsLogBranchFilterImpl.fromTextPresentation(values, ContainerUtil.map2Set((Collection)this.getDataPack().getRefs().getBranches(), VcsRef::getName));
            if (vcsLogBranchFilterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "createFilter"));
            }
            return vcsLogBranchFilterImpl;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogBranchFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "getFilterValues"));
            }
            ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.sorted((Collection)filter.getTextPresentation()));
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel", "getFilterValues"));
            }
            return arrayList;
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<JComponent> myComponentCreator;

        public FilterActionComponent(@NotNull Computable<JComponent> componentCreator) {
            if (componentCreator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentCreator", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent", "<init>"));
            }
            this.myComponentCreator = componentCreator;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return (JComponent)this.myComponentCreator.compute();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent", "actionPerformed"));
            }
        }
    }
}

