/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTextFilterImpl
implements VcsLogDetailsFilter,
VcsLogTextFilter {
    @NotNull
    private final String myText;
    private final boolean myMatchCase;
    @Nullable
    private final Pattern myPattern;

    public VcsLogTextFilterImpl(@NotNull String text, boolean isRegexAllowed, boolean matchCase) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "<init>"));
        }
        this.myText = text;
        this.myMatchCase = matchCase;
        this.myPattern = VcsLogTextFilterImpl.createPattern(this.myText, isRegexAllowed, this.myMatchCase);
    }

    @Nullable
    private static Pattern createPattern(@NotNull String text, boolean isRegexAllowed, boolean matchCase) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "createPattern"));
        }
        if (isRegexAllowed && VcsLogUtil.maybeRegexp(text)) {
            try {
                return matchCase ? Pattern.compile(text) : Pattern.compile(text, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public VcsLogTextFilterImpl(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "<init>"));
        }
        this(text, false, false);
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "matches"));
        }
        return VcsLogTextFilterImpl.matches(this, details.getFullMessage());
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "getText"));
        }
        return string;
    }

    public boolean isRegex() {
        return this.myPattern != null;
    }

    public boolean matchesCase() {
        return this.myMatchCase;
    }

    public String toString() {
        return (this.isRegex() ? "matching " : "containing ") + this.myText + " (case " + (this.myMatchCase ? "sensitive" : "insensitive") + ")";
    }

    public static boolean matches(@NotNull VcsLogTextFilter filter, @NotNull String message) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "matches"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl", "matches"));
        }
        Pattern pattern = filter instanceof VcsLogTextFilterImpl ? ((VcsLogTextFilterImpl)filter).myPattern : VcsLogTextFilterImpl.createPattern(filter.getText(), filter.isRegex(), filter.matchesCase());
        if (pattern != null) {
            return pattern.matcher(message).find();
        }
        if (filter.matchesCase()) {
            return message.contains(filter.getText());
        }
        return StringUtil.containsIgnoreCase((String)message, (String)filter.getText());
    }
}

