/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CommitSelectionListenerForDiff
extends CommitSelectionListener {
    protected CommitSelectionListenerForDiff(@NotNull VcsLogData logData, @NotNull VcsLogGraphTable graphTable) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/frame/CommitSelectionListenerForDiff", "<init>"));
        }
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/ui/frame/CommitSelectionListenerForDiff", "<init>"));
        }
        super(logData, graphTable);
    }

    @Override
    protected void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsList", "com/intellij/vcs/log/ui/frame/CommitSelectionListenerForDiff", "onDetailsLoaded"));
        }
        List<Object> changes = ContainerUtil.newArrayList();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details : detailsListReversed) {
            changes.addAll(details.getChanges());
        }
        changes = CommittedChangesTreeBrowser.zipChanges((List<Change>)changes);
        this.setChangesToDisplay((List<Change>)changes);
    }

    @Override
    protected void onSelection(@NotNull int[] selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/vcs/log/ui/frame/CommitSelectionListenerForDiff", "onSelection"));
        }
        this.clearChanges();
    }

    @Override
    protected void onEmptySelection() {
        this.setChangesToDisplay(Collections.emptyList());
    }

    protected abstract void setChangesToDisplay(@NotNull List<Change> var1);

    protected abstract void clearChanges();
}

