/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final JBSplitter myDetailsSplitter;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final FileHistoryUi myUi;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryPanel(@NotNull FileHistoryUi ui, @NotNull VcsLogData logData, @NotNull VisiblePack visiblePack, @NotNull FilePath filePath) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        this.myUi = ui;
        this.myFilePath = filePath;
        this.myRoot = (VirtualFile)ObjectUtils.notNull((Object)VcsUtil.getVcsRootFor((Project)logData.getProject(), (FilePath)this.myFilePath));
        this.myGraphTable = new VcsLogGraphTable(this.myUi, logData, visiblePack){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return true;
            }
        };
        this.myGraphTable.setCompactReferencesView(true);
        this.myGraphTable.setShowTagNames(false);
        this.myDetailsPanel = new DetailsPanel(logData, this.myUi.getColorManager(), this);
        this.myDetailsPanel.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.history.details.splitter.proportion", 0.7f);
        JComponent tableWithProgress = VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 1), logData, this);
        this.myDetailsSplitter.setFirstComponent(tableWithProgress);
        this.myDetailsSplitter.setSecondComponent((JComponent)(this.myUi.getProperties().get(CommonUiProperties.SHOW_DETAILS) != false ? this.myDetailsPanel : null));
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, logData, this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myDetailsSplitter, "Center");
        this.add((Component)this.createActionsToolbar(), "West");
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.FileHistory.ContextMenu", (String)"Vcs.FileHistory.ContextMenu");
        EmptyAction.wrap((AnAction)ActionManager.getInstance().getAction("Vcs.Log.ShowDiff")).registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, tableWithProgress);
        Disposer.register((Disposable)this.myUi, (Disposable)this);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.FileHistory.Toolbar"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)toolbarGroup, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myGraphTable));
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "createActionsToolbar"));
        }
        return jComponent;
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "getGraphTable"));
        }
        return vcsLogGraphTable;
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permanentGraphChanged) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "updateDataPack"));
        }
        this.myGraphTable.updateDataPack(visiblePack, permanentGraphChanged);
    }

    public void showDetails(boolean show) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(show ? this.myDetailsPanel : null));
    }

    @Nullable
    public Object getData(String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedDetails();
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            return ArrayUtil.toObjectArray(this.myUi.collectChanges(details, true), Change.class);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUi.getProperties();
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedDetails();
            if (details.isEmpty()) {
                return null;
            }
            return this.myUi.createRevision((VcsFullCommitDetails)ContainerUtil.getFirstItem((List)details));
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedDetails();
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            return ArrayUtil.toObjectArray((Collection)ContainerUtil.mapNotNull((Collection)details, this.myUi::createRevision), VcsFileRevision.class);
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedDetails();
            if (details.isEmpty()) {
                return null;
            }
            VcsFullCommitDetails detail = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)details));
            VirtualFile revision = this.myUi.createVcsVirtualFile(detail);
            if (revision != null) {
                return revision;
            }
        } else {
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return this.myFilePath.getVirtualFile();
            }
            if (VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION.is(dataId)) {
                return false;
            }
            if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
                return this.myUi.getLogData().getLogProvider(this.myRoot).getDiffHandler();
            }
        }
        return null;
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
    }
}

