/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaInsideSchemaResolver {
    public static final String PROPERTIES = "/properties/";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final String myReference;
    @NotNull
    private final List<JsonSchemaWalker.Step> mySteps;

    public JsonSchemaInsideSchemaResolver(@NotNull Project project2, @NotNull VirtualFile schemaFile, @NotNull String reference, @NotNull List<JsonSchemaWalker.Step> steps) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver", "<init>"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver", "<init>"));
        }
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver", "<init>"));
        }
        this.myProject = project2;
        this.mySchemaFile = schemaFile;
        this.myReference = reference;
        this.mySteps = steps;
    }

    public PsiElement resolveInSchemaRecursively() {
        final Ref ref = new Ref();
        JsonSchemaWalker.CompletionSchemesConsumer consumer = new JsonSchemaWalker.CompletionSchemesConsumer(){

            @Override
            public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "consume"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "consume"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "consume"));
                }
                if (!ref.isNull()) {
                    return;
                }
                PsiFile file2 = PsiManager.getInstance((Project)JsonSchemaInsideSchemaResolver.this.myProject).findFile(JsonSchemaInsideSchemaResolver.this.mySchemaFile);
                if (file2 == null) {
                    return;
                }
                JsonObject jsonObject = (JsonObject)schema.getPeerPointer().getElement();
                if (jsonObject != null && jsonObject.isValid()) {
                    if (jsonObject.getParent() instanceof JsonProperty) {
                        ref.set((Object)((JsonProperty)jsonObject.getParent()).getNameElement());
                    } else {
                        ref.set((Object)jsonObject);
                    }
                }
            }

            @Override
            public void oneOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "oneOf"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "oneOf"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "oneOf"));
                }
                list.stream().findFirst().ifPresent(object -> {
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "lambda$oneOf$0"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "lambda$oneOf$0"));
                    }
                    this.consume(isName, (JsonSchemaObject)object, schemaFile, steps);
                });
            }

            @Override
            public void anyOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "anyOf"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "anyOf"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "anyOf"));
                }
                list.stream().findFirst().ifPresent(object -> {
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "lambda$anyOf$1"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaInsideSchemaResolver$1", "lambda$anyOf$1"));
                    }
                    this.consume(isName, (JsonSchemaObject)object, schemaFile, steps);
                });
            }
        };
        JsonSchemaService.Impl.getEx(this.myProject).visitSchemaObject(this.mySchemaFile, (Processor<JsonSchemaObject>)((Processor)object -> {
            JsonSchemaWalker.extractSchemaVariants(this.myProject, consumer, this.mySchemaFile, object, true, this.mySteps, false);
            return true;
        }));
        return (PsiElement)ref.get();
    }
}

