/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonValueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonJsonGenericValueAdapter
implements JsonValueAdapter {
    @NotNull
    private final JsonValue myValue;

    public JsonJsonGenericValueAdapter(@NotNull JsonValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonJsonGenericValueAdapter", "<init>"));
        }
        this.myValue = value;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return this.myValue instanceof JsonStringLiteral;
    }

    @Override
    public boolean isNumberLiteral() {
        return this.myValue instanceof JsonNumberLiteral;
    }

    @Override
    public boolean isBooleanLiteral() {
        return this.myValue instanceof JsonBooleanLiteral;
    }

    @Override
    public boolean isNull() {
        return this.myValue instanceof JsonNullLiteral;
    }

    @Override
    @NotNull
    public PsiElement getDelegate() {
        JsonValue jsonValue = this.myValue;
        if (jsonValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonJsonGenericValueAdapter", "getDelegate"));
        }
        return jsonValue;
    }

    @Override
    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Override
    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }
}

