/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaInsideSchemaResolver;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPropertyName2SchemaDefinitionReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonPropertyName2SchemaDefinitionReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/impl/JsonPropertyName2SchemaDefinitionReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonPropertyName2SchemaRefReference((JsonStringLiteral)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonPropertyName2SchemaDefinitionReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JsonPropertyName2SchemaRefReference
    extends JsonSchemaBaseReference<JsonStringLiteral> {
        public JsonPropertyName2SchemaRefReference(JsonStringLiteral element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String reference = this.getReference();
            if (reference == null) {
                return null;
            }
            JsonSchemaServiceEx schemaServiceEx = JsonSchemaService.Impl.getEx(((JsonStringLiteral)this.myElement).getProject());
            VirtualFile file2 = ((JsonStringLiteral)this.myElement).getContainingFile().getVirtualFile();
            if (file2 == null) {
                return null;
            }
            Collection<Pair<VirtualFile, String>> pairs = schemaServiceEx.getSchemaFilesByFile(file2);
            if (pairs != null && !pairs.isEmpty()) {
                for (Pair<VirtualFile, String> pair : pairs) {
                    PsiElement element;
                    VirtualFile schemaFile = (VirtualFile)pair.getFirst();
                    List<JsonSchemaWalker.Step> steps = JsonOriginalPsiWalker.INSTANCE.findPosition(this.getElement(), true, true);
                    if (steps == null || (element = new JsonSchemaInsideSchemaResolver(((JsonStringLiteral)this.myElement).getProject(), schemaFile, reference, steps).resolveInSchemaRecursively()) == null) continue;
                    return element;
                }
            }
            return null;
        }

        private String getReference() {
            ArrayList<String> names = new ArrayList<String>();
            PsiElement parent = ((JsonStringLiteral)this.getElement()).getParent();
            if (!(parent instanceof JsonProperty)) {
                return null;
            }
            JsonProperty element = (JsonProperty)parent;
            while (true) {
                PsiElement grand;
                names.add(StringUtil.unquoteString((String)element.getName()));
                if (!(element.getParent() instanceof JsonObject) || !((grand = element.getParent().getParent()) instanceof JsonProperty) || ((JsonProperty)grand).getValue() == null || !((JsonProperty)grand).getValue().equals(element.getParent())) break;
                element = (JsonProperty)grand;
            }
            StringBuilder path = new StringBuilder();
            Collections.reverse(names);
            for (String name : names) {
                path.append("/properties/").append(name);
            }
            return path.toString();
        }
    }
}

