/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public class FinalMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("final.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalMethodVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static class FinalMethodVisitor
    extends BaseInspectionVisitor {
        private FinalMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/FinalMethodInspection$FinalMethodVisitor", "visitMethod"));
            }
            if (!method2.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)method2, "final");
        }
    }
}

