/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classlayout.ProtectedMemberInFinalClassInspectionBase;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectedMemberInFinalClassInspection
extends ProtectedMemberInFinalClassInspectionBase {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveModifierFix((String)infos[0]), new MakePrivateFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static class MakePrivateFix
    extends InspectionGadgetsFix {
        private MakePrivateFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection$MakePrivateFix", "getElementToMakeWritable"));
            }
            return currentFile;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.private.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection$MakePrivateFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            boolean conflictsDialogOK;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMember)) {
                return;
            }
            PsiMember member = (PsiMember)grandParent;
            PsiModifierList modifierList = member.getModifierList();
            if (modifierList == null) {
                return;
            }
            MultiMap conflicts = new MultiMap();
            if (member instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)member;
                SuperMethodsSearch.search((PsiMethod)method2, (PsiClass)method2.getContainingClass(), (boolean)true, (boolean)false).forEach(methodSignature -> {
                    PsiMethod superMethod = methodSignature.getMethod();
                    conflicts.putValue((Object)superMethod, (Object)InspectionGadgetsBundle.message("0.will.have.incompatible.access.privileges.with.super.1", RefactoringUIUtil.getDescription((PsiElement)method2, false), RefactoringUIUtil.getDescription((PsiElement)superMethod, true)));
                    return true;
                });
                OverridingMethodsSearch.search((PsiMethod)method2).forEach(overridingMethod -> {
                    conflicts.putValue(overridingMethod, (Object)InspectionGadgetsBundle.message("0.will.no.longer.be.visible.from.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method2, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                    return false;
                });
            }
            PsiModifierList modifierListCopy = (PsiModifierList)modifierList.copy();
            modifierListCopy.setModifierProperty("private", true);
            Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)member.getResolveScope());
            search.forEach(reference -> {
                PsiElement element1 = reference.getElement();
                if (!JavaResolveUtil.isAccessible(member, member.getContainingClass(), modifierListCopy, element1, null, null)) {
                    PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element1, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                    conflicts.putValue((Object)element1, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, false), PsiBundle.visibilityPresentation((String)"private"), RefactoringUIUtil.getDescription(context, true)}));
                }
                return true;
            });
            if (conflicts.isEmpty()) {
                conflictsDialogOK = true;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                ConflictsDialog conflictsDialog = new ConflictsDialog(member.getProject(), (MultiMap<PsiElement, String>)conflicts, () -> ApplicationManager.getApplication().runWriteAction(() -> modifierList.setModifierProperty("private", true)));
                conflictsDialogOK = conflictsDialog.showAndGet();
            }
            if (conflictsDialogOK) {
                WriteAction.run(() -> modifierList.setModifierProperty("private", true));
            }
        }
    }
}

