/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CouplingVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_inClass;
    private final PsiClass m_class;
    private final boolean m_includeJavaClasses;
    private final boolean m_includeLibraryClasses;
    private final Set<String> m_dependencies = new HashSet<String>(10);

    CouplingVisitor(PsiClass aClass, boolean includeJavaClasses, boolean includeLibraryClasses) {
        this.m_class = aClass;
        this.m_includeJavaClasses = includeJavaClasses;
        this.m_includeLibraryClasses = includeLibraryClasses;
    }

    public void visitField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitField"));
        }
        super.visitField(field);
        PsiType type = field.getType();
        this.addDependency(type);
    }

    public void visitLocalVariable(@NotNull PsiLocalVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitLocalVariable"));
        }
        super.visitLocalVariable(var);
        PsiType type = var.getType();
        this.addDependency(type);
    }

    public void visitMethod(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitMethod"));
        }
        super.visitMethod(method2);
        PsiType returnType = method2.getReturnType();
        this.addDependency(returnType);
        this.addDependenciesForParameters(method2);
        this.addDependenciesForThrowsList(method2);
    }

    private void addDependenciesForThrowsList(PsiMethod method2) {
        PsiClassType[] throwsTypes;
        PsiReferenceList throwsList = method2.getThrowsList();
        for (PsiClassType throwsType : throwsTypes = throwsList.getReferencedTypes()) {
            this.addDependency((PsiType)throwsType);
        }
    }

    private void addDependenciesForParameters(PsiMethod method2) {
        PsiParameter[] parameters;
        PsiParameterList parameterList = method2.getParameterList();
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            PsiType parameterType = parameter.getType();
            this.addDependency(parameterType);
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitNewExpression"));
        }
        super.visitNewExpression(exp);
        PsiType classType = exp.getType();
        this.addDependency(classType);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression exp) {
        super.visitClassObjectAccessExpression(exp);
        PsiTypeElement operand = exp.getOperand();
        PsiType classType = operand.getType();
        this.addDependency(classType);
    }

    public void visitClass(@NotNull PsiClass aClass) {
        PsiClassType[] superTypes;
        int wasInClass;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitClass"));
        }
        if ((wasInClass = this.m_inClass++) == 0) {
            super.visitClass(aClass);
        }
        for (PsiClassType superType : superTypes = aClass.getSuperTypes()) {
            this.addDependency((PsiType)superType);
        }
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/classmetrics/CouplingVisitor", "elementFinished"));
        }
        super.elementFinished(element);
        if (element instanceof PsiClass) {
            --this.m_inClass;
        }
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement2) {
        PsiParameter[] catchBlockParameters;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitTryStatement"));
        }
        super.visitTryStatement(statement2);
        for (PsiParameter catchBlockParameter : catchBlockParameters = statement2.getCatchBlockParameters()) {
            PsiType catchType = catchBlockParameter.getType();
            this.addDependency(catchType);
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitInstanceOfExpression"));
        }
        super.visitInstanceOfExpression(exp);
        PsiTypeElement checkType = exp.getCheckType();
        if (checkType == null) {
            return;
        }
        PsiType classType = checkType.getType();
        this.addDependency(classType);
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/classmetrics/CouplingVisitor", "visitTypeCastExpression"));
        }
        super.visitTypeCastExpression(exp);
        PsiTypeElement castType = exp.getCastType();
        if (castType == null) {
            return;
        }
        PsiType classType = castType.getType();
        this.addDependency(classType);
    }

    private void addDependency(PsiType type) {
        if (type == null) {
            return;
        }
        PsiType baseType = type.getDeepComponentType();
        if (ClassUtils.isPrimitive(type)) {
            return;
        }
        String qualifiedName = this.m_class.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (baseType.equalsToText(qualifiedName)) {
            return;
        }
        String baseTypeName = baseType.getCanonicalText();
        String javaPrefix = "java.";
        String javaxPrefix = "javax.";
        if (!this.m_includeJavaClasses && (baseTypeName.startsWith("java.") || baseTypeName.startsWith("javax."))) {
            return;
        }
        if (!this.m_includeLibraryClasses) {
            Project project2 = this.m_class.getProject();
            GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project2);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project2).findClass(baseTypeName, searchScope);
            if (aClass == null) {
                return;
            }
            if (LibraryUtil.classIsInLibrary(aClass)) {
                return;
            }
        }
        if (StringUtil.startsWithConcatenation((String)baseTypeName, (String[])new String[]{qualifiedName, "."})) {
            return;
        }
        this.m_dependencies.add(baseTypeName);
    }

    int getNumDependencies() {
        return this.m_dependencies.size();
    }
}

