/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("RedundantConditionalExpression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "getID"));
        }
        return "RedundantConditionalExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacement = (String)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", replacement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = (String)infos[0];
        return new UnnecessaryConditionalFix(replacement);
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            PsiExpression condition = ParenthesesUtils.stripParentheses(expression.getCondition());
            if (condition == null) {
                return;
            }
            if (BoolUtils.isFalse(thenExpression) && BoolUtils.isTrue(elseExpression)) {
                this.registerError((PsiElement)expression, BoolUtils.getNegatedExpressionText(condition));
            } else if (BoolUtils.isTrue(thenExpression) && BoolUtils.isFalse(elseExpression)) {
                this.registerError((PsiElement)expression, condition.getText());
            } else if (this.isUnnecessary(condition, thenExpression, elseExpression, JavaTokenType.EQEQ)) {
                this.registerError((PsiElement)expression, elseExpression.getText());
            } else if (this.isUnnecessary(condition, elseExpression, thenExpression, JavaTokenType.NE)) {
                this.registerError((PsiElement)expression, thenExpression.getText());
            }
        }

        boolean isUnnecessary(PsiExpression condition, PsiExpression thenExpression, PsiExpression elseExpression, IElementType expectedToken) {
            if (!(condition instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType token = binaryExpression.getOperationTokenType();
            if (token != expectedToken) {
                return false;
            }
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return equivalence.expressionsAreEquivalent(thenExpression, lhs) && equivalence.expressionsAreEquivalent(elseExpression, rhs) || equivalence.expressionsAreEquivalent(thenExpression, rhs) && equivalence.expressionsAreEquivalent(elseExpression, lhs);
        }
    }

    private static class UnnecessaryConditionalFix
    extends InspectionGadgetsFix {
        private final String myReplacement;

        public UnnecessaryConditionalFix(String replacement) {
            this.myReplacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection$UnnecessaryConditionalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression = (PsiConditionalExpression)descriptor.getPsiElement();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, this.myReplacement);
        }
    }
}

