/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.ParameterizedParametersStaticCollectionInspectionBase;
import org.jetbrains.annotations.NotNull;

public class ParameterizedParametersStaticCollectionInspection
extends ParameterizedParametersStaticCollectionInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(final Object ... infos) {
        return new InspectionGadgetsFix(){

            @Override
            protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
                PsiElement element = descriptor.getPsiElement();
                PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
                if (method2 != null && infos[1] instanceof PsiType) {
                    PsiType type = (PsiType)infos[1];
                    ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, method2, false, "public", method2.getName(), type, new ParameterInfoImpl[0]);
                    csp.run();
                } else {
                    CreateMethodQuickFix fix;
                    PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                    if (psiClass != null && (fix = CreateMethodQuickFix.createFix(psiClass, "@org.junit.runners.Parameterized.Parameters public static java.util.Collection parameters()", "")) != null) {
                        fix.applyFix(project2, descriptor);
                    }
                }
            }

            @NotNull
            public String getName() {
                String string = infos.length > 0 ? (String)infos[0] : "Create @Parameterized.Parameters data provider";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/ParameterizedParametersStaticCollectionInspection$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                if ("Fix data provider signature" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/ParameterizedParametersStaticCollectionInspection$1", "getFamilyName"));
                }
                return "Fix data provider signature";
            }
        };
    }
}

