/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestCaseWithConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("JUnitTestCaseWithNonTrivialConstructors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestCaseWithConstructorInspection", "getID"));
        }
        return "JUnitTestCaseWithNonTrivialConstructors";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.with.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestCaseWithConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (Boolean.TRUE.equals(infos[0])) {
            String string = InspectionGadgetsBundle.message("test.case.with.constructor.problem.descriptor.initializer", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestCaseWithConstructorInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("test.case.with.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestCaseWithConstructorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithConstructorVisitor();
    }

    private static class TestCaseWithConstructorVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithConstructorVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestCaseWithConstructorInspection$TestCaseWithConstructorVisitor", "visitMethod"));
            }
            if (!method2.isConstructor()) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (!TestUtils.isJUnitTestClass(aClass) && !TestUtils.isJUnit4TestClass(aClass, false)) {
                return;
            }
            if (MethodUtils.isTrivial(method2, false)) {
                return;
            }
            this.registerMethodError(method2, Boolean.FALSE);
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = initializer.getContainingClass();
            if (!TestUtils.isJUnitTestClass(aClass) && !TestUtils.isJUnit4TestClass(aClass, true)) {
                return;
            }
            if (MethodUtils.isTrivial(initializer)) {
                return;
            }
            this.registerClassInitializerError(initializer, Boolean.TRUE);
        }
    }
}

