/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ObjectInstantiationInEqualsHashCodeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectInstantiationInEqualsHashCodeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[0]), PsiMethod.class);
        assert (method2 != null);
        if (infos.length > 1) {
            String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.problem.descriptor2", method2.getName(), infos[1]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectInstantiationInEqualsHashCodeInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.problem.descriptor", method2.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectInstantiationInEqualsHashCodeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectInstantiationInEqualsHashCodeVisitor();
    }

    private static class ObjectInstantiationInEqualsHashCodeVisitor
    extends BaseInspectionVisitor {
        private ObjectInstantiationInEqualsHashCodeVisitor() {
        }

        public void visitExpression(PsiExpression expression) {
            if (!ExpressionUtils.isAutoBoxed(expression) || !ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, "autoboxing");
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null || iteratedValue.getType() instanceof PsiArrayType || !ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)statement2)) {
                return;
            }
            this.registerError((PsiElement)iteratedValue, iteratedValue, "iterator");
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiMethod method2 = expression.resolveMethod();
            if (method2 == null) {
                return;
            }
            if (method2.isVarArgs()) {
                if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                    return;
                }
                this.registerError((PsiElement)expression, expression, "varargs call");
            } else {
                String name = methodExpression.getReferenceName();
                if (!"valueOf".equals(name)) {
                    return;
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                PsiExpression[] expressions = argumentList.getExpressions();
                if (expressions.length != 1) {
                    return;
                }
                PsiClass aClass = method2.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String qualifiedName = aClass.getQualifiedName();
                if (!("java.lang.Short".equals(qualifiedName) || "java.lang.Integer".equals(qualifiedName) || "java.lang.Long".equals(qualifiedName) || "java.lang.Double".equals(qualifiedName) || "java.lang.Float".equals(qualifiedName) || "java.lang.Character".equals(qualifiedName))) {
                    return;
                }
                if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                    return;
                }
                this.registerError((PsiElement)expression, expression);
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            if (!(expression.getParent() instanceof PsiVariable)) {
                return;
            }
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression) || ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)expression)) {
                return;
            }
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private static boolean isInsideEqualsOrHashCode(PsiElement element) {
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiAssertStatement.class, PsiThrowStatement.class});
            if (method2 == null) {
                return false;
            }
            return MethodUtils.isEquals(method2) || MethodUtils.isHashCode(method2) || MethodUtils.isCompareTo(method2) || MethodUtils.isComparatorCompare(method2);
        }
    }
}

