/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    private MethodUtils() {
    }

    @Contract(value="null -> false")
    public static boolean isComparatorCompare(@Nullable PsiMethod method2) {
        return method2 != null && MethodUtils.methodMatches(method2, "java.util.Comparator", (PsiType)PsiType.INT, "compare", null, null);
    }

    @Contract(value="null -> false")
    public static boolean isCompareTo(@Nullable PsiMethod method2) {
        return method2 != null && MethodUtils.methodMatches(method2, null, (PsiType)PsiType.INT, "compareTo", new PsiType[]{PsiType.NULL}) && InheritanceUtil.isInheritor((PsiClass)method2.getContainingClass(), (String)"java.lang.Comparable");
    }

    @Contract(value="null -> false")
    public static boolean isCompareToIgnoreCase(@Nullable PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method2);
        return MethodUtils.methodMatches(method2, "java.lang.String", (PsiType)PsiType.INT, "compareToIgnoreCase", new PsiType[]{stringType});
    }

    @Contract(value="null -> false")
    public static boolean isHashCode(@Nullable PsiMethod method2) {
        return method2 != null && MethodUtils.methodMatches(method2, null, (PsiType)PsiType.INT, "hashCode", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isFinalize(@Nullable PsiMethod method2) {
        return method2 != null && MethodUtils.methodMatches(method2, null, (PsiType)PsiType.VOID, "finalize", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isToString(@Nullable PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method2);
        return MethodUtils.methodMatches(method2, null, (PsiType)stringType, "toString", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isEquals(@Nullable PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        PsiClassType objectType = TypeUtils.getObjectType((PsiElement)method2);
        return MethodUtils.methodMatches(method2, null, (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{objectType});
    }

    @Contract(value="null -> false")
    public static boolean isEqualsIgnoreCase(@Nullable PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method2);
        return MethodUtils.methodMatches(method2, "java.lang.String", (PsiType)PsiType.BOOLEAN, "equalsIgnoreCase", new PsiType[]{stringType});
    }

    public static boolean methodMatches(@NotNull PsiMethod method2, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        String name;
        Matcher matcher;
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "methodMatches"));
        }
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(name = method2.getName())).matches()) {
            return false;
        }
        return MethodUtils.methodMatches(method2, containingClassName, returnType, parameterTypes);
    }

    public static boolean methodMatches(@NotNull PsiMethod method2, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "methodMatches"));
        }
        String name = method2.getName();
        if (methodName != null && !methodName.equals(name)) {
            return false;
        }
        return MethodUtils.methodMatches(method2, containingClassName, returnType, parameterTypes);
    }

    private static boolean methodMatches(@NotNull PsiMethod method2, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, PsiType ... parameterTypes) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "methodMatches"));
        }
        if (parameterTypes != null) {
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter parameter = parameters[i2];
                PsiType type = parameter.getType();
                PsiType parameterType = parameterTypes[i2];
                if (PsiType.NULL.equals((Object)parameterType) || parameterType == null || EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(type, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null) {
            PsiType methodReturnType = method2.getReturnType();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(returnType, methodReturnType)) {
                return false;
            }
        }
        if (containingClassName != null) {
            PsiClass containingClass = method2.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)containingClassName);
        }
        return true;
    }

    public static boolean simpleMethodMatches(@NotNull PsiMethod method2, @NonNls @Nullable String containingClassName, @NonNls @Nullable String returnTypeString, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "simpleMethodMatches"));
        }
        Project project2 = method2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        try {
            if (parameterTypeStrings != null) {
                PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
                for (int i2 = 0; i2 < parameterTypeStrings.length; ++i2) {
                    String parameterTypeString = parameterTypeStrings[i2];
                    parameterTypes[i2] = factory.createTypeFromText(parameterTypeString, (PsiElement)method2);
                }
                if (returnTypeString != null) {
                    PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method2);
                    return MethodUtils.methodMatches(method2, containingClassName, returnType, methodName, parameterTypes);
                }
                return MethodUtils.methodMatches(method2, containingClassName, null, methodName, parameterTypes);
            }
            if (returnTypeString != null) {
                PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method2);
                return MethodUtils.methodMatches(method2, containingClassName, returnType, methodName, new PsiType[0]);
            }
            return MethodUtils.methodMatches(method2, containingClassName, null, methodName, new PsiType[0]);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSuper(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "hasSuper"));
        }
        return MethodUtils.getSuper(method2) != null;
    }

    @Nullable
    public static PsiMethod getSuper(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "getSuper"));
        }
        MethodSignatureBackedByPsiMethod signature = MethodUtils.getSuperMethodSignature(method2);
        if (signature == null) {
            return null;
        }
        return signature.getMethod();
    }

    @Nullable
    public static MethodSignatureBackedByPsiMethod getSuperMethodSignature(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "getSuperMethodSignature"));
        }
        if (method2.isConstructor() || method2.hasModifierProperty("static") || method2.hasModifierProperty("private")) {
            return null;
        }
        return (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method2, null, (boolean)true, (boolean)false).findFirst();
    }

    public static boolean isOverridden(PsiMethod method2) {
        if (method2.isConstructor() || method2.hasModifierProperty("static") || method2.hasModifierProperty("private")) {
            return false;
        }
        Query overridingMethodQuery = OverridingMethodsSearch.search((PsiMethod)method2);
        PsiMethod result2 = (PsiMethod)overridingMethodQuery.findFirst();
        return result2 != null;
    }

    public static boolean isOverriddenInHierarchy(PsiMethod method2, PsiClass baseClass) {
        Query search = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)baseClass.getUseScope(), (boolean)true, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search) {
            PsiMethod overridingMethod = inheritor.findMethodBySignature(method2, false);
            if (overridingMethod == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(PsiMethod method2) {
        return ControlFlowUtils.isEmptyCodeBlock(method2.getBody());
    }

    public static boolean isTrivial(PsiMethod method2, boolean throwIsTrivial) {
        if (method2.hasModifierProperty("native")) {
            return false;
        }
        return MethodUtils.isTrivial(method2.getBody(), throwIsTrivial);
    }

    public static boolean isTrivial(PsiClassInitializer initializer) {
        return MethodUtils.isTrivial(initializer.getBody(), false);
    }

    private static boolean isTrivial(PsiCodeBlock codeBlock, boolean throwIsTrivial) {
        if (codeBlock == null) {
            return true;
        }
        PsiStatement[] statements = codeBlock.getStatements();
        if (statements.length == 0) {
            return true;
        }
        for (PsiStatement statement2 : statements) {
            if (statement2 instanceof PsiEmptyStatement) continue;
            if (statement2 instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (returnValue != null && !(returnValue instanceof PsiLiteralExpression)) continue;
                return true;
            }
            if (statement2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                PsiExpression condition = ifStatement.getCondition();
                Object result2 = ExpressionUtils.computeConstantExpression(condition);
                if (result2 != null && result2.equals(Boolean.FALSE)) continue;
                return false;
            }
            if (statement2 instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                if ("super".equals(methodExpression.getText())) continue;
                return false;
            }
            return throwIsTrivial && statement2 instanceof PsiThrowStatement;
        }
        return true;
    }

    public static boolean hasInThrows(@NotNull PsiMethod method2, String ... exceptions) {
        PsiJavaCodeReferenceElement[] references;
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodUtils", "hasInThrows"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/siyeh/ig/psiutils/MethodUtils", "hasInThrows"));
        }
        if (exceptions.length == 0) {
            throw new IllegalArgumentException("no exceptions specified");
        }
        PsiReferenceList throwsList = method2.getThrowsList();
        for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target;
            String qualifiedName = aClass.getQualifiedName();
            for (String exception : exceptions) {
                if (!exception.equals(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isChainable(PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)method2.getContainingClass(), (PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)method2.getReturnType()), (boolean)true)) {
            return false;
        }
        PsiElement navigationElement = method2.getNavigationElement();
        if (!(navigationElement instanceof PsiMethod)) {
            return false;
        }
        method2 = (PsiMethod)navigationElement;
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method2.getBody());
        if (!(lastStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)lastStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return returnValue instanceof PsiThisExpression;
    }
}

