/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiUtil {
    @Contract(value="null -> null")
    public static PsiType getStreamElementType(PsiType type) {
        return StreamApiUtil.getStreamElementType(type, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getStreamElementType(PsiType type, boolean variableType) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.IntStream")) {
            return PsiType.INT;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.LongStream")) {
            return PsiType.LONG;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.DoubleStream")) {
            return PsiType.DOUBLE;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.Stream")) {
            return null;
        }
        PsiType streamType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.stream.Stream", (int)0, (boolean)false);
        if (variableType) {
            if (streamType instanceof PsiIntersectionType) {
                return null;
            }
            streamType = GenericsUtil.getVariableTypeByExpressionType((PsiType)streamType);
        }
        return streamType;
    }

    public static boolean isNullOrEmptyStream(PsiExpression expression) {
        if (ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        String name = call.getMethodExpression().getReferenceName();
        if (!"empty".equals(name) && !"of".equals(name) || call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null || !method2.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.util.stream.");
    }

    @Contract(value="null -> false")
    public static boolean isSupportedStreamElement(PsiType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof PsiPrimitiveType) {
            return type.equals(PsiType.INT) || type.equals(PsiType.LONG) || type.equals(PsiType.DOUBLE);
        }
        return true;
    }

    @NotNull
    public static String generateMapOperation(PsiVariable variable, @Nullable PsiType outType, PsiElement mapper) {
        PsiType inType = variable.getType();
        if (mapper instanceof PsiExpression && ExpressionUtils.isReferenceTo((PsiExpression)mapper, variable)) {
            if (!(outType instanceof PsiPrimitiveType)) {
                String string = inType instanceof PsiPrimitiveType ? ".boxed()" : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
                }
                return string;
            }
            if (outType.equals(inType)) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
                }
                return "";
            }
            if (PsiType.LONG.equals((Object)outType) && PsiType.INT.equals((Object)inType)) {
                if (".asLongStream()" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
                }
                return ".asLongStream()";
            }
            if (PsiType.DOUBLE.equals((Object)outType) && (PsiType.LONG.equals((Object)inType) || PsiType.INT.equals((Object)inType))) {
                if (".asDoubleStream()" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
                }
                return ".asDoubleStream()";
            }
        }
        String operationName = "map";
        if (outType instanceof PsiPrimitiveType) {
            if (!outType.equals(inType)) {
                if (PsiType.INT.equals((Object)outType)) {
                    operationName = "mapToInt";
                } else if (PsiType.LONG.equals((Object)outType)) {
                    operationName = "mapToLong";
                } else if (PsiType.DOUBLE.equals((Object)outType)) {
                    operationName = "mapToDouble";
                }
            }
        } else if (inType instanceof PsiPrimitiveType) {
            operationName = "mapToObj";
        }
        if (outType != null && mapper instanceof PsiArrayInitializerExpression) {
            mapper = RefactoringUtil.convertInitializerToNormalExpression((PsiExpression)mapper, outType);
        }
        String typeArgument = mapper instanceof PsiExpression ? OptionalUtil.getMapTypeArgument((PsiExpression)mapper, outType) : "";
        String string = "." + typeArgument + operationName + "(" + variable.getName() + "->" + mapper.getText() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
        }
        return string;
    }
}

