/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UninitializedReadCollector {
    private final Set<PsiExpression> uninitializedReads = new HashSet<PsiExpression>();
    private int counter = 0;

    public PsiExpression[] getUninitializedReads() {
        return this.uninitializedReads.toArray(new PsiExpression[this.uninitializedReads.size()]);
    }

    public boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "blockAssignsVariable"));
        }
        return this.blockAssignsVariable(block, variable, this.counter, new HashSet<MethodSignature>());
    }

    private boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement[] statements;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "blockAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "blockAssignsVariable"));
        }
        if (this.counter != stamp) {
            return true;
        }
        if (block == null) {
            return false;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (this.statementAssignsVariable(statement2, variable, stamp, checkedMethods)) {
                return true;
            }
            if (this.counter == stamp) continue;
            return true;
        }
        return false;
    }

    private boolean statementAssignsVariable(@Nullable PsiStatement statement2, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "statementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "statementAssignsVariable"));
        }
        if (statement2 == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement2)) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return this.expressionAssignsVariable(returnValue, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement2;
            PsiExpression exception = throwStatement.getException();
            return this.expressionAssignsVariable(exception, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            PsiExpressionListStatement list = (PsiExpressionListStatement)statement2;
            PsiExpressionList expressionList = list.getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (!this.expressionAssignsVariable(expression, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression = expressionStatement.getExpression();
            return this.expressionAssignsVariable(expression, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            return this.declarationStatementAssignsVariable(declarationStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement2;
            return this.forStatementAssignsVariable(forStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement2;
            return this.foreachStatementAssignsVariable(foreachStatement, variable);
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            return this.whileStatementAssignsVariable(whileStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement2;
            return this.doWhileAssignsVariable(doWhileStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return this.blockAssignsVariable(body, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return this.blockAssignsVariable(codeBlock, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return this.statementAssignsVariable(statementLabeled, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            return this.ifStatementAssignsVariable(ifStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            return this.tryStatementAssignsVariable(tryStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement2;
            return this.switchStatementAssignsVariable(switchStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        assert (false) : "unknown statement: " + statement2;
        return false;
    }

    private boolean switchStatementAssignsVariable(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "switchStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "switchStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "switchStatementAssignsVariable"));
        }
        PsiExpression expression = switchStatement.getExpression();
        if (this.expressionAssignsVariable(expression, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i2 = 0; i2 < statements.length; ++i2) {
            PsiStatement statement2 = statements[i2];
            if (statement2 instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement2;
                if (i2 == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement2 instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i2 != statements.length - 1 || (assigns |= this.statementAssignsVariable(statement2, variable, stamp, checkedMethods))) continue;
            return false;
        }
        return containsDefault;
    }

    private boolean declarationStatementAssignsVariable(@NotNull PsiDeclarationStatement declarationStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement[] elements;
        if (declarationStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "declarationStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "declarationStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "declarationStatementAssignsVariable"));
        }
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable variableElement;
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || !this.expressionAssignsVariable(initializer = (variableElement = (PsiVariable)element).getInitializer(), variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementAssignsVariable(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "tryStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "tryStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "tryStatementAssignsVariable"));
        }
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer;
                if (!(resource instanceof PsiResourceVariable) || !this.expressionAssignsVariable(initializer = ((PsiResourceVariable)resource).getInitializer(), variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        boolean initializedInTryOrCatch = this.blockAssignsVariable(tryBlock, variable, stamp, checkedMethods);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            initializedInTryOrCatch &= this.blockAssignsVariable(catchBlock, variable, stamp, checkedMethods);
        }
        if (initializedInTryOrCatch) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return this.blockAssignsVariable(finallyBlock, variable, stamp, checkedMethods);
    }

    private boolean ifStatementAssignsVariable(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "ifStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "ifStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "ifStatementAssignsVariable"));
        }
        PsiExpression condition = ifStatement.getCondition();
        if (this.expressionAssignsVariable(condition, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return this.statementAssignsVariable(thenBranch, variable, stamp, checkedMethods) && this.statementAssignsVariable(elseBranch, variable, stamp, checkedMethods);
    }

    private boolean doWhileAssignsVariable(@NotNull PsiDoWhileStatement doWhileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (doWhileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doWhileStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "doWhileAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "doWhileAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "doWhileAssignsVariable"));
        }
        PsiExpression condition = doWhileStatement.getCondition();
        PsiStatement body = doWhileStatement.getBody();
        return this.statementAssignsVariable(body, variable, stamp, checkedMethods) || this.expressionAssignsVariable(condition, variable, stamp, checkedMethods);
    }

    private boolean whileStatementAssignsVariable(@NotNull PsiWhileStatement whileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement body;
        if (whileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "whileStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "whileStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "whileStatementAssignsVariable"));
        }
        PsiExpression condition = whileStatement.getCondition();
        if (this.expressionAssignsVariable(condition, variable, stamp, checkedMethods)) {
            return true;
        }
        return BoolUtils.isTrue(condition) && this.statementAssignsVariable(body = whileStatement.getBody(), variable, stamp, checkedMethods);
    }

    private boolean forStatementAssignsVariable(@NotNull PsiForStatement forStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "forStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "forStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "forStatementAssignsVariable"));
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (this.statementAssignsVariable(initialization, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression condition = forStatement.getCondition();
        if (this.expressionAssignsVariable(condition, variable, stamp, checkedMethods)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            PsiStatement body = forStatement.getBody();
            if (this.statementAssignsVariable(body, variable, stamp, checkedMethods)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (this.statementAssignsVariable(update, variable, stamp, checkedMethods)) {
                return true;
            }
        }
        return false;
    }

    private boolean foreachStatementAssignsVariable(PsiForeachStatement forStatement, PsiVariable variable) {
        return false;
    }

    private boolean expressionAssignsVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "expressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "expressionAssignsVariable"));
        }
        if (this.counter != stamp) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            return this.referenceExpressionAssignsVariable(referenceExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
            return this.methodCallAssignsVariable(callExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            return this.newExpressionAssignsVariable(newExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiExpression[] initializers;
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression;
            for (PsiExpression initializer : initializers = array.getInitializers()) {
                if (!this.expressionAssignsVariable(initializer, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression;
            PsiExpression operand = typeCast.getOperand();
            return this.expressionAssignsVariable(operand, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression;
            PsiExpression arrayExpression = accessExpression.getArrayExpression();
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            return this.expressionAssignsVariable(arrayExpression, variable, stamp, checkedMethods) || this.expressionAssignsVariable(indexExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiExpression operand = prefixExpression.getOperand();
            return this.expressionAssignsVariable(operand, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            PsiExpression operand = postfixExpression.getOperand();
            return this.expressionAssignsVariable(operand, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (!this.expressionAssignsVariable(operand, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression condition = conditional.getCondition();
            if (this.expressionAssignsVariable(condition, variable, stamp, checkedMethods)) {
                return true;
            }
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return this.expressionAssignsVariable(thenExpression, variable, stamp, checkedMethods) && this.expressionAssignsVariable(elseExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            return this.assignmentExpressionAssignsVariable(assignment, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return this.expressionAssignsVariable(innerExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            PsiExpression operand = instanceOfExpression.getOperand();
            return this.expressionAssignsVariable(operand, variable, stamp, checkedMethods);
        }
        return false;
    }

    private boolean assignmentExpressionAssignsVariable(@NotNull PsiAssignmentExpression assignment, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement element;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/UninitializedReadCollector", "assignmentExpressionAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "assignmentExpressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "assignmentExpressionAssignsVariable"));
        }
        PsiExpression lhs = ParenthesesUtils.stripParentheses(assignment.getLExpression());
        if (this.expressionAssignsVariable(lhs, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (this.expressionAssignsVariable(rhs, variable, stamp, checkedMethods)) {
            return true;
        }
        return lhs instanceof PsiReferenceExpression && (element = ((PsiReference)lhs).resolve()) != null && element.equals(variable);
    }

    private boolean referenceExpressionAssignsVariable(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/UninitializedReadCollector", "referenceExpressionAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "referenceExpressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "referenceExpressionAssignsVariable"));
        }
        PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
        if (this.expressionAssignsVariable(qualifierExpression, variable, stamp, checkedMethods)) {
            return true;
        }
        if (variable.equals(referenceExpression.resolve())) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)referenceExpression);
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && rhs.equals(referenceExpression)) {
                    this.checkReferenceExpression(referenceExpression, variable, qualifierExpression);
                }
            } else if (!(parent instanceof PsiExpression) || !ComparisonUtils.isNullComparison((PsiExpression)parent)) {
                this.checkReferenceExpression(referenceExpression, variable, qualifierExpression);
            }
        }
        return false;
    }

    private void checkReferenceExpression(PsiReferenceExpression referenceExpression, PsiVariable variable, PsiExpression qualifierExpression) {
        PsiReferenceExpression reference;
        PsiElement target;
        if (!referenceExpression.isQualified() || qualifierExpression instanceof PsiThisExpression) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        } else if (variable.hasModifierProperty("static") && qualifierExpression instanceof PsiReferenceExpression && (target = (reference = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiClass && target.equals(PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class))) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        }
    }

    private boolean newExpressionAssignsVariable(@NotNull PsiNewExpression newExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arrayDimensions;
        PsiArrayInitializerExpression arrayInitializer;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/psiutils/UninitializedReadCollector", "newExpressionAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "newExpressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "newExpressionAssignsVariable"));
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                if (!this.expressionAssignsVariable(arg, variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        if (this.expressionAssignsVariable((PsiExpression)(arrayInitializer = newExpression.getArrayInitializer()), variable, stamp, checkedMethods)) {
            return true;
        }
        for (PsiExpression dim : arrayDimensions = newExpression.getArrayDimensions()) {
            if (!this.expressionAssignsVariable(dim, variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean methodCallAssignsVariable(@NotNull PsiMethodCallExpression callExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arguments;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/psiutils/UninitializedReadCollector", "methodCallAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "methodCallAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "methodCallAssignsVariable"));
        }
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        if (this.expressionAssignsVariable((PsiExpression)methodExpression, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!this.expressionAssignsVariable(argument, variable, stamp, checkedMethods)) continue;
            return true;
        }
        PsiMethod method2 = callExpression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        MethodSignature methodSignature = method2.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method2.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method2.hasModifierProperty("static") || method2.isConstructor() || method2.hasModifierProperty("private") || method2.hasModifierProperty("final") || calledClass.hasModifierProperty("final")) {
            PsiCodeBlock body = method2.getBody();
            return this.blockAssignsVariable(body, variable, stamp, checkedMethods);
        }
        return false;
    }
}

