/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedInInnerClassVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean usedInInnerClass;
    private int inInnerClassCount;

    VariableUsedInInnerClassVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "<init>"));
        }
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "visitElement"));
        }
        if (!this.usedInInnerClass) {
            super.visitElement(element);
        }
    }

    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        PsiElement parent = token.getParent();
        if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (token.getTokenType() == JavaTokenType.LBRACE && aClass.getLBrace() == token) {
                ++this.inInnerClassCount;
            }
            if (token.getTokenType() == JavaTokenType.RBRACE && aClass.getRBrace() == token) {
                --this.inInnerClassCount;
            }
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        super.visitLambdaExpression(expression);
        ++this.inInnerClassCount;
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "elementFinished"));
        }
        super.elementFinished(element);
        if (element instanceof PsiLambdaExpression) {
            --this.inInnerClassCount;
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        PsiElement target;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "visitReferenceExpression"));
        }
        if (this.usedInInnerClass) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        if (this.inInnerClassCount > 0 && this.variable.equals(target = referenceExpression.resolve())) {
            this.usedInInnerClass = true;
        }
    }

    boolean isUsedInInnerClass() {
        return this.usedInInnerClass;
    }
}

