/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ControlFlowStatementVisitorBase
extends BaseInspectionVisitor {
    public void visitForeachStatement(PsiForeachStatement statement2) {
        super.visitForeachStatement(statement2);
        PsiStatement body = statement2.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement2, body, "for");
        }
    }

    public void visitForStatement(PsiForStatement statement2) {
        super.visitForStatement(statement2);
        PsiStatement body = statement2.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement2, body, "for");
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement2) {
        super.visitWhileStatement(statement2);
        PsiStatement body = statement2.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement2, body, "while");
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        super.visitDoWhileStatement(statement2);
        PsiStatement body = statement2.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement2, body, "do");
        }
    }

    public void visitIfStatement(PsiIfStatement statement2) {
        PsiStatement elseBranch;
        super.visitIfStatement(statement2);
        PsiStatement thenBranch = statement2.getThenBranch();
        if (this.isApplicable(thenBranch)) {
            this.registerControlFlowStatementErrors(statement2.getFirstChild(), thenBranch.getLastChild(), thenBranch, "if");
        }
        if (this.isApplicable(elseBranch = statement2.getElseBranch())) {
            this.registerControlFlowStatementErrors((PsiElement)statement2.getElseElement(), elseBranch.getLastChild(), elseBranch, "else");
        }
    }

    @Contract(value="null->false")
    protected abstract boolean isApplicable(PsiStatement var1);

    @Nullable
    protected abstract Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement var1);

    private void registerLoopStatementErrors(@NotNull PsiLoopStatement statement2, @NotNull PsiStatement body, @NotNull String keywordText) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerLoopStatementErrors"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerLoopStatementErrors"));
        }
        if (keywordText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordText", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerLoopStatementErrors"));
        }
        this.registerControlFlowStatementErrors(statement2.getFirstChild(), statement2.getLastChild(), body, keywordText);
    }

    private void registerControlFlowStatementErrors(@Nullable PsiElement rangeStart, @Nullable PsiElement rangeEnd, @NotNull PsiStatement body, @NotNull String keywordText) {
        PsiElement afterOmitted;
        PsiElement endOfHighlight;
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerControlFlowStatementErrors"));
        }
        if (keywordText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordText", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerControlFlowStatementErrors"));
        }
        boolean highlightOnlyKeyword = this.isVisibleHighlight((PsiElement)body);
        if (highlightOnlyKeyword) {
            if (rangeStart != null) {
                this.registerError(rangeStart, keywordText);
            }
            return;
        }
        Pair<PsiElement, PsiElement> omittedBodyBounds = this.getOmittedBodyBounds(body);
        if (omittedBodyBounds == null) {
            if (rangeStart != null && rangeEnd != null) {
                this.registerErrorAtRange(rangeStart, rangeEnd, keywordText);
            }
            return;
        }
        if (rangeStart != null) {
            PsiElement beforeOmitted = (PsiElement)omittedBodyBounds.getFirst();
            endOfHighlight = beforeOmitted != null ? beforeOmitted : rangeStart;
            this.registerErrorAtRange(rangeStart, endOfHighlight, keywordText);
        }
        if ((afterOmitted = (PsiElement)omittedBodyBounds.getSecond()) != null) {
            endOfHighlight = afterOmitted;
            if (rangeEnd != null && rangeEnd != afterOmitted) {
                if (afterOmitted.getParent() == rangeEnd) {
                    PsiElement rangeEndLastChild = rangeEnd.getLastChild();
                    if (rangeEndLastChild != null) {
                        endOfHighlight = rangeEndLastChild;
                    }
                } else {
                    endOfHighlight = rangeEnd;
                }
            }
            this.registerErrorAtRange(afterOmitted, endOfHighlight, keywordText);
        }
    }
}

