/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeReplacedWithAnonymousInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaCanBeReplacedWithAnonymousInspection.class.getName()));

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.can.be.replaced.with.anonymous.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaToAnonymousVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LambdaToAnonymousFix();
    }

    private static void doFix(@NotNull Project project2, @NotNull PsiLambdaExpression lambdaExpression) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection", "doFix"));
        }
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection", "doFix"));
        }
        PsiParameter[] paramListCopy = ((PsiParameterList)lambdaExpression.getParameterList().copy()).getParameters();
        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
        LOG.assertTrue(functionalInterfaceType != null);
        PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        LOG.assertTrue(method2 != null);
        String blockText = LambdaCanBeReplacedWithAnonymousInspection.getBodyText(lambdaExpression);
        if (blockText == null) {
            return;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiCodeBlock blockFromText = psiElementFactory.createCodeBlockFromText(blockText, (PsiElement)lambdaExpression);
        LambdaCanBeReplacedWithAnonymousInspection.qualifyThisExpressions(lambdaExpression, psiElementFactory, blockFromText);
        blockFromText = psiElementFactory.createCodeBlockFromText(blockFromText.getText(), null);
        PsiNewExpression newExpression = (PsiNewExpression)psiElementFactory.createExpressionFromText("new " + functionalInterfaceType.getCanonicalText() + "(){}", (PsiElement)lambdaExpression);
        newExpression = (PsiNewExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(lambdaExpression.replace((PsiElement)newExpression));
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        LOG.assertTrue(anonymousClass != null);
        List<PsiGenerationInfo<PsiMethod>> infos = OverrideImplementUtil.overrideOrImplement((PsiClass)anonymousClass, method2);
        if (infos != null && infos.size() == 1) {
            PsiCodeBlock codeBlock;
            PsiMethod member = infos.get(0).getPsiMember();
            PsiParameter[] parameters = member.getParameterList().getParameters();
            if (parameters.length == paramListCopy.length) {
                for (int i2 = 0; i2 < parameters.length; ++i2) {
                    PsiParameter parameter = parameters[i2];
                    String lambdaParamName = paramListCopy[i2].getName();
                    if (lambdaParamName == null) continue;
                    parameter.setName(lambdaParamName);
                }
            }
            LOG.assertTrue((codeBlock = member.getBody()) != null);
            codeBlock.replace((PsiElement)blockFromText);
            PsiElement parent = anonymousClass.getParent().getParent();
            if (parent instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)parent))) {
                PsiExpression operand = ((PsiTypeCastExpression)parent).getOperand();
                LOG.assertTrue(operand != null);
                parent.replace((PsiElement)operand);
            }
        }
    }

    private static void qualifyThisExpressions(PsiLambdaExpression lambdaExpression, PsiElementFactory psiElementFactory, PsiCodeBlock blockFromText) {
        String thisClassName;
        ChangeContextUtil.encodeContextInfo((PsiElement)blockFromText, true);
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)lambdaExpression);
        String string = thisClassName = thisClass != null && !(thisClass instanceof PsiSyntheticClass) ? thisClass.getName() : null;
        if (thisClassName != null) {
            final PsiThisExpression thisAccessExpr = RefactoringChangeUtil.createThisExpression(lambdaExpression.getManager(), thisClass);
            ChangeContextUtil.decodeContextInfo((PsiElement)blockFromText, thisClass, (PsiExpression)thisAccessExpr);
            final HashSet replacements = new HashSet();
            blockFromText.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitSuperExpression(PsiSuperExpression expression) {
                    super.visitSuperExpression(expression);
                    if (expression.getQualifier() == null) {
                        replacements.add(expression);
                    }
                }

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    if (thisAccessExpr != null) {
                        PsiMethod psiMethod = expression.resolveMethod();
                        PsiReferenceExpression methodExpression = expression.getMethodExpression();
                        if (psiMethod != null && !psiMethod.hasModifierProperty("static") && methodExpression.getQualifierExpression() == null) {
                            replacements.add(expression);
                        }
                    }
                }
            });
            for (PsiExpression expression : replacements) {
                if (expression instanceof PsiSuperExpression) {
                    expression.replace((PsiElement)psiElementFactory.createExpressionFromText(thisClassName + "." + expression.getText(), (PsiElement)expression));
                    continue;
                }
                if (expression instanceof PsiMethodCallExpression) {
                    ((PsiMethodCallExpression)expression).getMethodExpression().setQualifierExpression((PsiExpression)thisAccessExpr);
                    continue;
                }
                LOG.error("Unexpected expression");
            }
        }
    }

    private static String getBodyText(PsiLambdaExpression lambdaExpression) {
        String blockText;
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
            blockText = "{";
            blockText = blockText + (PsiType.VOID.equals((Object)returnType) ? "" : "return ");
            blockText = blockText + body.getText() + ";}";
        } else {
            blockText = body != null ? body.getText() : null;
        }
        return blockText;
    }

    private static class LambdaToAnonymousFix
    extends InspectionGadgetsFix {
        private LambdaToAnonymousFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("lambda.can.be.replaced.with.anonymous.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection$LambdaToAnonymousFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiLambdaExpression) {
                LambdaCanBeReplacedWithAnonymousInspection.doFix(project2, (PsiLambdaExpression)parent);
            }
        }
    }

    private static class LambdaToAnonymousVisitor
    extends BaseInspectionVisitor {
        private LambdaToAnonymousVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            if (LambdaToAnonymousVisitor.isConvertibleLambdaExpression((PsiElement)lambdaExpression)) {
                PsiParameterList parameterList = lambdaExpression.getParameterList();
                PsiElement nextElement = PsiTreeUtil.skipSiblingsForward((PsiElement)parameterList, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                if (nextElement instanceof PsiJavaToken && ((PsiJavaToken)nextElement).getTokenType() == JavaTokenType.ARROW) {
                    this.registerErrorAtRange((PsiElement)parameterList, nextElement, new Object[0]);
                } else {
                    this.registerError((PsiElement)parameterList, new Object[0]);
                }
            }
        }

        private static boolean isConvertibleLambdaExpression(PsiElement parent) {
            if (parent instanceof PsiLambdaExpression) {
                PsiMethod interfaceMethod;
                PsiType functionalInterfaceType;
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)parent;
                PsiClass thisClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiClass.class, (boolean)true);
                if (thisClass == null || thisClass instanceof PsiAnonymousClass) {
                    PsiElement body = lambdaExpression.getBody();
                    if (body == null) {
                        return false;
                    }
                    final boolean[] disabled = new boolean[1];
                    body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitThisExpression(PsiThisExpression expression) {
                            disabled[0] = true;
                        }

                        public void visitSuperExpression(PsiSuperExpression expression) {
                            disabled[0] = true;
                        }
                    });
                    if (disabled[0]) {
                        return false;
                    }
                }
                if ((functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType()) != null && LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)functionalInterfaceType) && LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType)) != null) {
                    PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
                    for (PsiType type : interfaceMethod.getSignature(substitutor).getParameterTypes()) {
                        if (PsiTypesUtil.isDenotableType((PsiType)type)) continue;
                        return false;
                    }
                    PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                    return PsiTypesUtil.isDenotableType((PsiType)returnType);
                }
            }
            return false;
        }
    }
}

