/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.ReplaceConditionalWithIfPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConditionalWithIfIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceConditionalWithIfIntention.class.getName()));

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ReplaceConditionalWithIfPredicate replaceConditionalWithIfPredicate = new ReplaceConditionalWithIfPredicate();
        if (replaceConditionalWithIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "getElementPredicate"));
        }
        return replaceConditionalWithIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "processIntention"));
        }
        PsiConditionalExpression expression = (PsiConditionalExpression)element;
        ReplaceConditionalWithIfIntention.replaceConditionalWithIf(expression);
    }

    private static void replaceConditionalWithIf(PsiConditionalExpression expression) {
        PsiStatement statement2;
        PsiElement expressionParent = expression.getParent();
        if (expressionParent instanceof PsiLambdaExpression) {
            PsiElement codeBlock = ((PsiLambdaExpression)RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiElement)expression)).getBody();
            LOG.assertTrue(codeBlock instanceof PsiCodeBlock, (Object)codeBlock);
            PsiStatement statement3 = ((PsiCodeBlock)codeBlock).getStatements()[0];
            expression = (PsiConditionalExpression)(statement3 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement3).getReturnValue() : ((PsiExpressionStatement)statement3).getExpression());
        }
        if ((statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class)) == null) {
            return;
        }
        PsiVariable variable = statement2 instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiVariable.class) : null;
        PsiExpression thenExpression = ParenthesesUtils.stripParentheses(expression.getThenExpression());
        PsiExpression elseExpression = ParenthesesUtils.stripParentheses(expression.getElseExpression());
        PsiExpression condition = ParenthesesUtils.stripParentheses(expression.getCondition());
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        if (condition != null) {
            newStatement.append(condition.getText());
        }
        newStatement.append(')');
        if (variable != null) {
            int conditionIdx;
            String name = variable.getName();
            newStatement.append(name).append('=');
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (initializer instanceof PsiArrayInitializerExpression && (conditionIdx = ArrayUtilRt.find((Object[])((PsiArrayInitializerExpression)initializer).getInitializers(), (Object)expression)) >= 0) {
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)(initializer = (PsiExpression)initializer.replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, variable.getType())))).getArrayInitializer();
                LOG.assertTrue(arrayInitializer != null, (Object)initializer.getText());
                expression = (PsiConditionalExpression)arrayInitializer.getInitializers()[conditionIdx];
                thenExpression = expression.getThenExpression();
                elseExpression = expression.getElseExpression();
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression, thenExpression, newStatement);
            newStatement.append("; else ").append(name).append('=');
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression, elseExpression, newStatement);
            newStatement.append(';');
            initializer.delete();
            PsiManager manager = statement2.getManager();
            Project project2 = manager.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement ifStatement = factory.createStatementFromText(newStatement.toString(), (PsiElement)statement2);
            PsiElement parent = statement2.getParent();
            PsiElement addedElement = parent.addAfter((PsiElement)ifStatement, (PsiElement)statement2);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            styleManager.reformat(addedElement);
        } else {
            boolean addBraces;
            boolean bl = addBraces = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null;
            if (addBraces || thenExpression == null) {
                newStatement.append('{');
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement2, (PsiExpression)expression, thenExpression, newStatement);
            if (addBraces) {
                newStatement.append("} else {");
            } else {
                if (thenExpression == null) {
                    newStatement.append('}');
                }
                newStatement.append(" else ");
                if (elseExpression == null) {
                    newStatement.append('{');
                }
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement2, (PsiExpression)expression, elseExpression, newStatement);
            if (addBraces || elseExpression == null) {
                newStatement.append('}');
            }
            PsiReplacementUtil.replaceStatement(statement2, newStatement.toString());
        }
    }

    private static void appendElementTextWithoutParentheses(@NotNull PsiElement element, @NotNull PsiExpression expressionToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementTextWithoutParentheses"));
        }
        if (expressionToReplace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToReplace", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementTextWithoutParentheses"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementTextWithoutParentheses"));
        }
        PsiElement expressionParent = expressionToReplace.getParent();
        if (expressionParent instanceof PsiParenthesizedExpression) {
            PsiElement grandParent = expressionParent.getParent();
            if (replacementExpression == null || !(grandParent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(replacementExpression, (PsiExpression)grandParent, false)) {
                ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses(element, (PsiExpression)expressionParent, replacementExpression, out);
                return;
            }
        }
        boolean needsCast = replacementExpression != null && MethodCallUtils.isNecessaryForSurroundingMethodCall(expressionToReplace, replacementExpression);
        ReplaceConditionalWithIfIntention.appendElementText(element, expressionToReplace, replacementExpression, needsCast, out);
    }

    private static void appendElementText(@NotNull PsiElement element, @NotNull PsiExpression elementToReplace, @Nullable PsiExpression replacementExpression, boolean insertCast, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementText"));
        }
        if (elementToReplace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToReplace", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementText"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementText"));
        }
        if (element.equals(elementToReplace)) {
            String replacementText = replacementExpression == null ? "" : replacementExpression.getText();
            PsiType type = GenericsUtil.getVariableTypeByExpressionType((PsiType)ExpectedTypeUtils.findExpectedType(elementToReplace, true));
            if (insertCast && type != null) {
                out.append('(').append(type.getCanonicalText()).append(')');
            }
            out.append(replacementText);
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            PsiComment comment;
            IElementType tokenType;
            out.append(element.getText());
            if (element instanceof PsiComment && (tokenType = (comment = (PsiComment)element).getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
                out.append('\n');
            }
            return;
        }
        for (PsiElement child : children2) {
            ReplaceConditionalWithIfIntention.appendElementText(child, elementToReplace, replacementExpression, insertCast, out);
        }
    }
}

