/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpFactory;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SingleCharAlternationInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Single character alternation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection", "getDisplayName"));
        }
        return "Single character alternation";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection", "buildVisitor"));
        }
        SingleCharAlternationVisitor singleCharAlternationVisitor = new SingleCharAlternationVisitor(holder);
        if (singleCharAlternationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection", "buildVisitor"));
        }
        return singleCharAlternationVisitor;
    }

    static String buildReplacementText(RegExpPattern pattern) {
        StringBuilder text = new StringBuilder("[");
        for (RegExpBranch branch : pattern.getBranches()) {
            for (PsiElement child : branch.getChildren()) {
                RegExpChar ch = (RegExpChar)child;
                IElementType type = ch.getNode().getFirstChildNode().getElementType();
                if (type == RegExpTT.REDUNDANT_ESCAPE) {
                    text.append((char)ch.getValue());
                    continue;
                }
                if (type == RegExpTT.ESC_CHARACTER) {
                    int value = ch.getValue();
                    switch (value) {
                        case 36: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 46: 
                        case 63: 
                        case 123: 
                        case 124: {
                            text.append((char)value);
                            break;
                        }
                        case 94: {
                            if (text.length() == 1) {
                                text.append(ch.getText());
                                break;
                            }
                            text.append((char)value);
                            break;
                        }
                        default: {
                            text.append(ch.getText());
                            break;
                        }
                    }
                    continue;
                }
                text.append(ch.getText());
            }
        }
        text.append("]");
        return text.toString();
    }

    private static class SingleCharAlternationVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public SingleCharAlternationVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            for (RegExpBranch branch : branches) {
                RegExpAtom[] atoms = branch.getAtoms();
                if (atoms.length == 1 && atoms[0] instanceof RegExpChar) continue;
                return;
            }
            String text = SingleCharAlternationInspection.buildReplacementText(pattern);
            this.myHolder.registerProblem((PsiElement)pattern, "Single character alternation in RegExp", new LocalQuickFix[]{new SingleCharAlternationFix(text)});
        }

        private static class SingleCharAlternationFix
        implements LocalQuickFix {
            private final String myText;

            public SingleCharAlternationFix(String text) {
                this.myText = text;
            }

            @Nls
            @NotNull
            public String getName() {
                String string = "Replace with '" + this.myText + '\'';
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection$SingleCharAlternationVisitor$SingleCharAlternationFix", "getName"));
                }
                return string;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Replace alternation with character class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection$SingleCharAlternationVisitor$SingleCharAlternationFix", "getFamilyName"));
                }
                return "Replace alternation with character class";
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection$SingleCharAlternationVisitor$SingleCharAlternationFix", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection$SingleCharAlternationVisitor$SingleCharAlternationFix", "applyFix"));
                }
                PsiElement element = descriptor.getPsiElement();
                if (!(element instanceof RegExpPattern)) {
                    return;
                }
                RegExpPattern pattern = (RegExpPattern)element;
                String text = SingleCharAlternationInspection.buildReplacementText(pattern);
                RegExpBranch branch = RegExpFactory.createBranchFromText(text, element);
                pattern.replace(branch.getAtoms()[0]);
            }
        }
    }
}

