/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;

class SimplifyQuantifierAction
implements IntentionAction {
    private final RegExpQuantifier myQuantifier;
    private final String myReplacement;

    public SimplifyQuantifierAction(RegExpQuantifier quantifier, String s) {
        this.myQuantifier = quantifier;
        this.myReplacement = s;
    }

    @NotNull
    public String getText() {
        String string = this.myReplacement == null ? "Simplify" : "Replace with '" + this.myReplacement + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Simplify Quantifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "getFamilyName"));
        }
        return "Simplify Quantifier";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "isAvailable"));
        }
        return this.myQuantifier.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "invoke"));
        }
        if (this.myReplacement == null) {
            this.myQuantifier.delete();
        } else {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
            ASTNode modifier = this.myQuantifier.getModifier();
            PsiFile f = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)("a" + this.myReplacement + (modifier != null ? modifier.getText() : "")));
            RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
            assert (pattern != null);
            RegExpClosure closure = (RegExpClosure)pattern.getBranches()[0].getAtoms()[0];
            this.myQuantifier.replace(closure.getQuantifier());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

