/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.PlatformUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.SuitableRoot;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "built-in-server"})
final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2, @NotNull PathQuery pathQuery) {
        Object it;
        int n;
        Object[] $receiver$iv;
        void effectivePath;
        int index;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = path;
        if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((CharSequence)((String)effectivePath.element), (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = (String)effectivePath.element;
            String string2 = project2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
            if (!StringsKt.regionMatches((String)string, (int)0, (String)string2, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                String string3 = (String)effectivePath.element;
                int n2 = 0;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2, index);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String moduleName = string5;
                Module module2 = (Module)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, moduleName){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $moduleName$inlined;
                    {
                        this.$project$inlined = project2;
                        this.$moduleName$inlined = string;
                    }

                    public final T compute() {
                        return (T)ModuleManager.getInstance((Project)this.$project$inlined).findModuleByName(this.$moduleName$inlined);
                    }
                });
                if (module2 != null && !module2.isDisposed()) {
                    PathInfo result2;
                    PathInfo pathInfo;
                    PathInfo pathInfo2;
                    FileResolver resolver2;
                    block20: {
                        String $i$f$runReadAction = (String)effectivePath.element;
                        int n3 = index + 1;
                        void var18_20 = effectivePath;
                        String string6 = $i$f$runReadAction;
                        if (string6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                        String string8 = string7;
                        var18_20.element = string8;
                        resolver2 = pathToFileManager.getResolver((String)effectivePath.element);
                        $receiver$iv = (Object[])RootProvider.values();
                        for (n = 0; n < $receiver$iv.length; ++n) {
                            Object file$iv = $receiver$iv[n];
                            it = (RootProvider)((Object)file$iv);
                            PathInfo result$iv = DefaultWebServerRootsProviderKt.access$findByRelativePath((String)effectivePath.element, it.getRoots(ProjectKt.getRootManager(module2)), resolver2, moduleName, pathQuery);
                            if (result$iv == null) continue;
                            pathInfo2 = result$iv;
                            break block20;
                        }
                        pathInfo2 = pathInfo = null;
                    }
                    if (pathInfo2 == null) {
                        pathInfo = result2 = DefaultWebServerRootsProviderKt.access$findInModuleLibraries((String)effectivePath.element, module2, resolver2, pathQuery);
                    }
                    if (result2 != null) {
                        return result2;
                    }
                }
            }
        }
        FileResolver resolver = pathToFileManager.getResolver((String)effectivePath.element);
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction(new Computable<T>(project2){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project2;
            }

            public final T compute() {
                return (T)ModuleManager.getInstance((Project)this.$project$inlined).getModules();
            }
        });
        if (pathQuery.getUseVfs()) {
            String oldestParent;
            String string;
            int resolver2 = StringsKt.indexOf$default((CharSequence)((CharSequence)path), (String)"/", (int)0, (boolean)false, (int)6, null);
            int it2 = resolver2;
            if (it2 > 0) {
                $receiver$iv = path;
                n = 0;
                String string9 = $receiver$iv.substring(n, it2);
                string = string9;
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = oldestParent = null;
            }
            if (oldestParent == null && !((resolver2 = (CharSequence)path).length() == 0) && !StringsKt.contains$default((CharSequence)((CharSequence)path), (char)'.', (boolean)false, (int)2, null)) {
                oldestParent = path;
            }
            if (oldestParent != null) {
                for (SuitableRoot root : (List)pathToFileManager.getParentToSuitableRoot$built_in_server().get((Object)oldestParent)) {
                    VirtualFile virtualFile = root.getFile().findFileByRelativePath((String)path);
                    if (virtualFile == null) continue;
                    Object[] it3 = $receiver$iv = virtualFile;
                    return new PathInfo(null, (VirtualFile)it3, root.getFile(), root.getModuleQualifier(), false, false, 48, null);
                }
            }
        } else {
            RootProvider[] it2 = RootProvider.values();
            for (int root = 0; root < it2.length; ++root) {
                RootProvider rootProvider = it2[root];
                for (n = 0; n < modules.length; ++n) {
                    Module module3 = modules[n];
                    if (module3.isDisposed()) continue;
                    PathInfo pathInfo = DefaultWebServerRootsProviderKt.access$findByRelativePath((String)path, rootProvider.getRoots(ProjectKt.getRootManager(module3)), resolver, null, pathQuery);
                    if (pathInfo == null) continue;
                    PathInfo pathInfo3 = pathInfo;
                    it = pathInfo3;
                    it.setModuleName(DefaultWebServerRootsProviderKt.getModuleNameQualifier(project2, module3));
                    return it;
                }
            }
        }
        if (!pathQuery.getSearchInLibs()) {
            return null;
        }
        Function0<PathInfo> findByConfigJson$ = new Function0<PathInfo>(modules, resolver, pathQuery, project2){
            final /* synthetic */ Module[] $modules;
            final /* synthetic */ FileResolver $resolver;
            final /* synthetic */ PathQuery $pathQuery;
            final /* synthetic */ Project $project;

            @Nullable
            public final PathInfo invoke() {
                RootProvider[] rootProviderArray = RootProvider.values();
                for (int j = 0; j < rootProviderArray.length; ++j) {
                    RootProvider rootProvider = rootProviderArray[j];
                    Module[] moduleArray = this.$modules;
                    for (int k = 0; k < moduleArray.length; ++k) {
                        Module module2 = moduleArray[k];
                        if (module2.isDisposed()) continue;
                        VirtualFile[] virtualFileArray = rootProvider.getRoots(ProjectKt.getRootManager(module2));
                        for (int i2 = 0; i2 < virtualFileArray.length; ++i2) {
                            PathInfo pathInfo;
                            VirtualFile root = virtualFileArray[i2];
                            if (FileResolver.DefaultImpls.resolve$default(this.$resolver, "config.json", root, null, false, this.$pathQuery, 12, null) == null) continue;
                            PathInfo pathInfo2 = FileResolver.DefaultImpls.resolve$default(this.$resolver, "index.html", root, null, false, this.$pathQuery, 12, null);
                            if (pathInfo2 == null) continue;
                            PathInfo it = pathInfo = pathInfo2;
                            it.setModuleName(DefaultWebServerRootsProviderKt.getModuleNameQualifier(this.$project, module2));
                            return it;
                        }
                    }
                }
                return null;
            }
            {
                this.$modules = moduleArray;
                this.$resolver = fileResolver;
                this.$pathQuery = pathQuery;
                this.$project = project2;
                super(0);
            }
        };
        Boolean exists = (Boolean)pathToFileManager.getPathToExistShortTermCache$built_in_server().getIfPresent((Object)"config.json");
        if (exists == null || exists.booleanValue()) {
            PathInfo result3 = findByConfigJson$.invoke();
            pathToFileManager.getPathToExistShortTermCache$built_in_server().put((Object)"config.json", (Object)(result3 != null ? 1 : 0));
            if (result3 != null) {
                return result3;
            }
        }
        return DefaultWebServerRootsProviderKt.access$findInLibraries(project2, (String)effectivePath.element, resolver, pathQuery);
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return (PathInfo)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, file2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $file$inlined;
            {
                this.$project$inlined = project2;
                this.$file$inlined = virtualFile;
            }

            public final T compute() {
                PathInfo pathInfo;
                DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.$project$inlined);
                DirectoryInfo info = directoryIndex.getInfoForFile(this.$file$inlined);
                if (!info.isExcluded() && !info.isInProject()) {
                    pathInfo = Intrinsics.areEqual((Object)this.$file$inlined.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProviderKt.access$getInfoForDocJar(this.$file$inlined, this.$project$inlined) : null;
                } else {
                    boolean isLibrary;
                    boolean isRootNameOptionalInPath;
                    VirtualFile root = info.getSourceRoot();
                    if (root == null) {
                        isRootNameOptionalInPath = false;
                        root = info.getContentRoot();
                        if (root == null) {
                            boolean bl;
                            root = info.getLibraryClassRoot();
                            isLibrary = true;
                            boolean bl2 = bl = root != null;
                            if (_Assertions.ENABLED && !bl) {
                                String string = this.$file$inlined.getPresentableUrl();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.presentableUrl");
                                String string2 = string;
                                throw (Throwable)((Object)new AssertionError((Object)string2));
                            }
                        } else {
                            isLibrary = false;
                        }
                    } else {
                        isLibrary = info.isInLibrarySource();
                        isRootNameOptionalInPath = !isLibrary;
                    }
                    Module module2 = info.getModule();
                    if (isLibrary && module2 == null) {
                        for (OrderEntry entry : directoryIndex.getOrderEntries(info)) {
                            if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                            module2 = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                            break;
                        }
                    }
                    VirtualFile virtualFile = root;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root!!");
                    pathInfo = new PathInfo(null, this.$file$inlined, virtualFile, DefaultWebServerRootsProviderKt.getModuleNameQualifier(this.$project$inlined, module2), isLibrary, isRootNameOptionalInPath);
                }
                return (T)pathInfo;
            }
        });
    }
}

