/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(@NotNull AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        if (fieldUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldUpdater", "org/jetbrains/concurrency/PromiseManager", "<init>"));
        }
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(@NotNull Class<HOST> ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "org/jetbrains/concurrency/PromiseManager", "<init>"));
        }
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/concurrency/PromiseManager", "isUpToDate"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/concurrency/PromiseManager", "isUpToDate"));
        }
        return true;
    }

    @NotNull
    public abstract Promise<VALUE> load(@NotNull HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value);
        }
    }

    public final boolean has(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 != null && result2.getState() == Promise.State.FULFILLED;
    }

    @Nullable
    public final Promise.State getState(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 == null ? null : result2.getState();
    }

    @NotNull
    public final Promise<VALUE> get(HOST host) {
        Promise<VALUE> promise2 = this.get(host, true);
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "get"));
        }
        return promise2;
    }

    @NotNull
    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        Promise<VALUE> promise2 = this.getOrCreateAsyncResult(host, checkFreshness, true);
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "get"));
        }
        return promise2;
    }

    @NotNull
    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load2) {
        Promise promise2 = (Promise)this.fieldUpdater.get(host);
        if (promise2 == null) {
            promise2 = new AsyncPromise();
            if (!this.fieldUpdater.compareAndSet(host, null, (Object)promise2)) {
                Promise promise3 = (Promise)this.fieldUpdater.get(host);
                if (promise3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                }
                return promise3;
            }
        } else {
            Promise.State state = promise2.getState();
            if (state == Promise.State.PENDING) {
                Promise promise4 = promise2;
                if (promise4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                }
                return promise4;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(host, ((Getter)promise2).get())) {
                    Promise promise5 = promise2;
                    if (promise5 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                    }
                    return promise5;
                }
                if (!this.fieldUpdater.compareAndSet(host, (Object)promise2, (Object)(promise2 = new AsyncPromise()))) {
                    Promise valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, (Object)promise2)) {
                            Promise<VALUE> promise6 = this.getPromise(host, load2, promise2);
                            if (promise6 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                            }
                            return promise6;
                        }
                        valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    }
                    Promise promise7 = valueFromAnotherThread;
                    if (promise7 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
                    }
                    return promise7;
                }
            }
        }
        Promise<VALUE> promise8 = this.getPromise(host, load2, promise2);
        if (promise8 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getOrCreateAsyncResult"));
        }
        return promise8;
    }

    @NotNull
    private Promise<VALUE> getPromise(HOST host, boolean load2, Promise<VALUE> promise2) {
        if (!load2 || promise2.getState() != Promise.State.PENDING) {
            Promise<VALUE> promise3 = promise2;
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getPromise"));
            }
            return promise3;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise2) {
            this.fieldUpdater.compareAndSet(host, promise2, effectivePromise);
            effectivePromise.notify((AsyncPromise)promise2);
        }
        Promise<VALUE> promise4 = effectivePromise;
        if (promise4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/PromiseManager", "getPromise"));
        }
        return promise4;
    }
}

