/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/debugger/values/PrimitiveValue;", "Lorg/jetbrains/debugger/values/ValueBase;", "type", "Lorg/jetbrains/debugger/values/ValueType;", "value", "", "(Lorg/jetbrains/debugger/values/ValueType;I)V", "", "(Lorg/jetbrains/debugger/values/ValueType;J)V", "valueString", "", "(Lorg/jetbrains/debugger/values/ValueType;Ljava/lang/String;)V", "getValueString", "()Ljava/lang/String;", "Companion", "script-debugger-backend"})
public class PrimitiveValue
extends ValueBase {
    @NotNull
    private final String valueString;
    @NotNull
    private static final String NA_N_VALUE = "NaN";
    @NotNull
    private static final String INFINITY_VALUE = "Infinity";
    @JvmField
    @NotNull
    public static final PrimitiveValue NULL;
    @JvmField
    @NotNull
    public static final PrimitiveValue UNDEFINED;
    @NotNull
    private static final PrimitiveValue NAN;
    @NotNull
    private static final PrimitiveValue INFINITY;
    private static final PrimitiveValue TRUE;
    private static final PrimitiveValue FALSE;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getValueString() {
        return this.valueString;
    }

    public PrimitiveValue(@NotNull ValueType type, @NotNull String valueString) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)valueString, (String)"valueString");
        super(type);
        this.valueString = valueString;
    }

    public PrimitiveValue(@NotNull ValueType type, int value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        String string = Integer.toString(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(value)");
        this(type, string);
    }

    public PrimitiveValue(@NotNull ValueType type, long value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        String string = Long.toString(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long.toString(value)");
        this(type, string);
    }

    static {
        Companion = new Companion(null);
        NA_N_VALUE = NA_N_VALUE;
        INFINITY_VALUE = INFINITY_VALUE;
        NULL = new PrimitiveValue(ValueType.NULL, "null");
        UNDEFINED = new PrimitiveValue(ValueType.UNDEFINED, "undefined");
        NAN = new PrimitiveValue(ValueType.NUMBER, Companion.getNA_N_VALUE());
        INFINITY = new PrimitiveValue(ValueType.NUMBER, Companion.getINFINITY_VALUE());
        TRUE = new PrimitiveValue(ValueType.BOOLEAN, "true");
        FALSE = new PrimitiveValue(ValueType.BOOLEAN, "false");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/debugger/values/PrimitiveValue$Companion;", "", "()V", "FALSE", "Lorg/jetbrains/debugger/values/PrimitiveValue;", "getFALSE", "()Lorg/jetbrains/debugger/values/PrimitiveValue;", "INFINITY", "getINFINITY", "INFINITY_VALUE", "", "getINFINITY_VALUE", "()Ljava/lang/String;", "NAN", "getNAN", "NA_N_VALUE", "getNA_N_VALUE", "NULL", "TRUE", "getTRUE", "UNDEFINED", "bool", "value", "script-debugger-backend"})
    public static final class Companion {
        @NotNull
        public final String getNA_N_VALUE() {
            return NA_N_VALUE;
        }

        @NotNull
        public final String getINFINITY_VALUE() {
            return INFINITY_VALUE;
        }

        @NotNull
        public final PrimitiveValue getNAN() {
            return NAN;
        }

        @NotNull
        public final PrimitiveValue getINFINITY() {
            return INFINITY;
        }

        private final PrimitiveValue getTRUE() {
            return TRUE;
        }

        private final PrimitiveValue getFALSE() {
            return FALSE;
        }

        @NotNull
        public final PrimitiveValue bool(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"true") ? this.getTRUE() : this.getFALSE();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

