/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class Choreographer
implements ActionListener {
    private static final float NANOSECONDS_IN_SECOND = 1.0E9f;
    private static final float DEFAULT_FRAME_LENGTH = 0.016666668f;
    private final List<Animatable> mComponents;
    private final Timer mTimer;
    private boolean mUpdate;
    private long mFrameTime;
    private boolean mReset;
    @NotNull
    private final JComponent mParentContainer;

    public Choreographer(int fps, @NotNull JComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/adtui/Choreographer", "<init>"));
        }
        this.mParentContainer = parent;
        this.mComponents = new LinkedList<Animatable>();
        this.mUpdate = true;
        this.mTimer = new Timer(1000 / fps, this);
        this.mTimer.start();
    }

    public void register(Animatable animatable) {
        this.mComponents.add(animatable);
    }

    public void register(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "animatables", "com/android/tools/adtui/Choreographer", "register"));
        }
        this.mComponents.addAll(animatables);
    }

    public void toggleDebug(boolean isDebug) {
        for (Animatable component : this.mComponents) {
            if (!(component instanceof AnimatedComponent)) continue;
            ((AnimatedComponent)component).setDrawDebugInfo(isDebug);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        long now = System.nanoTime();
        float frame = (float)(now - this.mFrameTime) / 1.0E9f;
        this.mFrameTime = now;
        if (!this.mUpdate) {
            return;
        }
        this.step(frame);
    }

    public static void animate(AnimatedComponent component) {
        Choreographer choreographer = new Choreographer(30, component);
        choreographer.register(component);
        HierarchyListener listener = event -> {
            if (choreographer.mTimer.isRunning() && !component.isShowing()) {
                choreographer.mTimer.stop();
            } else if (!choreographer.mTimer.isRunning() && component.isShowing()) {
                choreographer.mTimer.start();
            }
        };
        listener.hierarchyChanged(null);
        component.addHierarchyListener(listener);
    }

    public void setUpdate(boolean update) {
        this.mUpdate = update;
    }

    public void step() {
        this.step(0.016666668f);
    }

    public void reset() {
        this.mReset = true;
    }

    private void step(float frameLength) {
        if (this.mReset) {
            for (Animatable component : this.mComponents) {
                component.reset();
            }
            this.mReset = false;
        }
        for (Animatable component : this.mComponents) {
            component.animate(frameLength);
        }
        for (Animatable component : this.mComponents) {
            component.postAnimate();
        }
        this.mParentContainer.repaint();
    }

    public static float lerp(float from, float to, float fraction, float frameLength, float threshold) {
        if (Math.abs(to - from) < threshold) {
            return to;
        }
        float q = (float)Math.pow(1.0f - fraction, frameLength);
        return from * q + to * (1.0f - q);
    }

    public static double lerp(double from, double to, float fraction, float frameLength, float threshold) {
        if (Math.abs(to - from) < (double)threshold) {
            return to;
        }
        double q = Math.pow(1.0f - fraction, frameLength);
        return from * q + to * (1.0 - q);
    }

    public static float lerp(float from, float to, float fraction, float frameLength) {
        return Choreographer.lerp(from, to, fraction, frameLength, 0.0f);
    }

    public static double lerp(double from, double to, float fraction, float frameLength) {
        return Choreographer.lerp(from, to, fraction, frameLength, 0.0f);
    }
}

