/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import gnu.trove.TFloatArrayList;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GridComponent
extends AnimatedComponent {
    @NotNull
    private List<AxisComponent> mAxes = new ArrayList<AxisComponent>();

    public void addAxis(AxisComponent axis) {
        this.mAxes.add(axis);
    }

    @Override
    protected void updateData() {
    }

    @Override
    protected void draw(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(AdtUiUtils.GRID_COLOR);
        Dimension dim = this.getSize();
        Line2D.Float line = new Line2D.Float();
        block4: for (AxisComponent axis : this.mAxes) {
            TFloatArrayList markers = axis.getMajorMarkerPositions();
            switch (axis.getOrientation()) {
                case LEFT: 
                case RIGHT: {
                    int j;
                    for (j = 0; j < markers.size(); ++j) {
                        line.setLine(0.0f, (float)(dim.height - 1) * (1.0f - markers.get(j)), dim.width - 1, (float)(dim.height - 1) * (1.0f - markers.get(j)));
                        g.draw(line);
                    }
                    continue block4;
                }
                case TOP: 
                case BOTTOM: {
                    int j;
                    for (j = 0; j < markers.size(); ++j) {
                        line.setLine((float)(dim.width - 1) * markers.get(j), 0.0f, (float)(dim.width - 1) * markers.get(j), dim.height - 1);
                        g.draw(line);
                    }
                    break;
                }
            }
        }
    }
}

