/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ImagePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignImage;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;

public class CursorPropertyMetadata
extends ComplexPropertyMetadata<Cursor> {
    private final DoublePropertyMetadata hotspotXMetadata = new DoublePropertyMetadata(new PropertyName("hotspotX"), DoublePropertyMetadata.DoubleKind.COORDINATE, true, 0.0, InspectorPath.UNUSED);
    private final DoublePropertyMetadata hotspotYMetadata = new DoublePropertyMetadata(new PropertyName("hotspotY"), DoublePropertyMetadata.DoubleKind.COORDINATE, true, 0.0, InspectorPath.UNUSED);
    private final ImagePropertyMetadata imageMetadata = new ImagePropertyMetadata(new PropertyName("image"), true, null, InspectorPath.UNUSED);
    private static Map<Cursor, String> cursorMap;

    public CursorPropertyMetadata(PropertyName name, boolean readWrite, Cursor defaultValue, InspectorPath inspectorPath) {
        super(name, Cursor.class, readWrite, defaultValue, inspectorPath);
    }

    public static synchronized Map<Cursor, String> getCursorMap() {
        if (cursorMap == null) {
            cursorMap = new HashMap<Cursor, String>();
            cursorMap.put(Cursor.CLOSED_HAND, "CLOSED_HAND");
            cursorMap.put(Cursor.CROSSHAIR, "CROSSHAIR");
            cursorMap.put(Cursor.DEFAULT, "DEFAULT");
            cursorMap.put(Cursor.DISAPPEAR, "DISAPPEAR");
            cursorMap.put(Cursor.E_RESIZE, "E_RESIZE");
            cursorMap.put(Cursor.HAND, "HAND");
            cursorMap.put(Cursor.H_RESIZE, "H_RESIZE");
            cursorMap.put(Cursor.MOVE, "MOVE");
            cursorMap.put(Cursor.NE_RESIZE, "NE_RESIZE");
            cursorMap.put(Cursor.NONE, "NONE");
            cursorMap.put(Cursor.NW_RESIZE, "NW_RESIZE");
            cursorMap.put(Cursor.N_RESIZE, "N_RESIZE");
            cursorMap.put(Cursor.OPEN_HAND, "OPEN_HAND");
            cursorMap.put(Cursor.SE_RESIZE, "SE_RESIZE");
            cursorMap.put(Cursor.SW_RESIZE, "SW_RESIZE");
            cursorMap.put(Cursor.S_RESIZE, "S_RESIZE");
            cursorMap.put(Cursor.TEXT, "TEXT");
            cursorMap.put(Cursor.V_RESIZE, "V_RESIZE");
            cursorMap.put(Cursor.WAIT, "WAIT");
            cursorMap.put(Cursor.W_RESIZE, "W_RESIZE");
            cursorMap = Collections.unmodifiableMap(cursorMap);
        }
        return cursorMap;
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(Cursor value, FXOMDocument fxomDocument) {
        FXOMInstance result;
        String cursorName = CursorPropertyMetadata.getCursorMap().get(value);
        if (cursorName != null) {
            result = new FXOMInstance(fxomDocument, Cursor.class);
            result.setFxConstant(cursorName);
        } else if (value instanceof ImageCursor) {
            ImageCursor imageCursor = (ImageCursor)value;
            result = new FXOMInstance(fxomDocument, ImageCursor.class);
            this.hotspotXMetadata.setValue(result, imageCursor.getHotspotX());
            this.hotspotYMetadata.setValue(result, imageCursor.getHotspotY());
            this.imageMetadata.setValue(result, new DesignImage(imageCursor.getImage()));
        } else {
            assert (false);
            result = new FXOMInstance(fxomDocument, Cursor.class);
            result.setFxConstant(CursorPropertyMetadata.getCursorMap().get(Cursor.DEFAULT));
        }
        return result;
    }
}

