/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.checks.SecurityDetector;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.XmlContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Element;

public class PreferenceActivityDetector
extends Detector
implements Detector.XmlScanner,
Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("ExportedPreferenceActivity", "PreferenceActivity should not be exported", "Fragment injection gives anyone who can send your PreferenceActivity an intent the ability to load any fragment, with any arguments, in your process.", Category.SECURITY, 8, Severity.WARNING, new Implementation(PreferenceActivityDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE))).addMoreInfo("http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection");
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    private final Map<String, Location.Handle> mExportedActivities = new HashMap<String, Location.Handle>();

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("activity");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String fqcn;
        if (SecurityDetector.getExported(element) && (fqcn = PreferenceActivityDetector.getFqcn(element)) != null) {
            if (fqcn.equals(PREFERENCE_ACTIVITY) && !context.getDriver().isSuppressed(context, ISSUE, element)) {
                String message = "`PreferenceActivity` should not be exported";
                context.report(ISSUE, element, context.getLocation(element), message);
            }
            this.mExportedActivities.put(fqcn, context.createLocationHandle(element));
        }
    }

    private static String getFqcn(Element activityElement) {
        String activityClassName = activityElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (activityClassName == null || activityClassName.isEmpty()) {
            return null;
        }
        if (activityClassName.startsWith(".")) {
            String pkg = activityElement.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (pkg != null) {
                return pkg + activityClassName;
            }
            return null;
        }
        return activityClassName;
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(PREFERENCE_ACTIVITY);
    }

    @Override
    public void checkClass(JavaContext context, UClass declaration2) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        String className = declaration2.getQualifiedName();
        if (InheritanceUtil.isInheritor((PsiClass)declaration2, (boolean)false, (String)PREFERENCE_ACTIVITY) && this.mExportedActivities.containsKey(className)) {
            if (context.getMainProject().getTargetSdk() >= 19 && PreferenceActivityDetector.overridesIsValidFragment(evaluator, (PsiClass)declaration2)) {
                return;
            }
            String message = String.format("`PreferenceActivity` subclass `%1$s` should not be exported", className);
            Location location = this.mExportedActivities.get(className).resolve();
            context.reportUast(ISSUE, (UElement)declaration2, location, message);
        }
    }

    private static boolean overridesIsValidFragment(JavaEvaluator evaluator, PsiClass resolvedClass) {
        for (PsiMethod method : resolvedClass.findMethodsByName(IS_VALID_FRAGMENT, false)) {
            if (!evaluator.parametersMatch(method, "java.lang.String")) continue;
            return true;
        }
        return false;
    }
}

