/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.config.TaskRepositoriesConfigurable;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class TaskSearchSupport {
    static final String TASKS_NOTIFICATION_GROUP = "Task Group";

    private TaskSearchSupport() {
    }

    public static List<Task> getLocalAndCachedTasks(TaskManager myManager, String pattern, boolean withClosed) {
        ArrayList tasks = new ArrayList();
        ContainerUtil.addAll(tasks, (Iterable)myManager.getLocalTasks(withClosed));
        ContainerUtil.addAll(tasks, (Iterable)ContainerUtil.filter((Collection)myManager.getCachedIssues(withClosed), task -> myManager.findTask(task.getId()) == null));
        List filteredTasks = TaskUtil.filterTasks((String)pattern, tasks);
        ContainerUtil.sort((List)filteredTasks, (Comparator)TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        return filteredTasks;
    }

    public static List<Task> getRepositoriesTasks(Project project, String pattern, int offset, int limit, boolean forceRequest, boolean withClosed, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelled", "com/intellij/tasks/actions/TaskSearchSupport", "getRepositoriesTasks"));
        }
        try {
            TaskManager manager = TaskManager.getManager((Project)project);
            List tasks = manager.getIssues(pattern, offset, limit, withClosed, cancelled, forceRequest);
            ContainerUtil.sort((List)tasks, (Comparator)TaskManagerImpl.TASK_UPDATE_COMPARATOR);
            return tasks;
        }
        catch (RequestFailedException e) {
            TaskSearchSupport.notifyAboutConnectionFailure(e, project);
            return Collections.emptyList();
        }
    }

    public static List<Task> getItems(TaskManager myManager, String pattern, boolean cached, boolean autopopup) {
        return TaskUtil.filterTasks((String)pattern, TaskSearchSupport.getTasks(pattern, cached, autopopup, myManager));
    }

    private static List<Task> getTasks(String pattern, boolean cached, boolean autopopup, TaskManager myManager) {
        return cached ? myManager.getCachedIssues() : myManager.getIssues(pattern, !autopopup);
    }

    private static void notifyAboutConnectionFailure(RequestFailedException e, final Project project) {
        String details = e.getMessage();
        final TaskRepository repository = e.getRepository();
        Notifications.Bus.register((String)TASKS_NOTIFICATION_GROUP, (NotificationDisplayType)NotificationDisplayType.BALLOON);
        String content = "<p><a href=\"\">Configure server...</a></p>";
        if (!StringUtil.isEmpty((String)details)) {
            content = "<p>" + details + "</p>" + content;
        }
        Notifications.Bus.notify((Notification)new Notification(TASKS_NOTIFICATION_GROUP, "Cannot connect to " + repository.getUrl(), content, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/tasks/actions/TaskSearchSupport$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/tasks/actions/TaskSearchSupport$1", "hyperlinkUpdate"));
                }
                TaskRepositoriesConfigurable configurable = new TaskRepositoriesConfigurable(project);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                if (!ArrayUtil.contains((Object)repository, (Object[])TaskManager.getManager((Project)project).getAllRepositories())) {
                    notification.expire();
                }
            }
        }), (Project)project);
    }
}

