/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.BaseExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.FailureResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptorImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.TaskOperationDescriptorImpl;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptorImpl;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.jetbrains.annotations.NotNull;

public class GradleProgressEventConverter {
    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(ExternalSystemTaskId id, ProgressEvent event) {
        String eventId;
        InternalOperationDescriptor internalDesc = event.getDescriptor() instanceof DefaultOperationDescriptor ? ((DefaultOperationDescriptor)event.getDescriptor()).getInternalOperationDescriptor() : null;
        String string = eventId = internalDesc == null ? event.getDescriptor().getDisplayName() : internalDesc.getId().toString();
        String parentEventId = event.getDescriptor().getParent() == null ? null : (internalDesc == null ? event.getDescriptor().getParent().getDisplayName() : internalDesc.getParentId().toString());
        String description = event.getDescriptor().getName();
        if (event instanceof StartEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemStartEventImpl(eventId, parentEventId, descriptor));
            if (externalSystemTaskExecutionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
            }
            return externalSystemTaskExecutionEvent;
        }
        if (event instanceof StatusEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            StatusEvent statusEvent = (StatusEvent)event;
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemStatusEventImpl(eventId, parentEventId, descriptor, statusEvent.getTotal(), statusEvent.getProgress(), statusEvent.getUnit()));
            if (externalSystemTaskExecutionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
            }
            return externalSystemTaskExecutionEvent;
        }
        if (event instanceof FinishEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemFinishEventImpl(eventId, parentEventId, descriptor, GradleProgressEventConverter.convert(((FinishEvent)event).getResult())));
            if (externalSystemTaskExecutionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
            }
            return externalSystemTaskExecutionEvent;
        }
        if (event instanceof TaskProgressEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new BaseExternalSystemProgressEvent(eventId, parentEventId, descriptor));
            if (externalSystemTaskExecutionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
            }
            return externalSystemTaskExecutionEvent;
        }
        ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent = new ExternalSystemTaskNotificationEvent(id, description);
        if (externalSystemTaskNotificationEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
        }
        return externalSystemTaskNotificationEvent;
    }

    private static OperationDescriptor convert(org.gradle.tooling.events.OperationDescriptor descriptor, long eventTime) {
        if (descriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor testOperationDescriptor = (JvmTestOperationDescriptor)descriptor;
            return new TestOperationDescriptorImpl(descriptor.getName(), eventTime, testOperationDescriptor.getSuiteName(), testOperationDescriptor.getClassName(), testOperationDescriptor.getMethodName());
        }
        if (descriptor instanceof TaskOperationDescriptor) {
            TaskOperationDescriptor testOperationDescriptor = (TaskOperationDescriptor)descriptor;
            return new TaskOperationDescriptorImpl(descriptor.getName(), eventTime, testOperationDescriptor.getTaskPath());
        }
        return new OperationDescriptorImpl(descriptor.getName(), eventTime);
    }

    @NotNull
    private static OperationResult convert(org.gradle.tooling.events.OperationResult operationResult) {
        if (operationResult instanceof FailureResult) {
            FailureResultImpl failureResultImpl = new FailureResultImpl(operationResult.getStartTime(), operationResult.getEndTime());
            if (failureResultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
            }
            return failureResultImpl;
        }
        if (operationResult instanceof SkippedResult) {
            SkippedResultImpl skippedResultImpl = new SkippedResultImpl(operationResult.getStartTime(), operationResult.getEndTime());
            if (skippedResultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
            }
            return skippedResultImpl;
        }
        boolean isUpToDate = operationResult instanceof TaskSuccessResult && ((TaskSuccessResult)operationResult).isUpToDate();
        SuccessResultImpl successResultImpl = new SuccessResultImpl(operationResult.getStartTime(), operationResult.getEndTime(), isUpToDate);
        if (successResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter", "convert"));
        }
        return successResultImpl;
    }
}

