/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupportedImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.UnsupportedCancellationToken;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTaskManager
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = ContainerUtil.newConcurrentMap();

    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String jvmAgentSetup, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, taskNames, projectPath, settings, jvmAgentSetup, listener)) continue;
                return;
            }
        }
        GradleExecutionSettings effectiveSettings = settings == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings;
        Function f = connection -> {
            if (taskNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (projectPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            try {
                GradleVersion gradleVersion;
                GradleProjectResolverExtension projectResolverChain;
                ArrayList initScripts = ContainerUtil.newArrayList();
                for (GradleProjectResolverExtension resolverExtension = projectResolverChain = GradleProjectResolver.createProjectResolverChain(effectiveSettings); resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
                    String resolverClassName = resolverExtension.getClass().getName();
                    resolverExtension.enhanceTaskProcessing(taskNames, jvmAgentSetup, (Consumer<String>)((Consumer)script -> {
                        if (StringUtil.isNotEmpty((String)script)) {
                            ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                        }
                    }));
                }
                String initScript = (String)effectiveSettings.getUserData(INIT_SCRIPT_KEY);
                if (StringUtil.isNotEmpty((String)initScript)) {
                    ContainerUtil.addAll((Collection)initScripts, (Object[])new String[]{"//-- Additional script", initScript, "//"});
                }
                if (!initScripts.isEmpty()) {
                    try {
                        File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((Collection)initScripts, (String)SystemProperties.getLineSeparator()));
                        effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
                    }
                    catch (IOException e) {
                        throw new ExternalSystemException((Throwable)e);
                    }
                }
                if ((gradleVersion = GradleExecutionHelper.getGradleVersion(connection, id, listener)) != null && gradleVersion.compareTo(GradleVersion.version((String)"2.5")) < 0) {
                    listener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemProgressEventUnsupportedImpl(gradleVersion + " does not support executions view")));
                }
                for (GradleBuildParticipant buildParticipant : effectiveSettings.getExecutionWorkspace().getBuildParticipants()) {
                    effectiveSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
                }
                BuildLauncher launcher = this.myHelper.getBuildLauncher(id, (ProjectConnection)connection, effectiveSettings, listener);
                launcher.forTasks(ArrayUtil.toStringArray((Collection)taskNames));
                if (gradleVersion != null && gradleVersion.compareTo(GradleVersion.version((String)"2.1")) < 0) {
                    this.myCancellationMap.put(id, new UnsupportedCancellationToken());
                } else {
                    CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
                    launcher.withCancellationToken(cancellationTokenSource.token());
                    this.myCancellationMap.put(id, cancellationTokenSource);
                }
                try {
                    launcher.run();
                }
                finally {
                    this.myCancellationMap.remove(id);
                }
                return null;
            }
            catch (RuntimeException e) {
                LOG.debug("Gradle build launcher error", (Throwable)e);
                ExternalSystemException friendlyError = new GradleExecutionErrorHandler(e, projectPath, null).getUserFriendlyError();
                throw friendlyError == null ? e : friendlyError;
            }
        };
        this.myHelper.execute(projectPath, effectiveSettings, f);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "cancelTask"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "cancelTask"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener)) continue;
                return true;
            }
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
        }
        return true;
    }
}

